/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.identifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Sha256Hash;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.identifier.errors.IdentifierException;
import org.dashj.platform.dpp.util.Cbor;
import org.dashj.platform.dpp.util.Converters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\u0007H\u00c2\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0006\u0010\u000b\u001a\u00020\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/dashj/platform/dpp/identifier/Identifier;", "", "identifier", "Lorg/dashj/platform/sdk/Identifier;", "Lorg/dashj/platform/dpp/identifier/RustIdentifier;", "(Lorg/dashj/platform/sdk/Identifier;)V", "buffer", "", "([B)V", "component1", "copy", "encodeCBOR", "equals", "", "other", "hashCode", "", "toBuffer", "toJSON", "", "toNative", "toSha256Hash", "Lorg/bitcoinj/core/Sha256Hash;", "toString", "encoding", "Companion", "dpp"})
public final class Identifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] buffer;
    @NotNull
    public static final String MEDIA_TYPE = "application/x.dash.dpp.identifier";
    public static final int IDENTIFIER_LENGTH = 32;

    public Identifier(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        if (this.buffer.length != 32) {
            throw new IdentifierException("Identifier must be 32 bytes");
        }
    }

    public Identifier(@NotNull org.dashj.platform.sdk.Identifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        byte[] byArray = identifier.get_0().get_0();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"identifier._0._0");
        this(byArray);
    }

    @NotNull
    public final byte[] toBuffer() {
        return this.buffer;
    }

    @NotNull
    public final Sha256Hash toSha256Hash() {
        Sha256Hash sha256Hash = Sha256Hash.wrap((byte[])this.buffer);
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"wrap(buffer)");
        return sha256Hash;
    }

    @NotNull
    public final byte[] encodeCBOR() {
        return Cbor.INSTANCE.encode(this.buffer);
    }

    @NotNull
    public final String toJSON() {
        return this.toString();
    }

    @NotNull
    public String toString() {
        return this.toString("base58");
    }

    @NotNull
    public final String toString(@NotNull String encoding) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        if (Intrinsics.areEqual((Object)encoding, (Object)"base58")) {
            String string2 = Base58.encode((byte[])this.buffer);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(buffer)");
        } else {
            string = ExtensionsKt.toBase64(this.buffer);
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        return object instanceof Identifier ? Arrays.equals(this.buffer, ((Identifier)other).buffer) : (object instanceof byte[] ? Arrays.equals(this.buffer, (byte[])other) : (object instanceof String ? Intrinsics.areEqual((Object)this.toString(), (Object)other) : (object instanceof Sha256Hash ? Arrays.equals(this.buffer, ((Sha256Hash)other).getBytes()) : false)));
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    @NotNull
    public final org.dashj.platform.sdk.Identifier toNative() {
        return new org.dashj.platform.sdk.Identifier(this.buffer);
    }

    private final byte[] component1() {
        return this.buffer;
    }

    @NotNull
    public final Identifier copy(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return new Identifier(buffer);
    }

    public static /* synthetic */ Identifier copy$default(Identifier identifier, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = identifier.buffer;
        }
        return identifier.copy(byArray);
    }

    @JvmStatic
    @NotNull
    public static final Identifier from(@Nullable Object any, @NotNull String encoding) {
        return Companion.from(any, encoding);
    }

    @JvmStatic
    @NotNull
    public static final Identifier from(@NotNull byte[] buffer) {
        return Companion.from(buffer);
    }

    @JvmStatic
    @NotNull
    public static final Identifier from(@NotNull Sha256Hash hash) {
        return Companion.from(hash);
    }

    @JvmStatic
    @NotNull
    public static final List<Identifier> fromList(@NotNull List<? extends Object> bufferList, @NotNull String encoding) {
        return Companion.fromList(bufferList, encoding);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\n\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\b\b\u0002\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/dashj/platform/dpp/identifier/Identifier$Companion;", "", "()V", "IDENTIFIER_LENGTH", "", "MEDIA_TYPE", "", "from", "Lorg/dashj/platform/dpp/identifier/Identifier;", "any", "encoding", "buffer", "", "hash", "Lorg/bitcoinj/core/Sha256Hash;", "fromList", "", "bufferList", "dpp"})
    @SourceDebugExtension(value={"SMAP\nIdentifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Identifier.kt\norg/dashj/platform/dpp/identifier/Identifier$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 Identifier.kt\norg/dashj/platform/dpp/identifier/Identifier$Companion\n*L\n58#1:118\n58#1:119,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Identifier from(@Nullable Object any, @NotNull String encoding) {
            Identifier identifier;
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            Object object = any;
            if (object instanceof String) {
                if (Intrinsics.areEqual((Object)encoding, (Object)"base58")) {
                    byte[] byArray = Base58.decode((String)((String)any));
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(any)");
                    identifier = new Identifier(byArray);
                } else {
                    identifier = new Identifier(Converters.fromBase64((String)any));
                }
            } else if (object instanceof byte[]) {
                identifier = new Identifier((byte[])any);
            } else if (object instanceof Identifier) {
                identifier = (Identifier)any;
            } else if (object instanceof Sha256Hash) {
                byte[] byArray = ((Sha256Hash)any).getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"any.bytes");
                identifier = new Identifier(byArray);
            } else if (object instanceof org.dashj.platform.sdk.Identifier) {
                byte[] byArray = ((org.dashj.platform.sdk.Identifier)any).get_0().get_0();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"any._0._0");
                identifier = new Identifier(byArray);
            } else {
                throw new IllegalStateException("any is not String, ByteArray, Identifier or Sha256Hash".toString());
            }
            return identifier;
        }

        public static /* synthetic */ Identifier from$default(Companion companion, Object object, String string, int n, Object object2) {
            if ((n & 2) != 0) {
                string = "base58";
            }
            return companion.from(object, string);
        }

        @JvmStatic
        @NotNull
        public final Identifier from(@NotNull byte[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return new Identifier(buffer);
        }

        @JvmStatic
        @NotNull
        public final Identifier from(@NotNull Sha256Hash hash) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            byte[] byArray = hash.getBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hash.bytes");
            return new Identifier(byArray);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Identifier> fromList(@NotNull List<? extends Object> bufferList, @NotNull String encoding) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(bufferList, (String)"bufferList");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            Iterable $this$map$iv = bufferList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.from(it, encoding));
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List fromList$default(Companion companion, List list, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "base58";
            }
            return companion.fromList(list, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

