/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.identity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.quorums.InstantSendLock;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.Factory;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.AssetLockProof;
import org.dashj.platform.dpp.identity.ChainAssetLockProof;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityCreateTransition;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.identity.IdentityStateTransition;
import org.dashj.platform.dpp.identity.IdentityTopUpTransition;
import org.dashj.platform.dpp.identity.IdentityUpdateTransition;
import org.dashj.platform.dpp.identity.InstantAssetLockProof;
import org.dashj.platform.dpp.statetransition.AssetLockProofFactory;
import org.dashj.platform.dpp.util.CreditsConverter;
import org.dashj.platform.dpp.validation.ValidationResult;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SecurityLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J,\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J,\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00192\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u001d0\u0012J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018J\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020$2\b\b\u0002\u0010'\u001a\u00020(J\u001c\u0010)\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020*0\u0012J&\u0010+\u001a\u00020\b2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\b\b\u0002\u0010'\u001a\u00020(J\u001c\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010-\u001a\u00020.2\u0006\u00101\u001a\u00020\bJ\u0016\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001bJ.\u00104\u001a\u0002052\u0006\u00101\u001a\u00020\b2\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u000e\u00107\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J\"\u00104\u001a\u0002052\u0006\u00101\u001a\u00020\b2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\"J\u001c\u0010@\u001a\u00020A2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dJ\u000e\u0010@\u001a\u00020A2\u0006\u00101\u001a\u00020\b\u00a8\u0006\u0002"}, d2={"Lorg/dashj/platform/dpp/identity/IdentityFactory;", "Lorg/dashj/platform/dpp/Factory;", "dpp", "Lorg/dashj/platform/dpp/DashPlatformProtocol;", "stateRepository", "Lorg/dashj/platform/dpp/StateRepository;", "(Lorg/dashj/platform/dpp/DashPlatformProtocol;Lorg/dashj/platform/dpp/StateRepository;)V", "applyIdentityCreateStateTransition", "Lorg/dashj/platform/dpp/identity/Identity;", "stateTransition", "Lorg/dashj/platform/dpp/identity/IdentityStateTransition;", "applyIdentityTopUpTransition", "", "Lorg/dashj/platform/dpp/identity/IdentityTopUpTransition;", "create", "id", "", "publicKeys", "", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "revision", "", "protocolVersion", "lockedOutPoint", "Lorg/bitcoinj/core/TransactionOutPoint;", "Lorg/dashj/platform/dpp/identifier/Identifier;", "assetLockProof", "Lorg/dashj/platform/dpp/identity/AssetLockProof;", "publicKeyConfigs", "", "", "createChainAssetLockProof", "Lorg/dashj/platform/dpp/identity/ChainAssetLockProof;", "coreChainLockedHeight", "", "outPoint", "", "createFromBuffer", "payload", "options", "Lorg/dashj/platform/dpp/Factory$Options;", "createFromKeyList", "Lorg/bitcoinj/core/ECKey;", "createFromObject", "rawIdentity", "createIdentityCreateTransition", "Lorg/dashj/platform/dpp/identity/IdentityCreateTransition;", "assetLock", "identityPublicKeys", "identity", "createIdentityTopUpTransition", "identityId", "createIdentityUpdateTransition", "Lorg/dashj/platform/dpp/identity/IdentityUpdateTransition;", "publicKeysToAdd", "publicKeysToDisable", "rawPublicKeys", "createInstantAssetLockProof", "Lorg/dashj/platform/dpp/identity/InstantAssetLockProof;", "instantSendLock", "Lorg/bitcoinj/quorums/InstantSendLock;", "assetLockTransaction", "Lorg/bitcoinj/core/Transaction;", "outputIndex", "validate", "Lorg/dashj/platform/dpp/validation/ValidationResult;"})
@SourceDebugExtension(value={"SMAP\nIdentityFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityFactory.kt\norg/dashj/platform/dpp/identity/IdentityFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1559#2:210\n1590#2,4:211\n1549#2:215\n1620#2,3:216\n1549#2:219\n1620#2,3:220\n1549#2:223\n1620#2,3:224\n1549#2:227\n1620#2,3:228\n1549#2:231\n1620#2,3:232\n*S KotlinDebug\n*F\n+ 1 IdentityFactory.kt\norg/dashj/platform/dpp/identity/IdentityFactory\n*L\n50#1:210\n50#1:211,4\n70#1:215\n70#1:216,3\n139#1:219\n139#1:220,3\n153#1:223\n153#1:224,3\n170#1:227\n170#1:228,3\n176#1:231\n176#1:232,3\n*E\n"})
public final class IdentityFactory
extends Factory {
    public IdentityFactory(@NotNull DashPlatformProtocol dpp, @NotNull StateRepository stateRepository) {
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        super(dpp, stateRepository);
    }

    @NotNull
    public final Identity create(@NotNull TransactionOutPoint lockedOutPoint, @NotNull List<IdentityPublicKey> publicKeys, int revision, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)lockedOutPoint, (String)"lockedOutPoint");
        Intrinsics.checkNotNullParameter(publicKeys, (String)"publicKeys");
        Sha256Hash sha256Hash = lockedOutPoint.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"lockedOutPoint.hash");
        Identifier id = Identifier.Companion.from(sha256Hash);
        return new Identity(id, publicKeys, 0L, revision, protocolVersion);
    }

    @NotNull
    public final Identity create(@NotNull Identifier id, @NotNull List<IdentityPublicKey> publicKeys, int revision, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(publicKeys, (String)"publicKeys");
        return new Identity(id, publicKeys, 0L, revision, protocolVersion);
    }

    @NotNull
    public final Identity create(@NotNull String id, @NotNull List<IdentityPublicKey> publicKeys, int revision, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(publicKeys, (String)"publicKeys");
        return new Identity(Identifier.Companion.from$default(Identifier.Companion, id, null, 2, null), publicKeys, 0L, revision, protocolVersion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Identity createFromKeyList(@NotNull AssetLockProof assetLockProof, @NotNull List<? extends ECKey> publicKeys) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)assetLockProof, (String)"assetLockProof");
        Intrinsics.checkNotNullParameter(publicKeys, (String)"publicKeys");
        Iterable iterable = publicKeys;
        Identifier identifier = assetLockProof.createIdentifier();
        boolean $i$f$mapIndexed = false;
        void var5_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ECKey eCKey = (ECKey)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray = it.getPubKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.pubKey");
            collection.add(new IdentityPublicKey((int)index, KeyType.ECDSA_SECP256K1, Purpose.AUTHENTICATION, SecurityLevel.MASTER, byArray, false, null, null, 192, null));
        }
        int n = 1;
        int n3 = 0;
        long l = 0L;
        List list = (List)destination$iv$iv;
        Identifier identifier2 = identifier;
        return new Identity(identifier2, list, l, n3, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Identity create(@NotNull AssetLockProof assetLockProof, @NotNull List<? extends Map<String, ? extends Object>> publicKeyConfigs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)assetLockProof, (String)"assetLockProof");
        Intrinsics.checkNotNullParameter(publicKeyConfigs, (String)"publicKeyConfigs");
        Iterable iterable = publicKeyConfigs;
        Identifier identifier = assetLockProof.createIdentifier();
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void publicKey;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IdentityPublicKey((Map<String, ? extends Object>)publicKey));
        }
        int n = 1;
        int n2 = 0;
        long l = 0L;
        List list = (List)destination$iv$iv;
        Identifier identifier2 = identifier;
        Identity identity = new Identity(identifier2, list, l, n2, n);
        identity.setAssetLockProof(assetLockProof);
        return identity;
    }

    @NotNull
    public final Identity createFromObject(@NotNull Map<String, ? extends Object> rawIdentity, @NotNull Factory.Options options) {
        Intrinsics.checkNotNullParameter(rawIdentity, (String)"rawIdentity");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new Identity(rawIdentity);
    }

    public static /* synthetic */ Identity createFromObject$default(IdentityFactory identityFactory, Map map, Factory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Factory.Options(false, 1, null);
        }
        return identityFactory.createFromObject(map, options);
    }

    @NotNull
    public final Identity createFromBuffer(@NotNull byte[] payload, @NotNull Factory.Options options) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(payload);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawIdentity = (Map)pair.component2();
        Integer n = protocolVersion;
        rawIdentity.put("protocolVersion", n);
        return this.createFromObject(rawIdentity, options);
    }

    public static /* synthetic */ Identity createFromBuffer$default(IdentityFactory identityFactory, byte[] byArray, Factory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Factory.Options(false, 1, null);
        }
        return identityFactory.createFromBuffer(byArray, options);
    }

    @NotNull
    public final InstantAssetLockProof createInstantAssetLockProof(@NotNull InstantSendLock instantSendLock, @NotNull Transaction assetLockTransaction, long outputIndex) {
        Intrinsics.checkNotNullParameter((Object)instantSendLock, (String)"instantSendLock");
        Intrinsics.checkNotNullParameter((Object)assetLockTransaction, (String)"assetLockTransaction");
        return new InstantAssetLockProof(outputIndex, assetLockTransaction, instantSendLock);
    }

    @NotNull
    public final ChainAssetLockProof createChainAssetLockProof(long coreChainLockedHeight, @NotNull TransactionOutPoint outPoint) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        return new ChainAssetLockProof(coreChainLockedHeight, outPoint);
    }

    @NotNull
    public final ChainAssetLockProof createChainAssetLockProof(long coreChainLockedHeight, @NotNull byte[] outPoint) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        return new ChainAssetLockProof(this.getDpp().getNetworkParameters(), coreChainLockedHeight, outPoint);
    }

    @NotNull
    public final IdentityCreateTransition createIdentityCreateTransition(@NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        NetworkParameters networkParameters = this.getDpp().getNetworkParameters();
        AssetLockProof assetLockProof = identity.getAssetLockProof();
        Intrinsics.checkNotNull((Object)assetLockProof);
        return new IdentityCreateTransition(networkParameters, assetLockProof, identity.getPublicKeys(), 1);
    }

    @NotNull
    public final IdentityCreateTransition createIdentityCreateTransition(@NotNull AssetLockProof assetLock, @NotNull List<IdentityPublicKey> identityPublicKeys) {
        Intrinsics.checkNotNullParameter((Object)assetLock, (String)"assetLock");
        Intrinsics.checkNotNullParameter(identityPublicKeys, (String)"identityPublicKeys");
        return new IdentityCreateTransition(this.getDpp().getNetworkParameters(), assetLock, identityPublicKeys, 0, 8, null);
    }

    @NotNull
    public final IdentityTopUpTransition createIdentityTopUpTransition(@NotNull Identifier identityId, @NotNull AssetLockProof assetLock) {
        Intrinsics.checkNotNullParameter((Object)identityId, (String)"identityId");
        Intrinsics.checkNotNullParameter((Object)assetLock, (String)"assetLock");
        return new IdentityTopUpTransition(this.getDpp().getNetworkParameters(), identityId, assetLock, 0, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdentityUpdateTransition createIdentityUpdateTransition(@NotNull Identity identity, @NotNull Map<String, ? extends Object> rawPublicKeys) {
        List list;
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter(rawPublicKeys, (String)"rawPublicKeys");
        IdentityFactory identityFactory = this;
        Identity identity2 = identity;
        Object object = rawPublicKeys.get("add");
        List list2 = object instanceof List ? (List)object : null;
        if (list2 != null) {
            Collection<IdentityPublicKey> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = list2;
            Identity identity3 = identity2;
            IdentityFactory identityFactory2 = identityFactory;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pk;
                Map map = (Map)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IdentityPublicKey((Map<String, ? extends Object>)pk));
            }
            collection = (List)destination$iv$iv;
            identityFactory = identityFactory2;
            identity2 = identity3;
            list = collection;
        } else {
            list = null;
        }
        Object object2 = rawPublicKeys.get("disablePublicKeys");
        return identityFactory.createIdentityUpdateTransition(identity2, list, object2 instanceof List ? (List)object2 : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdentityUpdateTransition createIdentityUpdateTransition(@NotNull Identity identity, @Nullable List<IdentityPublicKey> publicKeysToAdd, @Nullable List<IdentityPublicKey> publicKeysToDisable) {
        Collection<Integer> collection;
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        NetworkParameters networkParameters = this.getDpp().getParams();
        Identifier identifier = identity.getId();
        int n = identity.getRevision() + 1;
        List<IdentityPublicKey> list = publicKeysToAdd;
        List<IdentityPublicKey> list2 = publicKeysToDisable;
        if (list2 != null) {
            Collection<Integer> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            List<IdentityPublicKey> list3 = list;
            int n2 = n;
            Identifier identifier2 = identifier;
            NetworkParameters networkParameters2 = networkParameters;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pk;
                IdentityPublicKey identityPublicKey = (IdentityPublicKey)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(pk.getId());
            }
            collection2 = (List)destination$iv$iv;
            networkParameters = networkParameters2;
            identifier = identifier2;
            n = n2;
            list = list3;
            collection = collection2;
        } else {
            collection = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 64;
        int n4 = 0;
        Long l = publicKeysToDisable != null ? Long.valueOf(new Date().getTime()) : null;
        Collection<Integer> collection3 = collection;
        List<IdentityPublicKey> list4 = list;
        int n5 = n;
        Identifier identifier3 = identifier;
        NetworkParameters networkParameters3 = networkParameters;
        return new IdentityUpdateTransition(networkParameters3, identifier3, n5, list4, (List)collection3, l, n4, n3, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Identity applyIdentityCreateStateTransition(@NotNull IdentityStateTransition stateTransition) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)stateTransition, (String)"stateTransition");
        IdentityCreateTransition identityCreateTransition = (IdentityCreateTransition)stateTransition;
        TransactionOutput output = new AssetLockProofFactory(this.getStateRepository()).fetchAssetLockTransactionOutput(identityCreateTransition.getAssetLockProof());
        byte[] outpoint = identityCreateTransition.getAssetLockProof().getOutPoint();
        Coin coin = output.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)coin, (String)"output.value");
        long creditsAmount = CreditsConverter.INSTANCE.convertSatoshiToCredits(coin);
        Iterable iterable = identityCreateTransition.getPublicKeys();
        Identifier identifier = identityCreateTransition.getIdentityId();
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IdentityPublicKey identityPublicKey = (IdentityPublicKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.copy(true));
        }
        int n = 1;
        int n2 = 0;
        long l = 0L;
        List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Identifier identifier2 = identifier;
        Identity newIdentity = new Identity(identifier2, list, l, n2, n);
        Iterable $this$map$iv2 = newIdentity.getPublicKeys();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdentityPublicKey bl = (IdentityPublicKey)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(ECKey.fromPublicOnly((byte[])it.getData()).getPubKeyHash());
        }
        List publicKeyHashes = (List)destination$iv$iv2;
        this.getStateRepository().storeIdentity(newIdentity);
        this.getStateRepository().storeIdentityPublicKeyHashes(newIdentity.getId(), publicKeyHashes);
        this.getStateRepository().markAssetLockTransactionOutPointAsUsed(outpoint);
        return newIdentity;
    }

    public final void applyIdentityTopUpTransition(@NotNull IdentityTopUpTransition stateTransition) {
        Identity identity;
        Intrinsics.checkNotNullParameter((Object)stateTransition, (String)"stateTransition");
        TransactionOutput output = new AssetLockProofFactory(this.getStateRepository()).fetchAssetLockTransactionOutput(stateTransition.getAssetLock());
        byte[] outPoint = stateTransition.getAssetLock().getOutPoint();
        Coin coin = output.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)coin, (String)"output.value");
        long creditsAmount = CreditsConverter.INSTANCE.convertSatoshiToCredits(coin);
        Identifier identityId = stateTransition.getIdentityId();
        Identity identity2 = identity = this.getStateRepository().fetchIdentity(identityId);
        Intrinsics.checkNotNull((Object)identity2);
        identity2.increaseBalance(creditsAmount);
        this.getStateRepository().storeIdentity(identity);
        this.getStateRepository().markAssetLockTransactionOutPointAsUsed(outPoint);
    }

    @NotNull
    public final ValidationResult validate(@NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return this.validate(identity.toObject());
    }

    @NotNull
    public final ValidationResult validate(@NotNull Map<String, ? extends Object> rawIdentity) {
        Intrinsics.checkNotNullParameter(rawIdentity, (String)"rawIdentity");
        return new ValidationResult(CollectionsKt.emptyList());
    }
}

