/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.identity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.dashj.platform.dpp.BaseObject;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.errors.concensus.signature.InvalidIdentityPublicKeyTypeException;
import org.dashj.platform.dpp.identity.errors.EmptyPublicKeyDataException;
import org.dashj.platform.dpp.util.Converters;
import org.dashj.platform.sdk.BinaryData;
import org.dashj.platform.sdk.ContractBounds;
import org.dashj.platform.sdk.IdentityPublicKey;
import org.dashj.platform.sdk.IdentityPublicKeyV0;
import org.dashj.platform.sdk.KeyID;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.TimestampMillis;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0001=B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B\u001d\b\u0016\u0012\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013\u00a2\u0006\u0002\u0010\u0015BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\rJ\u0013\u00100\u001a\u00020\r2\b\u00101\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020\u0010H\u0016J\b\u00105\u001a\u00020\u0003H\u0016J\u0006\u00106\u001a\u00020\rJ\u0014\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\n\u00108\u001a\u000609j\u0002`:J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010/\u001a\u00020\rJ\b\u0010<\u001a\u00020\u000bH\u0016R\u0011\u0010\n\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006>"}, d2={"Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "Lorg/dashj/platform/dpp/BaseObject;", "id", "", "type", "Lorg/dashj/platform/sdk/KeyType;", "purpose", "Lorg/dashj/platform/sdk/Purpose;", "securityLevel", "Lorg/dashj/platform/sdk/SecurityLevel;", "data", "", "readOnly", "", "(ILorg/dashj/platform/sdk/KeyType;Lorg/dashj/platform/sdk/Purpose;Lorg/dashj/platform/sdk/SecurityLevel;Ljava/lang/String;Z)V", "(ILorg/dashj/platform/sdk/KeyType;Ljava/lang/String;)V", "", "(ILorg/dashj/platform/sdk/KeyType;[B)V", "rawIdentityPublicKey", "", "", "(Ljava/util/Map;)V", "disabledAt", "", "signature", "(ILorg/dashj/platform/sdk/KeyType;Lorg/dashj/platform/sdk/Purpose;Lorg/dashj/platform/sdk/SecurityLevel;[BZLjava/lang/Long;[B)V", "getData", "()[B", "getDisabledAt", "()Ljava/lang/Long;", "setDisabledAt", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getId", "()I", "getPurpose", "()Lorg/dashj/platform/sdk/Purpose;", "getReadOnly", "()Z", "getSecurityLevel", "()Lorg/dashj/platform/sdk/SecurityLevel;", "getSignature", "setSignature", "([B)V", "getType", "()Lorg/dashj/platform/sdk/KeyType;", "copy", "skipSignature", "equals", "other", "getKey", "Lorg/bitcoinj/core/ECKey;", "hash", "hashCode", "isMaster", "toJSON", "toNative", "Lorg/dashj/platform/sdk/IdentityPublicKey;", "Lorg/dashj/platform/dpp/identity/RustIdentityPublicKey;", "toObject", "toString", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nIdentityPublicKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityPublicKey.kt\norg/dashj/platform/dpp/identity/IdentityPublicKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class IdentityPublicKey
extends BaseObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final KeyType type;
    @NotNull
    private final Purpose purpose;
    @NotNull
    private final SecurityLevel securityLevel;
    @NotNull
    private final byte[] data;
    private final boolean readOnly;
    @Nullable
    private Long disabledAt;
    @Nullable
    private byte[] signature;
    @NotNull
    private static final Map<Purpose, List<SecurityLevel>> allowedSecurityLevels;

    public IdentityPublicKey(int id, @NotNull KeyType type, @NotNull Purpose purpose, @NotNull SecurityLevel securityLevel, @NotNull byte[] data, boolean readOnly, @Nullable Long disabledAt, @Nullable byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)securityLevel, (String)"securityLevel");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(0, 1, null);
        this.id = id;
        this.type = type;
        this.purpose = purpose;
        this.securityLevel = securityLevel;
        this.data = data;
        this.readOnly = readOnly;
        this.disabledAt = disabledAt;
        this.signature = signature;
    }

    public /* synthetic */ IdentityPublicKey(int n, KeyType keyType, Purpose purpose, SecurityLevel securityLevel, byte[] byArray, boolean bl, Long l, byte[] byArray2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            l = null;
        }
        if ((n2 & 0x80) != 0) {
            byArray2 = null;
        }
        this(n, keyType, purpose, securityLevel, byArray, bl, l, byArray2);
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final KeyType getType() {
        return this.type;
    }

    @NotNull
    public final Purpose getPurpose() {
        return this.purpose;
    }

    @NotNull
    public final SecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    @Nullable
    public final Long getDisabledAt() {
        return this.disabledAt;
    }

    public final void setDisabledAt(@Nullable Long l) {
        this.disabledAt = l;
    }

    @Nullable
    public final byte[] getSignature() {
        return this.signature;
    }

    public final void setSignature(@Nullable byte[] byArray) {
        this.signature = byArray;
    }

    public IdentityPublicKey(int id, @NotNull KeyType type, @NotNull Purpose purpose, @NotNull SecurityLevel securityLevel, @NotNull String data, boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)securityLevel, (String)"securityLevel");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(id, type, purpose, securityLevel, Converters.fromBase64(data), readOnly, null, null, 192, null);
    }

    public IdentityPublicKey(int id, @NotNull KeyType type, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(id, type, Purpose.AUTHENTICATION, SecurityLevel.MASTER, Converters.fromBase64(data), true, null, null, 192, null);
    }

    public IdentityPublicKey(int id, @NotNull KeyType type, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(id, type, Purpose.AUTHENTICATION, SecurityLevel.MASTER, data, true, null, null, 192, null);
    }

    public IdentityPublicKey(@NotNull Map<String, ? extends Object> rawIdentityPublicKey) {
        boolean bl;
        byte[] byArray;
        SecurityLevel securityLevel;
        Purpose purpose;
        KeyType keyType;
        Intrinsics.checkNotNullParameter(rawIdentityPublicKey, (String)"rawIdentityPublicKey");
        Object object = rawIdentityPublicKey.get("id");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int n = (Integer)object;
        Object object2 = rawIdentityPublicKey.get("type");
        if (object2 instanceof KeyType) {
            Object object3 = rawIdentityPublicKey.get("type");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.dashj.platform.sdk.KeyType");
            keyType = (KeyType)object3;
        } else if (object2 instanceof Integer) {
            Object object4 = rawIdentityPublicKey.get("type");
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
            keyType = KeyType.swigToEnum((int)((Integer)object4));
        } else {
            throw new IllegalStateException("invalid type".toString());
        }
        Object object5 = keyType;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"when (rawIdentityPublicK\u2026alid type\")\n            }");
        KeyType keyType2 = object5;
        object2 = rawIdentityPublicKey.get("purpose");
        if (object2 instanceof Purpose) {
            Object object6 = rawIdentityPublicKey.get("purpose");
            Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type org.dashj.platform.sdk.Purpose");
            purpose = (Purpose)object6;
        } else if (object2 instanceof Integer) {
            Object object7 = rawIdentityPublicKey.get("purpose");
            Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Int");
            purpose = Purpose.swigToEnum((int)((Integer)object7));
        } else {
            purpose = Purpose.AUTHENTICATION;
        }
        object5 = purpose;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"when (rawIdentityPublicK\u2026HENTICATION\n            }");
        KeyType keyType3 = object5;
        object2 = rawIdentityPublicKey.get("securityLevel");
        if (object2 instanceof SecurityLevel) {
            Object object8 = rawIdentityPublicKey.get("securityLevel");
            Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type org.dashj.platform.sdk.SecurityLevel");
            securityLevel = (SecurityLevel)object8;
        } else if (object2 instanceof Integer) {
            Object object9 = rawIdentityPublicKey.get("securityLevel");
            Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.Int");
            securityLevel = SecurityLevel.swigToEnum((int)((Integer)object9));
        } else {
            securityLevel = SecurityLevel.CRITICAL;
        }
        object5 = securityLevel;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"when (rawIdentityPublicK\u2026el.CRITICAL\n            }");
        KeyType keyType4 = object5;
        object5 = rawIdentityPublicKey.get("data");
        if (object5 instanceof String) {
            Object object10 = rawIdentityPublicKey.get("data");
            Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type kotlin.String");
            byArray = Converters.fromBase64((String)object10);
        } else if (object5 instanceof byte[]) {
            Object object11 = rawIdentityPublicKey.get("data");
            Intrinsics.checkNotNull((Object)object11, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            byArray = (byte[])object11;
        } else {
            byArray = new byte[]{};
        }
        if (rawIdentityPublicKey.get("readOnly") instanceof Boolean) {
            Object object12 = rawIdentityPublicKey.get("readOnly");
            Intrinsics.checkNotNull((Object)object12, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object12;
        } else {
            bl = false;
        }
        this(n, keyType2, (Purpose)keyType3, (SecurityLevel)keyType4, byArray, bl, null, null, 192, null);
        object5 = rawIdentityPublicKey.get("signature");
        if (object5 instanceof String) {
            Object object13 = rawIdentityPublicKey.get("signature");
            Intrinsics.checkNotNull((Object)object13, (String)"null cannot be cast to non-null type kotlin.String");
            this.signature = Converters.fromBase64((String)object13);
        } else if (object5 instanceof byte[]) {
            Object object14 = rawIdentityPublicKey.get("signature");
            Intrinsics.checkNotNull((Object)object14, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            this.signature = (byte[])object14;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> toObject() {
        return this.toObject(false);
    }

    @NotNull
    public final Map<String, Object> toObject(boolean skipSignature) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)this.id), TuplesKt.to((Object)"type", (Object)this.type.swigValue()), TuplesKt.to((Object)"purpose", (Object)this.purpose.swigValue()), TuplesKt.to((Object)"securityLevel", (Object)this.securityLevel.swigValue()), TuplesKt.to((Object)"data", (Object)this.data), TuplesKt.to((Object)"readOnly", (Object)this.readOnly)};
        HashMap objMap = MapsKt.hashMapOf((Pair[])pairArray);
        Long l = this.disabledAt;
        if (l != null) {
            long $this$toObject_u24lambda_u240 = ((Number)l).longValue();
            boolean bl = false;
            objMap.put("disabledAt", $this$toObject_u24lambda_u240);
        }
        if (this.signature != null && !skipSignature) {
            Map map = objMap;
            Intrinsics.checkNotNull((Object)this.signature);
            map.put("signature", this.signature);
        }
        return objMap;
    }

    @Override
    @NotNull
    public Map<String, Object> toJSON() {
        Map json;
        block0: {
            json = MapsKt.toMutableMap(this.toObject());
            json.put("data", ExtensionsKt.toBase64(this.data));
            if (this.signature == null) break block0;
            byte[] $this$toJSON_u24lambda_u241 = this.signature;
            boolean bl = false;
            json.put("signature", ExtensionsKt.toBase64($this$toJSON_u24lambda_u241));
        }
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.dashj.platform.sdk.IdentityPublicKey toNative() {
        TimestampMillis timestampMillis;
        KeyID keyID = new KeyID(this.id);
        Purpose purpose = this.purpose;
        SecurityLevel securityLevel = this.securityLevel;
        ContractBounds contractBounds = null;
        KeyType keyType = this.type;
        boolean bl = this.readOnly;
        BinaryData binaryData = new BinaryData(this.data);
        Long l = this.disabledAt;
        if (l != null) {
            void it;
            long l2 = ((Number)l).longValue();
            BinaryData binaryData2 = binaryData;
            boolean bl2 = bl;
            KeyType keyType2 = keyType;
            ContractBounds contractBounds2 = contractBounds;
            SecurityLevel securityLevel2 = securityLevel;
            Purpose purpose2 = purpose;
            KeyID keyID2 = keyID;
            boolean bl3 = false;
            TimestampMillis timestampMillis2 = new TimestampMillis((long)it);
            keyID = keyID2;
            purpose = purpose2;
            securityLevel = securityLevel2;
            contractBounds = contractBounds2;
            keyType = keyType2;
            bl = bl2;
            binaryData = binaryData2;
            timestampMillis = timestampMillis2;
        } else {
            timestampMillis = null;
        }
        TimestampMillis timestampMillis3 = timestampMillis;
        BinaryData binaryData3 = binaryData;
        boolean bl4 = bl;
        KeyType keyType3 = keyType;
        ContractBounds contractBounds3 = contractBounds;
        SecurityLevel securityLevel3 = securityLevel;
        Purpose purpose3 = purpose;
        KeyID keyID3 = keyID;
        IdentityPublicKeyV0 identityPublicKeyV0 = new IdentityPublicKeyV0(keyID3, purpose3, securityLevel3, contractBounds3, keyType3, bl4, binaryData3, timestampMillis3);
        return new org.dashj.platform.sdk.IdentityPublicKey(identityPublicKeyV0);
    }

    public final boolean isMaster() {
        return this.securityLevel == SecurityLevel.MASTER;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IdentityPublicKey)) {
            return false;
        }
        return ((IdentityPublicKey)other).id == this.id && ((IdentityPublicKey)other).type == this.type && ((IdentityPublicKey)other).purpose == this.purpose && ((IdentityPublicKey)other).securityLevel == this.securityLevel && Arrays.equals(((IdentityPublicKey)other).data, this.data);
    }

    @Override
    public int hashCode() {
        byte[] hash = this.hash();
        return (int)Utils.readUint32((byte[])hash, (int)0);
    }

    @NotNull
    public final ECKey getKey() {
        ECKey eCKey = ECKey.fromPublicOnly((byte[])this.data);
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"fromPublicOnly(data)");
        return eCKey;
    }

    @Override
    @NotNull
    public byte[] hash() {
        byte[] byArray;
        if (this.data.length == 0) {
            throw new EmptyPublicKeyDataException();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: {
                return this.data;
            }
            case 3: 
            case 4: {
                byArray = Utils.sha256hash160((byte[])this.data);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha256hash160(data)");
                break;
            }
            default: {
                throw new InvalidIdentityPublicKeyTypeException(this.type);
            }
        }
        return byArray;
    }

    @NotNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NotNull
    public final IdentityPublicKey copy(boolean skipSignature) {
        return new IdentityPublicKey(this.id, this.type, this.purpose, this.securityLevel, this.data, this.readOnly, this.disabledAt, skipSignature ? null : this.signature);
    }

    static {
        Pair[] pairArray = new Pair[4];
        Object[] objectArray = new SecurityLevel[]{SecurityLevel.MASTER, SecurityLevel.CRITICAL, SecurityLevel.HIGH, SecurityLevel.MEDIUM};
        pairArray[0] = TuplesKt.to((Object)Purpose.AUTHENTICATION, (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[1] = TuplesKt.to((Object)Purpose.DECRYPTION, (Object)CollectionsKt.listOf((Object)SecurityLevel.MEDIUM));
        pairArray[2] = TuplesKt.to((Object)Purpose.ENCRYPTION, (Object)CollectionsKt.listOf((Object)SecurityLevel.MEDIUM));
        pairArray[3] = TuplesKt.to((Object)Purpose.TRANSFER, (Object)CollectionsKt.listOf((Object)SecurityLevel.CRITICAL));
        allowedSecurityLevels = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eR#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/dashj/platform/dpp/identity/IdentityPublicKey$Companion;", "", "()V", "allowedSecurityLevels", "", "Lorg/dashj/platform/sdk/Purpose;", "", "Lorg/dashj/platform/sdk/SecurityLevel;", "getAllowedSecurityLevels", "()Ljava/util/Map;", "from", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "identityPublicKey", "Lorg/dashj/platform/sdk/IdentityPublicKey;", "Lorg/dashj/platform/dpp/identity/RustIdentityPublicKey;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Purpose, List<SecurityLevel>> getAllowedSecurityLevels() {
            return allowedSecurityLevels;
        }

        @NotNull
        public final IdentityPublicKey from(@NotNull org.dashj.platform.sdk.IdentityPublicKey identityPublicKey) {
            Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
            IdentityPublicKey.Tag tag = identityPublicKey.getTag();
            if ((tag == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) != 1) {
                throw new IllegalStateException("Identity ".toString());
            }
            IdentityPublicKeyV0 ipk = identityPublicKey.getV0().get_0();
            int n = ipk.getId().toInt();
            KeyType keyType = ipk.getKeyType();
            Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"ipk.keyType");
            Purpose purpose = ipk.getPurpose();
            Intrinsics.checkNotNullExpressionValue((Object)purpose, (String)"ipk.purpose");
            SecurityLevel securityLevel = ipk.getSecurityLevel();
            Intrinsics.checkNotNullExpressionValue((Object)securityLevel, (String)"ipk.securityLevel");
            byte[] byArray = ipk.getData().get_0();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ipk.data._0");
            TimestampMillis timestampMillis = ipk.getDisabled_at();
            return new IdentityPublicKey(n, keyType, purpose, securityLevel, byArray, ipk.getRead_only(), timestampMillis != null ? Long.valueOf(timestampMillis.toLong()) : null, null, 128, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IdentityPublicKey.Tag.values().length];
                try {
                    nArray[IdentityPublicKey.Tag.V0.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyType.values().length];
            try {
                nArray[KeyType.ECDSA_HASH160.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.BIP13_SCRIPT_HASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.BLS12_381.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.ECDSA_SECP256K1.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

