/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.identity;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.quorums.InstantSendLock;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.identity.AssetLockProof;
import org.dashj.platform.dpp.util.Converters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\n\u0010!\u001a\u00060\"j\u0002`#J\u0016\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lorg/dashj/platform/dpp/identity/InstantAssetLockProof;", "Lorg/dashj/platform/dpp/identity/AssetLockProof;", "params", "Lorg/bitcoinj/core/NetworkParameters;", "rawAssetLockProof", "", "", "", "(Lorg/bitcoinj/core/NetworkParameters;Ljava/util/Map;)V", "outputIndex", "", "transaction", "Lorg/bitcoinj/core/Transaction;", "instantLock", "Lorg/bitcoinj/quorums/InstantSendLock;", "(JLorg/bitcoinj/core/Transaction;Lorg/bitcoinj/quorums/InstantSendLock;)V", "getInstantLock", "()Lorg/bitcoinj/quorums/InstantSendLock;", "output", "Lorg/bitcoinj/core/TransactionOutput;", "getOutput", "()Lorg/bitcoinj/core/TransactionOutput;", "getOutputIndex", "()J", "getTransaction", "()Lorg/bitcoinj/core/Transaction;", "type", "", "getType", "()I", "getOutPoint", "", "toJSON", "toNative", "Lorg/dashj/platform/sdk/InstantAssetLockProof;", "Lorg/dashj/platform/dpp/identity/NativeInstantAssetLockProof;", "toObject", "Companion", "dpp"})
public final class InstantAssetLockProof
extends AssetLockProof {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long outputIndex;
    @NotNull
    private final Transaction transaction;
    @NotNull
    private final InstantSendLock instantLock;
    private final int type;
    public static final int TYPE = 0;

    public InstantAssetLockProof(long outputIndex, @NotNull Transaction transaction, @NotNull InstantSendLock instantLock) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)instantLock, (String)"instantLock");
        this.outputIndex = outputIndex;
        this.transaction = transaction;
        this.instantLock = instantLock;
    }

    public final long getOutputIndex() {
        return this.outputIndex;
    }

    @NotNull
    public final Transaction getTransaction() {
        return this.transaction;
    }

    @NotNull
    public final InstantSendLock getInstantLock() {
        return this.instantLock;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public InstantAssetLockProof(@NotNull NetworkParameters params, @NotNull Map<String, ? extends Object> rawAssetLockProof) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(rawAssetLockProof, (String)"rawAssetLockProof");
        Object object = rawAssetLockProof.get("transaction");
        if (object == null) {
            throw new IllegalStateException("missing transaction field".toString());
        }
        Object object2 = rawAssetLockProof.get("instantLock");
        if (object2 == null) {
            throw new IllegalStateException("missing instantLock field".toString());
        }
        this(Long.parseLong(String.valueOf(rawAssetLockProof.get("outputIndex"))), new Transaction(params, Converters.byteArrayFromBase64orByteArray(object)), new InstantSendLock(params, Converters.byteArrayFromBase64orByteArray(object2), 1));
    }

    @NotNull
    public final TransactionOutput getOutput() {
        TransactionOutput transactionOutput = this.transaction.getOutput(this.outputIndex);
        Intrinsics.checkNotNullExpressionValue((Object)transactionOutput, (String)"transaction.getOutput(outputIndex)");
        return transactionOutput;
    }

    @Override
    @NotNull
    public byte[] getOutPoint() {
        TransactionOutPoint outPoint = new TransactionOutPoint(this.getOutput().getParams(), this.getOutput().getOutPointFor().getIndex(), this.getOutput().getOutPointFor().getHash());
        byte[] byArray = outPoint.bitcoinSerialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outPoint.bitcoinSerialize()");
        return byArray;
    }

    @Override
    @NotNull
    public Map<String, Object> toObject() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)this.getType()), TuplesKt.to((Object)"instantLock", (Object)this.instantLock.bitcoinSerialize()), TuplesKt.to((Object)"transaction", (Object)this.transaction.bitcoinSerialize()), TuplesKt.to((Object)"outputIndex", (Object)this.outputIndex)};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Map<String, Object> toJSON() {
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)this.getType());
        byte[] byArray = this.instantLock.bitcoinSerialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"instantLock.bitcoinSerialize()");
        pairArray[1] = TuplesKt.to((Object)"instantLock", (Object)ExtensionsKt.toBase64(byArray));
        pairArray[2] = TuplesKt.to((Object)"transaction", (Object)this.transaction.toStringBase64());
        pairArray[3] = TuplesKt.to((Object)"outputIndex", (Object)this.outputIndex);
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    @NotNull
    public final org.dashj.platform.sdk.InstantAssetLockProof toNative() {
        return new org.dashj.platform.sdk.InstantAssetLockProof(this.instantLock.bitcoinSerialize(), this.transaction.bitcoinSerialize(), this.outputIndex);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dashj/platform/dpp/identity/InstantAssetLockProof$Companion;", "", "()V", "TYPE", "", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

