/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.statetransition;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.identity.AssetLockProof;
import org.dashj.platform.dpp.identity.ChainAssetLockProof;
import org.dashj.platform.dpp.identity.InstantAssetLockProof;
import org.dashj.platform.dpp.statetransition.errors.IdentityAssetLockTransactionIsNotFoundException;
import org.dashj.platform.dpp.statetransition.errors.UnknownAssetLockProofException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/dashj/platform/dpp/statetransition/AssetLockProofFactory;", "", "stateRepository", "Lorg/dashj/platform/dpp/StateRepository;", "(Lorg/dashj/platform/dpp/StateRepository;)V", "getStateRepository", "()Lorg/dashj/platform/dpp/StateRepository;", "fetchAssetLockTransactionOutput", "Lorg/bitcoinj/core/TransactionOutput;", "assetLockProof", "Lorg/dashj/platform/dpp/identity/AssetLockProof;", "Companion", "dpp"})
public final class AssetLockProofFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StateRepository stateRepository;

    public AssetLockProofFactory(@NotNull StateRepository stateRepository) {
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        this.stateRepository = stateRepository;
    }

    @NotNull
    public final StateRepository getStateRepository() {
        return this.stateRepository;
    }

    @NotNull
    public final TransactionOutput fetchAssetLockTransactionOutput(@NotNull AssetLockProof assetLockProof) {
        TransactionOutput transactionOutput;
        Intrinsics.checkNotNullParameter((Object)assetLockProof, (String)"assetLockProof");
        AssetLockProof assetLockProof2 = assetLockProof;
        if (assetLockProof2 instanceof InstantAssetLockProof) {
            transactionOutput = ((InstantAssetLockProof)assetLockProof).getOutput();
        } else if (assetLockProof2 instanceof ChainAssetLockProof) {
            TransactionOutPoint outPoint = ((ChainAssetLockProof)assetLockProof).getOutPoint();
            String string = outPoint.getHash().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outPoint.hash.toString()");
            Transaction transaction = this.stateRepository.fetchTransaction(string);
            if (transaction == null) {
                throw new IdentityAssetLockTransactionIsNotFoundException(((ChainAssetLockProof)assetLockProof).getOutPoint());
            }
            Transaction transaction2 = transaction;
            Object e = transaction2.getOutputs().get((int)outPoint.getIndex());
            Intrinsics.checkNotNullExpressionValue(e, (String)"{\n                val ou\u2026ex.toInt()]\n            }");
            transactionOutput = (TransactionOutput)e;
        } else {
            throw new UnknownAssetLockProofException(assetLockProof.getType());
        }
        return transactionOutput;
    }

    @JvmStatic
    @NotNull
    public static final AssetLockProof createAssetLockProofInstance(@NotNull NetworkParameters params, @NotNull Map<String, ? extends Object> rawAssetLockProof) {
        return Companion.createAssetLockProofInstance(params, rawAssetLockProof);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/dashj/platform/dpp/statetransition/AssetLockProofFactory$Companion;", "", "()V", "createAssetLockProofInstance", "Lorg/dashj/platform/dpp/identity/AssetLockProof;", "params", "Lorg/bitcoinj/core/NetworkParameters;", "rawAssetLockProof", "", "", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AssetLockProof createAssetLockProofInstance(@NotNull NetworkParameters params, @NotNull Map<String, ? extends Object> rawAssetLockProof) {
            AssetLockProof assetLockProof;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter(rawAssetLockProof, (String)"rawAssetLockProof");
            Object object = rawAssetLockProof.get("type");
            if (Intrinsics.areEqual((Object)object, (Object)1)) {
                assetLockProof = new ChainAssetLockProof(params, rawAssetLockProof);
            } else if (Intrinsics.areEqual((Object)object, (Object)0)) {
                assetLockProof = new InstantAssetLockProof(params, rawAssetLockProof);
            } else {
                throw new IllegalStateException("Invalid type " + rawAssetLockProof.get("type"));
            }
            return assetLockProof;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

