/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.statetransition;

import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.HashSigner;
import org.bitcoinj.core.MasternodeSignature;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.SignatureDecodeException;
import org.bitcoinj.crypto.BLSPublicKey;
import org.bitcoinj.crypto.BLSSecretKey;
import org.bitcoinj.crypto.BLSSignature;
import org.dashj.platform.dpp.BaseObject;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.errors.concensus.signature.InvalidIdentityPublicKeyTypeException;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.statetransition.errors.StateTransitionIsNotSignedException;
import org.dashj.platform.dpp.util.Converters;
import org.dashj.platform.sdk.KeyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u001d\b\u0016\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB!\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0010J\b\u0010%\u001a\u00020\u0010H&J\b\u0010&\u001a\u00020\u0010H&J\b\u0010'\u001a\u00020\u0010H&J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020-J\u000e\u0010.\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0010J\u0016\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0016J\u001e\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0006\u0010$\u001a\u00020\u0010H\u0016J\u0016\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0016J&\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0006\u0010$\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0010H\u0016J\u000e\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\rJ\u0016\u00104\u001a\u00020\u00102\u0006\u00103\u001a\u00020\r2\u0006\u00105\u001a\u00020,J\u000e\u00106\u001a\u00020\u00102\u0006\u00103\u001a\u00020\rJ\u000e\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\rJ\u000e\u00109\u001a\u00020\u00102\u0006\u00103\u001a\u00020-J\u000e\u0010:\u001a\u00020\u00102\u0006\u00108\u001a\u00020\rR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006="}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransition;", "Lorg/dashj/platform/dpp/BaseObject;", "rawStateTransition", "", "", "", "(Ljava/util/Map;)V", "type", "Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;", "protocolVersion", "", "(Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;I)V", "signature", "", "([BLorg/dashj/platform/dpp/statetransition/StateTransition$Types;I)V", "isSignatureVerified", "", "()Z", "setSignatureVerified", "(Z)V", "modifiedDataIds", "", "Lorg/dashj/platform/dpp/identifier/Identifier;", "getModifiedDataIds", "()Ljava/util/List;", "getSignature", "()[B", "setSignature", "([B)V", "getType", "()Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;", "setType", "(Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;)V", "calculateFee", "", "hash", "skipSignature", "isDataContractStateTransition", "isDocumentStateTransition", "isIdentityStateTransition", "signByPrivateKey", "", "privateKey", "keyType", "Lorg/dashj/platform/sdk/KeyType;", "Lorg/bitcoinj/core/ECKey;", "toBuffer", "toJSON", "toObject", "skipIdentifiersConversion", "verifyBLSSignatureByPublicKey", "publicKey", "verifyByPublicKey", "publicKeyType", "verifyECDSASignatureByPublicKey", "verifyESDSAHash160SignatureByPublicKeyHash", "publicKeyHash", "verifySignatureByPublicKey", "verifySignatureByPublicKeyHash", "Companion", "Types", "dpp"})
@SourceDebugExtension(value={"SMAP\nStateTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateTransition.kt\norg/dashj/platform/dpp/statetransition/StateTransition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public abstract class StateTransition
extends BaseObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private byte[] signature;
    @NotNull
    private Types type;
    private boolean isSignatureVerified;
    public static final long PRICE_PER_BYTE = 1L;

    public StateTransition(@Nullable byte[] signature, @NotNull Types type, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(protocolVersion);
        this.signature = signature;
        this.type = type;
    }

    public /* synthetic */ StateTransition(byte[] byArray, Types types, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(byArray, types, n);
    }

    @Nullable
    public final byte[] getSignature() {
        return this.signature;
    }

    public final void setSignature(@Nullable byte[] byArray) {
        this.signature = byArray;
    }

    @NotNull
    public final Types getType() {
        return this.type;
    }

    public final void setType(@NotNull Types types) {
        Intrinsics.checkNotNullParameter((Object)((Object)types), (String)"<set-?>");
        this.type = types;
    }

    @NotNull
    public abstract List<Identifier> getModifiedDataIds();

    public final boolean isSignatureVerified() {
        return this.isSignatureVerified;
    }

    public final void setSignatureVerified(boolean bl) {
        this.isSignatureVerified = bl;
    }

    /*
     * WARNING - void declaration
     */
    public StateTransition(@NotNull Map<String, Object> rawStateTransition) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(rawStateTransition, (String)"rawStateTransition");
        StateTransition stateTransition = this;
        Object object = rawStateTransition.get("signature");
        if (object != null) {
            void it;
            Object object2 = object;
            StateTransition stateTransition2 = stateTransition;
            boolean bl = false;
            byArray = Converters.byteArrayFromBase64orByteArray(it);
            stateTransition = stateTransition2;
        } else {
            byArray = null;
        }
        Object object3 = rawStateTransition.get("type");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
        Types types = Types.Companion.getByCode((Integer)object3);
        Object object4 = rawStateTransition.get("protocolVersion");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
        stateTransition(byArray, types, (Integer)object4);
    }

    public StateTransition(@NotNull Types type, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(null, type, protocolVersion);
    }

    public /* synthetic */ StateTransition(Types types, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(types, n);
    }

    @NotNull
    public final StateTransition setSignature(@NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return this.setSignature(Converters.fromBase64(signature));
    }

    @NotNull
    public final StateTransition setSignature(@NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.signature = signature;
        return this;
    }

    @Override
    @NotNull
    public Map<String, Object> toObject() {
        return this.toObject(false, false);
    }

    @NotNull
    public Map<String, Object> toObject(boolean skipSignature, boolean skipIdentifiersConversion) {
        HashMap json = new HashMap();
        ((Map)json).put("protocolVersion", this.getProtocolVersion());
        ((Map)json).put("type", this.type.getValue());
        if (!skipSignature) {
            ((Map)json).put("signature", this.signature);
        }
        return json;
    }

    @Override
    @NotNull
    public Map<String, Object> toJSON() {
        return this.toJSON(false);
    }

    @NotNull
    public Map<String, Object> toJSON(boolean skipSignature) {
        Map<String, Object> json;
        block1: {
            json = this.toObject(skipSignature, true);
            if (skipSignature) break block1;
            if (this.signature != null) {
                byte[] it = this.signature;
                boolean bl = false;
                json.put("signature", ExtensionsKt.toBase64Padded(it));
            }
        }
        return json;
    }

    @NotNull
    public final byte[] hash(boolean skipSignature) {
        return ExtensionsKt.hashTwice(this.toBuffer(skipSignature));
    }

    @NotNull
    public final byte[] toBuffer(boolean skipSignature) {
        Map<String, Object> serializedData = this.toObject(skipSignature, false);
        serializedData.remove("protocolVersion");
        return this.encodeProtocolEntity(serializedData);
    }

    public final void signByPrivateKey(@NotNull String privateKey, @NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        this.signByPrivateKey(Converters.byteArrayFromString(privateKey), keyType);
    }

    public final void signByPrivateKey(@NotNull byte[] privateKey, @NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        byte[] data = this.hash(true);
        switch (WhenMappings.$EnumSwitchMapping$0[keyType.ordinal()]) {
            case 1: 
            case 2: {
                ECKey privateKeyModel = ECKey.fromPrivate((byte[])privateKey);
                this.signature = privateKeyModel.signHash(Sha256Hash.wrap((byte[])data));
                break;
            }
            case 3: {
                BLSSecretKey privateKeyModel = new BLSSecretKey(privateKey);
                BLSSignature blsSignature = privateKeyModel.Sign(Sha256Hash.wrap((byte[])data));
                this.signature = blsSignature.bitcoinSerialize();
                break;
            }
            default: {
                throw new InvalidIdentityPublicKeyTypeException(keyType);
            }
        }
    }

    public final void signByPrivateKey(@NotNull ECKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        byte[] data = this.toBuffer(true);
        Sha256Hash hash = ExtensionsKt.toSha256Hash(data);
        this.signature = privateKey.signHash(hash);
    }

    public final boolean verifyByPublicKey(@NotNull byte[] publicKey, @NotNull KeyType publicKeyType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)publicKeyType, (String)"publicKeyType");
        switch (WhenMappings.$EnumSwitchMapping$0[publicKeyType.ordinal()]) {
            case 1: {
                bl = this.verifyECDSASignatureByPublicKey(publicKey);
                break;
            }
            case 2: {
                bl = this.verifyESDSAHash160SignatureByPublicKeyHash(publicKey);
                break;
            }
            case 3: {
                bl = this.verifyBLSSignatureByPublicKey(publicKey);
                break;
            }
            default: {
                throw new InvalidIdentityPublicKeyTypeException(publicKeyType);
            }
        }
        return bl;
    }

    public final boolean verifyESDSAHash160SignatureByPublicKeyHash(@NotNull byte[] publicKeyHash) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKeyHash, (String)"publicKeyHash");
        if (this.signature == null) {
            throw new StateTransitionIsNotSignedException(this);
        }
        byte[] hash = this.hash(true);
        try {
            StringBuilder errorMessage = new StringBuilder();
            bl = HashSigner.verifyHash((Sha256Hash)Sha256Hash.wrap((byte[])hash), (byte[])publicKeyHash, (MasternodeSignature)new MasternodeSignature(this.signature), (StringBuilder)errorMessage);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean verifyECDSASignatureByPublicKey(@NotNull byte[] publicKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (this.signature == null) {
            throw new StateTransitionIsNotSignedException(this);
        }
        byte[] hash = this.hash(true);
        ECKey publicKeyModel = ECKey.fromPublicOnly((byte[])publicKey);
        try {
            bl = publicKeyModel.verify(hash, this.signature);
        }
        catch (SignatureDecodeException e) {
            bl = false;
        }
        return bl;
    }

    public final boolean verifyBLSSignatureByPublicKey(@NotNull byte[] publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (this.signature == null) {
            throw new StateTransitionIsNotSignedException(this);
        }
        byte[] hash = this.hash(true);
        BLSPublicKey publicKeyModel = new BLSPublicKey(publicKey);
        BLSSignature blsSignature = new BLSSignature(this.signature);
        return blsSignature.verifyInsecure(publicKeyModel, Sha256Hash.wrap((byte[])hash));
    }

    public final boolean verifySignatureByPublicKey(@NotNull ECKey publicKey) {
        boolean bl;
        StateTransition stateTransition;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (this.signature == null) {
            throw new StateTransitionIsNotSignedException(this);
        }
        byte[] data = this.toBuffer(true);
        Sha256Hash hash = ExtensionsKt.toSha256Hash(data);
        StateTransition stateTransition2 = this;
        try {
            stateTransition = stateTransition2;
            ECKey pubkeyFromSig = ECKey.signedMessageToKey((Sha256Hash)hash, (byte[])this.signature);
            byte[] byArray = pubkeyFromSig.getPubKey();
            Intrinsics.checkNotNull((Object)byArray);
            bl = Arrays.equals(byArray, publicKey.getPubKey());
        }
        catch (SignatureException signatureException) {
            stateTransition = stateTransition2;
            bl = false;
        }
        stateTransition.isSignatureVerified = bl;
        return this.isSignatureVerified;
    }

    public final boolean verifySignatureByPublicKeyHash(@NotNull byte[] publicKeyHash) {
        boolean bl;
        StateTransition stateTransition;
        Intrinsics.checkNotNullParameter((Object)publicKeyHash, (String)"publicKeyHash");
        if (this.signature == null) {
            throw new StateTransitionIsNotSignedException(this);
        }
        Sha256Hash hash = ExtensionsKt.toSha256Hash(this.toBuffer(true));
        StateTransition stateTransition2 = this;
        try {
            stateTransition = stateTransition2;
            ECKey pubkeyFromSig = ECKey.signedMessageToKey((Sha256Hash)hash, (byte[])this.signature);
            byte[] byArray = pubkeyFromSig.getPubKeyHash();
            Intrinsics.checkNotNull((Object)byArray);
            bl = Arrays.equals(byArray, publicKeyHash);
        }
        catch (SignatureException signatureException) {
            stateTransition = stateTransition2;
            bl = false;
        }
        stateTransition.isSignatureVerified = bl;
        return this.isSignatureVerified;
    }

    public final long calculateFee() {
        byte[] serializedStateTransition = this.toBuffer(true);
        return (long)serializedStateTransition.length * 1L;
    }

    public abstract boolean isDocumentStateTransition();

    public abstract boolean isDataContractStateTransition();

    public abstract boolean isIdentityStateTransition();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransition$Companion;", "", "()V", "PRICE_PER_BYTE", "", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "DATA_CONTRACT_CREATE", "DOCUMENTS_BATCH", "IDENTITY_CREATE", "IDENTITY_TOP_UP", "DATA_CONTRACT_UPDATE", "IDENTITY_UPDATE", "Companion", "dpp"})
    public static final class Types
    extends Enum<Types> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        @NotNull
        private static final Types[] values;
        public static final /* enum */ Types DATA_CONTRACT_CREATE;
        public static final /* enum */ Types DOCUMENTS_BATCH;
        public static final /* enum */ Types IDENTITY_CREATE;
        public static final /* enum */ Types IDENTITY_TOP_UP;
        public static final /* enum */ Types DATA_CONTRACT_UPDATE;
        public static final /* enum */ Types IDENTITY_UPDATE;
        private static final /* synthetic */ Types[] $VALUES;

        private Types(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static Types[] values() {
            return (Types[])$VALUES.clone();
        }

        public static Types valueOf(String value) {
            return Enum.valueOf(Types.class, value);
        }

        static {
            DATA_CONTRACT_CREATE = new Types(0);
            DOCUMENTS_BATCH = new Types(1);
            IDENTITY_CREATE = new Types(2);
            IDENTITY_TOP_UP = new Types(3);
            DATA_CONTRACT_UPDATE = new Types(4);
            IDENTITY_UPDATE = new Types(5);
            $VALUES = typesArray = new Types[]{Types.DATA_CONTRACT_CREATE, Types.DOCUMENTS_BATCH, Types.IDENTITY_CREATE, Types.IDENTITY_TOP_UP, Types.DATA_CONTRACT_UPDATE, Types.IDENTITY_UPDATE};
            Companion = new Companion(null);
            values = Types.values();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransition$Types$Companion;", "", "()V", "values", "", "Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;", "[Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;", "getByCode", "code", "", "dpp"})
        @SourceDebugExtension(value={"SMAP\nStateTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateTransition.kt\norg/dashj/platform/dpp/statetransition/StateTransition$Types$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,237:1\n3792#2:238\n4307#2,2:239\n*S KotlinDebug\n*F\n+ 1 StateTransition.kt\norg/dashj/platform/dpp/statetransition/StateTransition$Types$Companion\n*L\n49#1:238\n49#1:239,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Types getByCode(int code) {
                void $this$filterTo$iv$iv;
                Types[] $this$filter$iv = values;
                boolean $i$f$filter = false;
                Types[] typesArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!(it.getValue() == code)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (Types)((Object)((List)destination$iv$iv).get(0));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyType.values().length];
            try {
                nArray[KeyType.ECDSA_SECP256K1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.ECDSA_HASH160.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.BLS12_381.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

