/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.statetransition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.Factory;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.contract.ContractFactory;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.contract.DataContractCreateTransition;
import org.dashj.platform.dpp.document.DocumentsBatchTransition;
import org.dashj.platform.dpp.errors.DataContractNotPresentException;
import org.dashj.platform.dpp.errors.InvalidStateTransitionTypeError;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.IdentityCreateTransition;
import org.dashj.platform.dpp.identity.IdentityTopUpTransition;
import org.dashj.platform.dpp.statetransition.StateTransition;
import org.dashj.platform.dpp.statetransition.StateTransitionIdentitySigned;
import org.dashj.platform.dpp.statetransition.errors.MissingDataContractIdException;
import org.dashj.platform.dpp.util.Converters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\b2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\b\b\u0002\u0010\u000b\u001a\u00020\fJ&\u0010\u0012\u001a\u00020\b2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0002"}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransitionFactory;", "Lorg/dashj/platform/dpp/Factory;", "dpp", "Lorg/dashj/platform/dpp/DashPlatformProtocol;", "stateRepository", "Lorg/dashj/platform/dpp/StateRepository;", "(Lorg/dashj/platform/dpp/DashPlatformProtocol;Lorg/dashj/platform/dpp/StateRepository;)V", "createFromBuffer", "Lorg/dashj/platform/dpp/statetransition/StateTransition;", "payload", "", "options", "Lorg/dashj/platform/dpp/statetransition/StateTransitionFactory$Options;", "createFromObject", "rawStateTransition", "", "", "", "createStateTransition", "Options"})
@SourceDebugExtension(value={"SMAP\nStateTransitionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateTransitionFactory.kt\norg/dashj/platform/dpp/statetransition/StateTransitionFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1549#2:100\n1620#2,3:101\n*S KotlinDebug\n*F\n+ 1 StateTransitionFactory.kt\norg/dashj/platform/dpp/statetransition/StateTransitionFactory\n*L\n43#1:100\n43#1:101,3\n*E\n"})
public final class StateTransitionFactory
extends Factory {
    public StateTransitionFactory(@NotNull DashPlatformProtocol dpp, @NotNull StateRepository stateRepository) {
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        super(dpp, stateRepository);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StateTransition createStateTransition(@NotNull Map<String, Object> rawStateTransition, @NotNull Options options) {
        byte[] byArray;
        Object dataContracts;
        Object object;
        Intrinsics.checkNotNullParameter(rawStateTransition, (String)"rawStateTransition");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        StateTransitionIdentitySigned stateTransition = null;
        Object object2 = rawStateTransition.get("type");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
        switch (WhenMappings.$EnumSwitchMapping$0[StateTransition.Types.Companion.getByCode((Integer)object2).ordinal()]) {
            case 1: {
                Object object3 = rawStateTransition.get("dataContract");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
                Map rawDataContract = TypeIntrinsics.asMutableMap((Object)object3);
                DataContract dataContract = new ContractFactory(this.getDpp(), this.getStateRepository()).create(Identifier.Companion.from$default(Identifier.Companion, rawDataContract.get("ownerId"), null, 2, null), (Map<String, ? extends Object>)rawDataContract);
                stateTransition = new DataContractCreateTransition(this.getDpp().getNetworkParameters(), dataContract);
                break;
            }
            case 2: {
                void $this$mapTo$iv$iv;
                Object object4 = rawStateTransition.get("transitions");
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any?>>");
                Iterable $this$map$iv = (List)object4;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    DataContract dataContract;
                    void transition;
                    Map map = (Map)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    if (!transition.containsKey("$dataContractId")) {
                        throw new MissingDataContractIdException((Map<String, ? extends Object>)transition);
                    }
                    Identifier dataContractId = Identifier.Companion.from$default(Identifier.Companion, transition.get("$dataContractId"), null, 2, null);
                    if (this.getStateRepository().fetchDataContract(dataContractId) == null) {
                        throw new DataContractNotPresentException(dataContractId);
                    }
                    object.add(dataContract);
                }
                dataContracts = (List)destination$iv$iv;
                stateTransition = new DocumentsBatchTransition(this.getDpp().getNetworkParameters(), rawStateTransition, (List<DataContract>)dataContracts);
                break;
            }
            case 3: {
                stateTransition = new IdentityCreateTransition(this.getDpp().getNetworkParameters(), rawStateTransition);
                break;
            }
            case 4: {
                stateTransition = new IdentityTopUpTransition(this.getDpp().getNetworkParameters(), rawStateTransition);
                break;
            }
            default: {
                Object object5 = rawStateTransition.get("type");
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Int");
                throw new InvalidStateTransitionTypeError((Integer)object5, rawStateTransition);
            }
        }
        StateTransitionIdentitySigned stateTransitionIdentitySigned = stateTransition;
        Object object6 = rawStateTransition.get("signature");
        if (object6 != null) {
            void it;
            dataContracts = object6;
            object = stateTransitionIdentitySigned;
            boolean bl = false;
            byArray = Converters.byteArrayFromBase64orByteArray(it);
            stateTransitionIdentitySigned = object;
        } else {
            byArray = null;
        }
        stateTransitionIdentitySigned.setSignature(byArray);
        if (rawStateTransition.containsKey("signaturePublicKeyId")) {
            Object object7 = rawStateTransition.get("signaturePublicKeyId");
            Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Int");
            stateTransition.setSignaturePublicKeyId((Integer)object7);
        } else if (stateTransition.getType() != StateTransition.Types.IDENTITY_CREATE) {
            throw new IllegalArgumentException("signaturePublicKeyId is missing from transition");
        }
        return stateTransition;
    }

    public static /* synthetic */ StateTransition createStateTransition$default(StateTransitionFactory stateTransitionFactory, Map map, Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Options(false, 1, null);
        }
        return stateTransitionFactory.createStateTransition(map, options);
    }

    @NotNull
    public final StateTransition createFromObject(@NotNull Map<String, Object> rawStateTransition, @NotNull Options options) {
        Intrinsics.checkNotNullParameter(rawStateTransition, (String)"rawStateTransition");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return StateTransitionFactory.createStateTransition$default(this, rawStateTransition, null, 2, null);
    }

    public static /* synthetic */ StateTransition createFromObject$default(StateTransitionFactory stateTransitionFactory, Map map, Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Options(false, 1, null);
        }
        return stateTransitionFactory.createFromObject(map, options);
    }

    @NotNull
    public final StateTransition createFromBuffer(@NotNull byte[] payload, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(payload);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawStateTransition = (Map)pair.component2();
        Integer n = protocolVersion;
        rawStateTransition.put("protocolVersion", n);
        return this.createFromObject(rawStateTransition, options);
    }

    public static /* synthetic */ StateTransition createFromBuffer$default(StateTransitionFactory stateTransitionFactory, byte[] byArray, Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Options(false, 1, null);
        }
        return stateTransitionFactory.createFromBuffer(byArray, options);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransitionFactory$Options;", "", "skipValidation", "", "(Z)V", "getSkipValidation", "()Z", "dpp"})
    public static final class Options {
        private final boolean skipValidation;

        public Options(boolean skipValidation) {
            this.skipValidation = skipValidation;
        }

        public /* synthetic */ Options(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getSkipValidation() {
            return this.skipValidation;
        }

        public Options() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StateTransition.Types.values().length];
            try {
                nArray[StateTransition.Types.DATA_CONTRACT_CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StateTransition.Types.DOCUMENTS_BATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StateTransition.Types.IDENTITY_CREATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StateTransition.Types.IDENTITY_TOP_UP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

