/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.statetransition;

import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.BLSSecretKey;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.errors.concensus.signature.InvalidIdentityPublicKeyTypeException;
import org.dashj.platform.dpp.errors.concensus.signature.InvalidSignaturePublicKeySecurityLevelException;
import org.dashj.platform.dpp.errors.concensus.signature.PublicKeyIsDisabledException;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.statetransition.StateTransition;
import org.dashj.platform.dpp.statetransition.errors.InvalidSignaturePublicKeyException;
import org.dashj.platform.dpp.statetransition.errors.InvalidSignatureTypeException;
import org.dashj.platform.dpp.statetransition.errors.PublicKeyMismatchError;
import org.dashj.platform.dpp.statetransition.errors.PublicKeySecurityLevelNotMetException;
import org.dashj.platform.dpp.statetransition.errors.StateTransitionIsNotSignedException;
import org.dashj.platform.dpp.statetransition.errors.WrongPublicKeyPurposeException;
import org.dashj.platform.dpp.util.Converters;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SecurityLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0010J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0006J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u001cJ&\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010)\u001a\u00020 H\u0002J\u000e\u0010+\u001a\u00020&2\u0006\u0010)\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lorg/dashj/platform/dpp/statetransition/StateTransitionIdentitySigned;", "Lorg/dashj/platform/dpp/statetransition/StateTransition;", "params", "Lorg/bitcoinj/core/NetworkParameters;", "rawStateTransition", "", "", "", "(Lorg/bitcoinj/core/NetworkParameters;Ljava/util/Map;)V", "type", "Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;", "protocolVersion", "", "(Lorg/bitcoinj/core/NetworkParameters;Lorg/dashj/platform/dpp/statetransition/StateTransition$Types;I)V", "signaturePublicKeyId", "signature", "", "(Lorg/bitcoinj/core/NetworkParameters;Ljava/lang/Integer;[BLorg/dashj/platform/dpp/statetransition/StateTransition$Types;I)V", "getParams", "()Lorg/bitcoinj/core/NetworkParameters;", "getSignaturePublicKeyId", "()Ljava/lang/Integer;", "setSignaturePublicKeyId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getKeySecurityLevelRequirement", "Lorg/dashj/platform/sdk/SecurityLevel;", "getPrivateECKey", "Lorg/bitcoinj/core/ECKey;", "kotlin.jvm.PlatformType", "privateKey", "identityPublicKey", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "sign", "", "toObject", "", "skipSignature", "", "skipIdentifiersConversion", "verifyPublicKeyIsEnabled", "publicKey", "verifyPublicKeyLevelAndPurpose", "verifySignature", "dpp"})
@SourceDebugExtension(value={"SMAP\nStateTransitionIdentitySigned.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateTransitionIdentitySigned.kt\norg/dashj/platform/dpp/statetransition/StateTransitionIdentitySigned\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public abstract class StateTransitionIdentitySigned
extends StateTransition {
    @NotNull
    private final NetworkParameters params;
    @Nullable
    private Integer signaturePublicKeyId;

    public StateTransitionIdentitySigned(@NotNull NetworkParameters params, @Nullable Integer signaturePublicKeyId, @Nullable byte[] signature, @NotNull StateTransition.Types type, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(signature, type, protocolVersion);
        this.params = params;
        this.signaturePublicKeyId = signaturePublicKeyId;
    }

    public /* synthetic */ StateTransitionIdentitySigned(NetworkParameters networkParameters, Integer n, byte[] byArray, StateTransition.Types types, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n2 = 1;
        }
        this(networkParameters, n, byArray, types, n2);
    }

    @NotNull
    public final NetworkParameters getParams() {
        return this.params;
    }

    @Nullable
    public final Integer getSignaturePublicKeyId() {
        return this.signaturePublicKeyId;
    }

    public final void setSignaturePublicKeyId(@Nullable Integer n) {
        this.signaturePublicKeyId = n;
    }

    /*
     * WARNING - void declaration
     */
    public StateTransitionIdentitySigned(@NotNull NetworkParameters params, @NotNull Map<String, ? extends Object> rawStateTransition) {
        int n;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(rawStateTransition, (String)"rawStateTransition");
        StateTransitionIdentitySigned stateTransitionIdentitySigned = this;
        NetworkParameters networkParameters = params;
        Object object = rawStateTransition.get("signaturePublicKeyId");
        Integer n2 = object instanceof Integer ? (Integer)object : null;
        Object object2 = rawStateTransition.get("signature");
        if (object2 != null) {
            void it;
            Object object3 = object2;
            Integer n3 = n2;
            NetworkParameters networkParameters2 = networkParameters;
            StateTransitionIdentitySigned stateTransitionIdentitySigned2 = stateTransitionIdentitySigned;
            boolean bl = false;
            byte[] byArray2 = Converters.byteArrayFromBase64orByteArray(it);
            stateTransitionIdentitySigned = stateTransitionIdentitySigned2;
            networkParameters = networkParameters2;
            n2 = n3;
            byArray = byArray2;
        } else {
            byArray = null;
        }
        Object object4 = rawStateTransition.get("type");
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
        StateTransition.Types types = StateTransition.Types.Companion.getByCode((Integer)object4);
        if (rawStateTransition.containsKey("protocolVersion")) {
            Object object5 = rawStateTransition.get("protocolVersion");
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Int");
            n = (Integer)object5;
        } else {
            n = 1;
        }
        stateTransitionIdentitySigned(networkParameters, n2, byArray, types, n);
    }

    public StateTransitionIdentitySigned(@NotNull NetworkParameters params, @NotNull StateTransition.Types type, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(params, null, null, type, protocolVersion);
    }

    public /* synthetic */ StateTransitionIdentitySigned(NetworkParameters networkParameters, StateTransition.Types types, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(networkParameters, types, n);
    }

    @Override
    @NotNull
    public Map<String, Object> toObject(boolean skipSignature, boolean skipIdentifiersConversion) {
        Map<String, Object> rawStateTransition = super.toObject(skipSignature, skipIdentifiersConversion);
        if (!skipSignature) {
            rawStateTransition.put("signaturePublicKeyId", this.signaturePublicKeyId);
        }
        return rawStateTransition;
    }

    public final void sign(@NotNull IdentityPublicKey identityPublicKey, @NotNull String privateKey) {
        Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        ECKey eCKey = this.getPrivateECKey(privateKey, identityPublicKey);
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"getPrivateECKey(privateKey, identityPublicKey)");
        this.sign(identityPublicKey, eCKey);
    }

    public final void sign(@NotNull IdentityPublicKey identityPublicKey, @NotNull ECKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        byte[] byArray = privateKey.getPrivKeyBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKey.privKeyBytes");
        this.sign(identityPublicKey, byArray);
    }

    public final void sign(@NotNull IdentityPublicKey identityPublicKey, @NotNull byte[] privateKey) {
        Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        byte[] pubKeyBase = null;
        this.verifyPublicKeyLevelAndPurpose(identityPublicKey);
        this.verifyPublicKeyIsEnabled(identityPublicKey);
        switch (WhenMappings.$EnumSwitchMapping$0[identityPublicKey.getType().ordinal()]) {
            case 1: {
                ECKey privateKeyModel = ECKey.fromPrivate((byte[])privateKey);
                byte[] byArray = privateKeyModel.getPubKey();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKeyModel.pubKey");
                pubKeyBase = byArray;
                if (!Arrays.equals(pubKeyBase, identityPublicKey.getData())) {
                    throw new InvalidSignaturePublicKeyException(ExtensionsKt.toBase64(identityPublicKey.getData()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)privateKeyModel, (String)"privateKeyModel");
                this.signByPrivateKey(privateKeyModel);
                break;
            }
            case 2: {
                ECKey privateKeyModel = ECKey.fromPrivate((byte[])privateKey);
                byte[] byArray = privateKeyModel.getPubKeyHash();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKeyModel.pubKeyHash");
                pubKeyBase = byArray;
                if (!Arrays.equals(pubKeyBase, identityPublicKey.getData())) {
                    throw new InvalidSignaturePublicKeyException(ExtensionsKt.toBase64(identityPublicKey.getData()));
                }
                Intrinsics.checkNotNullExpressionValue((Object)privateKeyModel, (String)"privateKeyModel");
                this.signByPrivateKey(privateKeyModel);
                break;
            }
            case 3: {
                BLSSecretKey privateKeyModel = new BLSSecretKey(privateKey);
                byte[] byArray = privateKeyModel.GetPublicKey().bitcoinSerialize();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKeyModel.GetPublicKey().bitcoinSerialize()");
                pubKeyBase = byArray;
                if (!Arrays.equals(pubKeyBase, identityPublicKey.getData())) {
                    throw new InvalidSignaturePublicKeyException(ExtensionsKt.toBase64(identityPublicKey.getData()));
                }
                String string = privateKeyModel.toStringHex();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"privateKeyModel.toStringHex()");
                this.signByPrivateKey(string, identityPublicKey.getType());
                break;
            }
            default: {
                throw new InvalidSignatureTypeException(identityPublicKey.getType());
            }
        }
        this.signaturePublicKeyId = identityPublicKey.getId();
    }

    private final ECKey getPrivateECKey(String privateKey, IdentityPublicKey identityPublicKey) {
        ECKey eCKey;
        try {
            eCKey = DumpedPrivateKey.fromBase58((NetworkParameters)this.params, (String)privateKey).getKey();
        }
        catch (AddressFormatException.WrongNetwork _) {
            throw new InvalidSignaturePublicKeyException(ExtensionsKt.toBase64(identityPublicKey.getData()));
        }
        catch (AddressFormatException _) {
            eCKey = ECKey.fromPrivate((byte[])Converters.fromHex(privateKey));
        }
        return eCKey;
    }

    public final boolean verifySignature(@NotNull IdentityPublicKey publicKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.verifyPublicKeyLevelAndPurpose(publicKey);
        this.verifyPublicKeyIsEnabled(publicKey);
        if (this.getSignature() == null) {
            throw new StateTransitionIsNotSignedException(this);
        }
        Integer n = this.signaturePublicKeyId;
        int n2 = publicKey.getId();
        if (n == null || n != n2) {
            throw new PublicKeyMismatchError(publicKey);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[publicKey.getType().ordinal()]) {
            case 2: {
                bl = this.verifySignatureByPublicKeyHash(publicKey.getData());
                break;
            }
            case 1: {
                ECKey publicKeyModel = ECKey.fromPublicOnly((byte[])publicKey.getData());
                Intrinsics.checkNotNullExpressionValue((Object)publicKeyModel, (String)"publicKeyModel");
                bl = this.verifySignatureByPublicKey(publicKeyModel);
                break;
            }
            case 3: {
                bl = this.verifyBLSSignatureByPublicKey(publicKey.getData());
                break;
            }
            default: {
                throw new InvalidIdentityPublicKeyTypeException(publicKey.getType());
            }
        }
        return bl;
    }

    private final void verifyPublicKeyLevelAndPurpose(IdentityPublicKey publicKey) {
        if (publicKey.isMaster() && this.getKeySecurityLevelRequirement() != SecurityLevel.MASTER) {
            throw new InvalidSignaturePublicKeySecurityLevelException(SecurityLevel.MASTER, this.getKeySecurityLevelRequirement());
        }
        if (this.getKeySecurityLevelRequirement().compareTo((Enum)publicKey.getSecurityLevel()) < 0) {
            throw new PublicKeySecurityLevelNotMetException(publicKey.getSecurityLevel(), this.getKeySecurityLevelRequirement());
        }
        if (publicKey.getPurpose() != Purpose.AUTHENTICATION) {
            throw new WrongPublicKeyPurposeException(publicKey.getPurpose(), Purpose.AUTHENTICATION);
        }
    }

    private final void verifyPublicKeyIsEnabled(IdentityPublicKey publicKey) {
        if (publicKey.getDisabledAt() != null) {
            throw new PublicKeyIsDisabledException(publicKey);
        }
    }

    @NotNull
    public SecurityLevel getKeySecurityLevelRequirement() {
        return SecurityLevel.HIGH;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyType.values().length];
            try {
                nArray[KeyType.ECDSA_SECP256K1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.ECDSA_HASH160.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.BLS12_381.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

