/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dashj.platform.dpp.ExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/dashj/platform/dpp/util/ByteArrayFixedLength;", "", "bytes", "", "maxLength", "", "([BI)V", "getBytes", "()[B", "size", "getSize", "()I", "ToBase58", "", "toBase64", "toBase64Padded", "toHex", "dpp"})
public class ByteArrayFixedLength {
    @NotNull
    private final byte[] bytes;
    private final int size;

    public ByteArrayFixedLength(@NotNull byte[] bytes, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        if (!(this.bytes.length == maxLength)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.size = maxLength;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final String toBase64() {
        return ExtensionsKt.toBase64(this.bytes);
    }

    @NotNull
    public final String toBase64Padded() {
        return ExtensionsKt.toBase64Padded(this.bytes);
    }

    @NotNull
    public final String ToBase58() {
        return ExtensionsKt.toBase58(this.bytes);
    }

    @NotNull
    public final String toHex() {
        return ExtensionsKt.toHex(this.bytes);
    }
}

