/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.util;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.builder.AbstractBuilder;
import co.nstant.in.cbor.builder.ArrayBuilder;
import co.nstant.in.cbor.builder.MapBuilder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.DoublePrecisionFloat;
import co.nstant.in.cbor.model.HalfPrecisionFloat;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.SimpleValueType;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.util.Cbor;
import org.dashj.platform.dpp.util.CborDecodeException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\tH\u0002J.\u0010\n\u001a\u00020\u00042\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J&\u0010\u0012\u001a\u00020\u00042\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0002J\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\rJ\u0014\u0010\u001d\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bJ\u001c\u0010\u001d\u001a\u00020\u00182\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010 J\u0018\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\"H\u0002J\u001e\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010\u001f\u001a\u00020$H\u0002J$\u0010%\u001a\u00020\u00042\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J*\u0010'\u001a\u00020\u00042\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J&\u0010(\u001a\u00020)2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020)0\u0011H\u0002J,\u0010*\u001a\u00020)2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020)0\u0014H\u0002\u00a8\u0006+"}, d2={"Lorg/dashj/platform/dpp/util/Cbor;", "", "()V", "addValueFromCborArray", "", "value", "Lco/nstant/in/cbor/model/DataItem;", "array", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addValueFromCborMap", "map", "Ljava/util/HashMap;", "", "key", "addValueToArrayBuilder", "arrayBuilder", "Lco/nstant/in/cbor/builder/ArrayBuilder;", "addValueToMapBuilder", "mapBuilder", "Lco/nstant/in/cbor/builder/MapBuilder;", "decode", "", "payload", "", "decodeByteArray", "decodeList", "", "decodeString", "encode", "s", "obj", "", "readJSONArray", "Lco/nstant/in/cbor/model/Array;", "readJSONObject", "Lco/nstant/in/cbor/model/Map;", "writeJSONArray", "builder", "writeJSONObject", "writeRootJSONArray", "Lco/nstant/in/cbor/CborBuilder;", "writeRootJSONObject", "dpp"})
@SourceDebugExtension(value={"SMAP\nCbor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cbor.kt\norg/dashj/platform/dpp/util/Cbor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1855#2,2:309\n1855#2,2:311\n1855#2,2:313\n*S KotlinDebug\n*F\n+ 1 Cbor.kt\norg/dashj/platform/dpp/util/Cbor\n*L\n140#1:309,2\n163#1:311,2\n212#1:313,2\n*E\n"})
public final class Cbor {
    @NotNull
    public static final Cbor INSTANCE = new Cbor();

    private Cbor() {
    }

    @NotNull
    public final byte[] encode(@NotNull java.util.Map<String, ? extends Object> obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CborBuilder cborBuilder = new CborBuilder();
        MapBuilder mapBuilder = cborBuilder.addMap();
        Intrinsics.checkNotNullExpressionValue((Object)mapBuilder, (String)"cborBuilder.addMap()");
        CborBuilder mapBuilder2 = this.writeRootJSONObject(obj, (MapBuilder<CborBuilder>)mapBuilder);
        mapBuilder2.build();
        new CborEncoder((OutputStream)baos).encode(cborBuilder.build());
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    @NotNull
    public final byte[] encode(@NotNull List<? extends Object> obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CborBuilder cborBuilder = new CborBuilder();
        ArrayBuilder arrayBuilder = cborBuilder.addArray();
        Intrinsics.checkNotNullExpressionValue((Object)arrayBuilder, (String)"cborBuilder.addArray()");
        CborBuilder arrayBuilder2 = this.writeRootJSONArray(obj, (ArrayBuilder<CborBuilder>)arrayBuilder);
        arrayBuilder2.build();
        new CborEncoder((OutputStream)baos).encode(cborBuilder.build());
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    @NotNull
    public final java.util.Map<String, Object> decode(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            List dataItems = CborDecoder.decode((byte[])payload);
            Object e = dataItems.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            return this.readJSONObject((Map)e);
        }
        catch (ClassCastException e) {
            throw new CborDecodeException("payload is not a map", e);
        }
    }

    @NotNull
    public final byte[] encode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length());
        new CborEncoder((OutputStream)baos).encode((DataItem)new UnicodeString(s));
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    @NotNull
    public final byte[] encode(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(payload.length);
        new CborEncoder((OutputStream)baos).encode((DataItem)new ByteString(payload));
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    @NotNull
    public final String decodeString(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            List decoded = CborDecoder.decode((byte[])payload);
            Object e = decoded.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.UnicodeString");
            String string = ((UnicodeString)e).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decoded[0] as UnicodeString).toString()");
            return string;
        }
        catch (ClassCastException e) {
            throw new CborDecodeException("payload is not a String", e);
        }
    }

    @NotNull
    public final byte[] decodeByteArray(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            List decoded = CborDecoder.decode((byte[])payload);
            Object e = decoded.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
            byte[] byArray = ((ByteString)e).getBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decoded[0] as ByteString).bytes");
            return byArray;
        }
        catch (ClassCastException e) {
            throw new CborDecodeException("payload is not a ByteArray", e);
        }
    }

    @NotNull
    public final List<Object> decodeList(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            List dataItems = CborDecoder.decode((byte[])payload);
            Object e = dataItems.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Array");
            return CollectionsKt.filterNotNull((Iterable)this.readJSONArray((Array)e));
        }
        catch (ClassCastException e) {
            throw new CborDecodeException("payload is not a List<Any>", e);
        }
    }

    private final CborBuilder writeRootJSONObject(java.util.Map<String, ? extends Object> obj, MapBuilder<CborBuilder> mapBuilder) {
        this.writeJSONObject(obj, mapBuilder);
        AbstractBuilder abstractBuilder = mapBuilder.end();
        Intrinsics.checkNotNullExpressionValue((Object)abstractBuilder, (String)"mapBuilder.end()");
        return (CborBuilder)abstractBuilder;
    }

    private final void writeJSONObject(java.util.Map<String, ? extends Object> obj, MapBuilder<?> builder) {
        ArrayList sortedKeys = new ArrayList();
        sortedKeys.addAll(obj.keySet());
        CollectionsKt.sortWith((List)sortedKeys, (arg_0, arg_1) -> Cbor.writeJSONObject$lambda$0(writeJSONObject.1.INSTANCE, arg_0, arg_1));
        Iterable $this$forEach$iv = sortedKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Object value = obj.get(key);
            Object object = value;
            if (object instanceof java.util.Map) {
                Object object2 = obj.get(key);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                java.util.Map map = (java.util.Map)object2;
                MapBuilder mapBuilder = builder.putMap(key);
                Intrinsics.checkNotNullExpressionValue((Object)mapBuilder, (String)"builder.putMap(key)");
                INSTANCE.writeJSONObject(map, mapBuilder);
                continue;
            }
            if (object instanceof List) {
                List list = (List)value;
                ArrayBuilder arrayBuilder = builder.putArray(key);
                Intrinsics.checkNotNullExpressionValue((Object)arrayBuilder, (String)"builder.putArray(key)");
                INSTANCE.writeJSONArray(list, arrayBuilder);
                continue;
            }
            INSTANCE.addValueToMapBuilder(builder, key, value);
        }
        builder.end();
    }

    private final CborBuilder writeRootJSONArray(List<? extends Object> obj, ArrayBuilder<CborBuilder> arrayBuilder) {
        this.writeJSONArray(obj, arrayBuilder);
        AbstractBuilder abstractBuilder = arrayBuilder.end();
        Intrinsics.checkNotNullExpressionValue((Object)abstractBuilder, (String)"arrayBuilder.end()");
        return (CborBuilder)abstractBuilder;
    }

    private final void writeJSONArray(List<? extends Object> obj, ArrayBuilder<?> builder) {
        Iterable $this$forEach$iv = obj;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object value = element$iv = iterator.next();
            boolean bl = false;
            Object t = value;
            if (t instanceof java.util.Map) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                java.util.Map map = (java.util.Map)value;
                MapBuilder mapBuilder = builder.addMap();
                Intrinsics.checkNotNullExpressionValue((Object)mapBuilder, (String)"builder.addMap()");
                INSTANCE.writeJSONObject(map, mapBuilder);
                continue;
            }
            if (t instanceof List) {
                List list = (List)value;
                ArrayBuilder arrayBuilder = builder.addArray();
                Intrinsics.checkNotNullExpressionValue((Object)arrayBuilder, (String)"builder.addArray()");
                INSTANCE.writeJSONArray(list, arrayBuilder);
                continue;
            }
            INSTANCE.addValueToArrayBuilder(value, builder);
        }
        builder.end();
    }

    private final void addValueToMapBuilder(MapBuilder<?> mapBuilder, String key, Object value) {
        Object object = value;
        if (object instanceof String) {
            mapBuilder.put(key, (String)value);
        } else if (object instanceof Boolean) {
            mapBuilder.put(key, ((Boolean)value).booleanValue());
        } else if (object instanceof Integer) {
            mapBuilder.put(key, (long)((Number)value).intValue());
        } else if (object instanceof BigInteger) {
            mapBuilder.put(key, ((BigInteger)value).longValue());
        } else if (object instanceof Float) {
            mapBuilder.put(key, ((Number)value).floatValue());
        } else if (object instanceof Long) {
            mapBuilder.put(key, ((Number)value).longValue());
        } else if (object instanceof Double) {
            mapBuilder.put(key, ((Number)value).doubleValue());
        } else if (object instanceof byte[]) {
            mapBuilder.put(key, (byte[])value);
        } else if (object instanceof Identifier) {
            mapBuilder.put(key, ((Identifier)value).toBuffer());
        } else if (object instanceof Number) {
            mapBuilder.put(key, ((Number)value).longValue());
        } else if (object == null) {
            mapBuilder.put((DataItem)new UnicodeString(key), (DataItem)new SimpleValue(SimpleValueType.NULL));
        } else {
            throw new IllegalArgumentException("No converter for " + value + ')');
        }
    }

    private final void addValueToArrayBuilder(Object value, ArrayBuilder<?> arrayBuilder) {
        Object object = value;
        if (object instanceof String) {
            arrayBuilder.add((String)value);
        } else if (object instanceof Boolean) {
            arrayBuilder.add(((Boolean)value).booleanValue());
        } else if (object instanceof Integer) {
            arrayBuilder.add((long)((Number)value).intValue());
        } else if (object instanceof BigInteger) {
            arrayBuilder.add(((BigInteger)value).longValue());
        } else if (object instanceof Float) {
            arrayBuilder.add(((Number)value).floatValue());
        } else if (object instanceof Long) {
            arrayBuilder.add(((Number)value).longValue());
        } else if (object instanceof Double) {
            arrayBuilder.add(((Number)value).doubleValue());
        } else if (object instanceof byte[]) {
            arrayBuilder.add((byte[])value);
        } else if (object instanceof Identifier) {
            arrayBuilder.add(((Identifier)value).toBuffer());
        } else if (object instanceof Number) {
            arrayBuilder.add(((Number)value).longValue());
        } else if (object == null) {
            arrayBuilder.add((DataItem)new SimpleValue(SimpleValueType.NULL));
        } else {
            throw new IllegalArgumentException("No converter for " + value);
        }
    }

    private final java.util.Map<String, Object> readJSONObject(Map obj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList keys = new ArrayList();
        keys.addAll(obj.getKeys());
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataItem value;
            DataItem key = (DataItem)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.UnicodeString");
            String keyString = ((UnicodeString)key).getString();
            DataItem dataItem = value = obj.get(key);
            if (dataItem instanceof Map) {
                java.util.Map map = resultMap;
                Intrinsics.checkNotNullExpressionValue((Object)keyString, (String)"keyString");
                String string = keyString;
                DataItem dataItem2 = obj.get(key);
                Intrinsics.checkNotNull((Object)dataItem2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                java.util.Map<String, Object> map2 = INSTANCE.readJSONObject((Map)dataItem2);
                map.put(string, map2);
                continue;
            }
            if (dataItem instanceof Array) {
                java.util.Map map = resultMap;
                Intrinsics.checkNotNullExpressionValue((Object)keyString, (String)"keyString");
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                map.put(keyString, INSTANCE.readJSONArray((Array)value));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)keyString, (String)"keyString");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            INSTANCE.addValueFromCborMap(resultMap, keyString, value);
        }
        return resultMap;
    }

    private final List<Object> readJSONArray(Array value) {
        int count = value.getDataItems().size();
        ArrayList<Object> resultList = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            DataItem item = (DataItem)value.getDataItems().get(i);
            if (item instanceof Map) {
                resultList.add(this.readJSONObject((Map)item));
                continue;
            }
            if (item instanceof Array) {
                resultList.add(this.readJSONArray((Array)item));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
            this.addValueFromCborArray(item, resultList);
        }
        return resultList;
    }

    private final void addValueFromCborMap(HashMap<String, Object> map, String key, DataItem value) {
        block11: {
            block17: {
                DataItem dataItem;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        dataItem = value;
                                        if (!(dataItem instanceof UnicodeString)) break block10;
                                        ((java.util.Map)map).put(key, ((UnicodeString)value).getString());
                                        break block11;
                                    }
                                    if (!(dataItem instanceof NegativeInteger)) break block12;
                                    if (((NegativeInteger)value).getValue().longValue() >= Integer.MIN_VALUE) {
                                        ((java.util.Map)map).put(key, ((NegativeInteger)value).getValue().intValue());
                                    } else {
                                        ((java.util.Map)map).put(key, ((NegativeInteger)value).getValue().longValue());
                                    }
                                    break block11;
                                }
                                if (!(dataItem instanceof UnsignedInteger)) break block13;
                                if (((UnsignedInteger)value).getValue().longValue() <= Integer.MAX_VALUE) {
                                    ((java.util.Map)map).put(key, ((UnsignedInteger)value).getValue().intValue());
                                } else {
                                    ((java.util.Map)map).put(key, ((UnsignedInteger)value).getValue().longValue());
                                }
                                break block11;
                            }
                            if (!(dataItem instanceof HalfPrecisionFloat)) break block14;
                            ((java.util.Map)map).put(key, Float.valueOf(((HalfPrecisionFloat)value).getValue()));
                            break block11;
                        }
                        if (!(dataItem instanceof DoublePrecisionFloat)) break block15;
                        ((java.util.Map)map).put(key, ((DoublePrecisionFloat)value).getValue());
                        break block11;
                    }
                    if (!(dataItem instanceof ByteString)) break block16;
                    ((java.util.Map)map).put(key, ((ByteString)value).getBytes());
                    break block11;
                }
                if (!(dataItem instanceof SimpleValue)) break block17;
                SimpleValueType simpleValueType = ((SimpleValue)value).getSimpleValueType();
                switch (simpleValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[simpleValueType.ordinal()]) {
                    case 1: {
                        ((java.util.Map)map).put(key, true);
                        break block11;
                    }
                    case 2: {
                        ((java.util.Map)map).put(key, false);
                        break block11;
                    }
                    case 3: {
                        ((java.util.Map)map).put(key, null);
                        break block11;
                    }
                    case 4: {
                        ((java.util.Map)map).put(key, "undefined");
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown simple datatype");
                    }
                }
            }
            throw new IllegalArgumentException(value.toString());
        }
    }

    private final void addValueFromCborArray(DataItem value, ArrayList<Object> array) {
        block11: {
            block17: {
                DataItem dataItem;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        dataItem = value;
                                        if (!(dataItem instanceof UnicodeString)) break block10;
                                        array.add(((UnicodeString)value).getString());
                                        break block11;
                                    }
                                    if (!(dataItem instanceof NegativeInteger)) break block12;
                                    if (((NegativeInteger)value).getValue().longValue() >= Integer.MIN_VALUE) {
                                        array.add((int)((NegativeInteger)value).getValue().longValue());
                                    } else {
                                        array.add(((NegativeInteger)value).getValue().longValue());
                                    }
                                    break block11;
                                }
                                if (!(dataItem instanceof UnsignedInteger)) break block13;
                                if (((UnsignedInteger)value).getValue().longValue() <= Integer.MAX_VALUE) {
                                    array.add((int)((UnsignedInteger)value).getValue().longValue());
                                } else {
                                    array.add(((UnsignedInteger)value).getValue().longValue());
                                }
                                break block11;
                            }
                            if (!(dataItem instanceof HalfPrecisionFloat)) break block14;
                            array.add(Float.valueOf(((HalfPrecisionFloat)value).getValue()));
                            break block11;
                        }
                        if (!(dataItem instanceof DoublePrecisionFloat)) break block15;
                        array.add(((DoublePrecisionFloat)value).getValue());
                        break block11;
                    }
                    if (!(dataItem instanceof ByteString)) break block16;
                    array.add(((ByteString)value).getBytes());
                    break block11;
                }
                if (!(dataItem instanceof SimpleValue)) break block17;
                SimpleValueType simpleValueType = ((SimpleValue)value).getSimpleValueType();
                switch (simpleValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[simpleValueType.ordinal()]) {
                    case 1: {
                        array.add(true);
                        break block11;
                    }
                    case 2: {
                        array.add(false);
                        break block11;
                    }
                    case 3: {
                        array.add(null);
                        break block11;
                    }
                    case 4: {
                        array.add("undefined");
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown simple datatype");
                    }
                }
            }
            throw new IllegalArgumentException(value.toString());
        }
    }

    private static final int writeJSONObject$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleValueType.values().length];
            try {
                nArray[SimpleValueType.TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleValueType.FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleValueType.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleValueType.UNDEFINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

