/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.util;

import com.google.common.io.BaseEncoding;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.util.ByteArray20;
import org.dashj.platform.dpp.util.ByteArray32;
import org.dashj.platform.dpp.util.ByteArray36;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0007J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0007J\u001e\u0010\u0013\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/dashj/platform/dpp/util/Converters;", "", "()V", "BASE64", "Lcom/google/common/io/BaseEncoding;", "HEX", "byteArrayFromBase58orByteArray", "", "any", "byteArrayFromBase64orByteArray", "byteArrayFromString", "string", "", "byteArrayfromBase58orByteArray", "byteArrayfromBase64orByteArray", "convertDataToString", "", "map", "", "convertIdentifierToByteArray", "fromBase64", "base64", "fromBase64Padded", "base64Padded", "fromHex", "base16", "dpp"})
public final class Converters {
    @NotNull
    public static final Converters INSTANCE = new Converters();
    @NotNull
    private static final BaseEncoding BASE64;
    @NotNull
    private static final BaseEncoding HEX;

    private Converters() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] fromBase64(@NotNull String base64) {
        Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
        byte[] byArray = BASE64.decode((CharSequence)base64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"BASE64.decode(base64)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] fromBase64Padded(@NotNull String base64Padded) {
        Intrinsics.checkNotNullParameter((Object)base64Padded, (String)"base64Padded");
        byte[] byArray = BaseEncoding.base64().decode((CharSequence)base64Padded);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"base64().decode(base64Padded)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] fromHex(@NotNull String base16) {
        Intrinsics.checkNotNullParameter((Object)base16, (String)"base16");
        byte[] byArray = HEX.decode((CharSequence)base16);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"HEX.decode(base16)");
        return byArray;
    }

    @Deprecated(message="from should be From")
    @NotNull
    public final byte[] byteArrayfromBase64orByteArray(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return Converters.byteArrayFromBase64orByteArray(any);
    }

    @JvmStatic
    @NotNull
    public static final byte[] byteArrayFromBase64orByteArray(@NotNull Object any) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        Object object = any;
        if (object instanceof String) {
            byArray = Converters.fromBase64((String)any);
        } else if (object instanceof ByteArray20) {
            byArray = ((ByteArray20)any).getBytes();
        } else if (object instanceof ByteArray32) {
            byArray = ((ByteArray32)any).getBytes();
        } else if (object instanceof ByteArray36) {
            byArray = ((ByteArray36)any).getBytes();
        } else if (object instanceof byte[]) {
            byArray = (byte[])any;
        } else {
            throw new IllegalStateException("any is not String or ByteArray");
        }
        return byArray;
    }

    @Deprecated(message="from should be From")
    @NotNull
    public final byte[] byteArrayfromBase58orByteArray(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return Converters.byteArrayFromBase58orByteArray(any);
    }

    @JvmStatic
    @NotNull
    public static final byte[] byteArrayFromBase58orByteArray(@NotNull Object any) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        Object object = any;
        if (object instanceof String) {
            byte[] byArray2 = Base58.decode((String)((String)any));
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n                Base58.decode(any)\n            }");
            byArray = byArray2;
        } else if (object instanceof byte[]) {
            byArray = (byte[])any;
        } else if (object instanceof ByteArray20) {
            byArray = ((ByteArray20)any).getBytes();
        } else if (object instanceof ByteArray32) {
            byArray = ((ByteArray32)any).getBytes();
        } else if (object instanceof ByteArray36) {
            byArray = ((ByteArray36)any).getBytes();
        } else {
            throw new IllegalStateException("any is not String or ByteArray".toString());
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] byteArrayFromString(@NotNull String string) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        try {
            byte[] byArray2 = Base58.decode((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            Base58.decode(string)\n        }");
            byArray = byArray2;
        }
        catch (AddressFormatException e) {
            byte[] byArray3;
            try {
                byArray3 = Converters.fromHex(string);
            }
            catch (IllegalArgumentException e2) {
                byte[] byArray4;
                try {
                    byArray4 = Converters.fromBase64(string);
                }
                catch (IllegalArgumentException e3) {
                    throw new IllegalStateException(("string is not base58, base64 or hex: " + string).toString());
                }
                byArray3 = byArray4;
            }
            byArray = byArray3;
        }
        return byArray;
    }

    @JvmStatic
    public static final void convertDataToString(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                Converters.convertDataToString(TypeIntrinsics.asMutableMap((Object)value));
                continue;
            }
            if (value instanceof byte[]) {
                map.put(key, ExtensionsKt.toBase64((byte[])value));
                continue;
            }
            if (!(value instanceof Identifier)) continue;
            map.put(key, ((Identifier)value).toString());
        }
    }

    @JvmStatic
    public static final void convertIdentifierToByteArray(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                Converters.convertIdentifierToByteArray(TypeIntrinsics.asMutableMap((Object)value));
                continue;
            }
            if (!(value instanceof Identifier)) continue;
            map.put(key, ((Identifier)value).toBuffer());
        }
    }

    static {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        Intrinsics.checkNotNullExpressionValue((Object)baseEncoding, (String)"base64()");
        BASE64 = baseEncoding;
        BaseEncoding baseEncoding2 = BaseEncoding.base16().lowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)baseEncoding2, (String)"base16().lowerCase()");
        HEX = baseEncoding2;
    }
}

