/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.util;

import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.LinuxSecureRandom;
import org.dashj.platform.dpp.identifier.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/dashj/platform/dpp/util/Entropy;", "", "()V", "SEED_SIZE", "", "mockEntropy", "", "mockRandomIdentifier", "Lorg/dashj/platform/dpp/identifier/Identifier;", "secureRandom", "Ljava/security/SecureRandom;", "clearMock", "", "generate", "generateRandomBytes", "size", "generateRandomIdentifier", "setMockGenerate", "mockEntroy", "setRandomIdentifier", "dpp"})
public final class Entropy {
    @NotNull
    public static final Entropy INSTANCE = new Entropy();
    private static final int SEED_SIZE = 32;
    @Nullable
    private static Identifier mockRandomIdentifier;
    @Nullable
    private static byte[] mockEntropy;
    @NotNull
    private static SecureRandom secureRandom;

    private Entropy() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] generate() {
        if (mockEntropy == null) {
            byte[] bytes32 = new byte[32];
            secureRandom.nextBytes(bytes32);
            return bytes32;
        }
        Intrinsics.checkNotNull((Object)mockEntropy);
        return mockEntropy;
    }

    @JvmStatic
    public static final void setMockGenerate(@Nullable byte[] mockEntroy) {
        mockEntropy = mockEntroy;
    }

    @JvmStatic
    @NotNull
    public static final Identifier generateRandomIdentifier() {
        Identifier identifier = mockRandomIdentifier;
        if (identifier == null) {
            identifier = Identifier.Companion.from(INSTANCE.generate());
        }
        return identifier;
    }

    public final void setRandomIdentifier(@Nullable Identifier mockRandomIdentifier) {
        Entropy.mockRandomIdentifier = mockRandomIdentifier;
    }

    @JvmStatic
    public static final void clearMock() {
        mockEntropy = null;
        mockRandomIdentifier = null;
    }

    @JvmStatic
    @NotNull
    public static final byte[] generateRandomBytes(int size) {
        byte[] result = new byte[size];
        secureRandom.nextBytes(result);
        return result;
    }

    static {
        if (Utils.isAndroidRuntime()) {
            new LinuxSecureRandom();
        }
        secureRandom = new SecureRandom();
    }
}

