/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bitcoinj.core.Sha256Hash;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.util.Cbor;
import org.dashj.platform.dpp.util.Converters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0007J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004J\u0014\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J \u0010\u001b\u001a\u00020\u00042\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u001e0\u0018J\u001c\u0010\u001b\u001a\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u001eH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0004\u00a8\u0006\""}, d2={"Lorg/dashj/platform/dpp/util/HashUtils;", "", "()V", "byteArrayFromBase58orByteArray", "", "any", "byteArrayFromBase64orByteArray", "byteArrayFromString", "string", "", "byteArrayfromBase58orByteArray", "byteArrayfromBase64orByteArray", "fromBase64", "base64", "fromHex", "base16", "generateDataContractId", "ownerId", "entropy", "generateDocumentId", "dataContractId", "type", "getMerkleRoot", "merkleTree", "", "getMerkleTree", "hashes", "toHash", "byteArray", "objList", "", "obj", "toSha256Hash", "Lorg/bitcoinj/core/Sha256Hash;", "dpp"})
@SourceDebugExtension(value={"SMAP\nHashUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashUtils.kt\norg/dashj/platform/dpp/util/HashUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1855#2,2:130\n1549#2:132\n1620#2,3:133\n*S KotlinDebug\n*F\n+ 1 HashUtils.kt\norg/dashj/platform/dpp/util/HashUtils\n*L\n77#1:130,2\n85#1:132\n85#1:133,3\n*E\n"})
public final class HashUtils {
    @NotNull
    public static final HashUtils INSTANCE = new HashUtils();

    private HashUtils() {
    }

    private final byte[] toHash(Map<String, ? extends Object> obj) {
        byte[] byteArray = Cbor.INSTANCE.encode(obj);
        return ExtensionsKt.hashTwice(byteArray);
    }

    @NotNull
    public final byte[] toHash(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        byte[] byArray = Sha256Hash.hashTwice((byte[])byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hashTwice(byteArray)");
        return byArray;
    }

    @NotNull
    public final Sha256Hash toSha256Hash(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Sha256Hash sha256Hash = Sha256Hash.twiceOf((byte[])byteArray);
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"twiceOf(byteArray)");
        return sha256Hash;
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] fromBase64(@NotNull String base64) {
        Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
        return Converters.fromBase64(base64);
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] fromHex(@NotNull String base16) {
        Intrinsics.checkNotNullParameter((Object)base16, (String)"base16");
        return Converters.fromHex(base16);
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] byteArrayfromBase64orByteArray(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return Converters.byteArrayFromBase64orByteArray(any);
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] byteArrayFromBase64orByteArray(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return Converters.byteArrayFromBase64orByteArray(any);
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] byteArrayfromBase58orByteArray(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return Converters.byteArrayFromBase58orByteArray(any);
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] byteArrayFromBase58orByteArray(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return Converters.byteArrayFromBase58orByteArray(any);
    }

    @Deprecated(message="use the same method from the Converters object")
    @NotNull
    public final byte[] byteArrayFromString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return Converters.byteArrayFromString(string);
    }

    @NotNull
    public final byte[] toHash(@NotNull List<? extends Map<String, ? extends Object>> objList) {
        Intrinsics.checkNotNullParameter(objList, (String)"objList");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Iterable $this$forEach$iv = objList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            bos.write(Sha256Hash.wrap((byte[])INSTANCE.toHash(it)).getBytes());
        }
        byte[] byArray = bos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bos.toByteArray()");
        return ExtensionsKt.hashTwice(byArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<byte[]> getMerkleTree(@NotNull List<byte[]> hashes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        ArrayList<byte[]> tree = new ArrayList<byte[]>();
        Iterable iterable = hashes;
        ArrayList<byte[]> arrayList = tree;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte[])it.clone());
        }
        arrayList.addAll((List)destination$iv$iv);
        int j = 0;
        int size = hashes.size();
        while (size > 1) {
            size = (int)Math.floor((double)(size + 1) / (double)2);
            int i = 0;
            while (i < size) {
                int i2 = RangesKt.coerceAtMost((int)((i += 2) + 1), (int)(size - 1));
                Object e = tree.get(j + i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"tree[j + i]");
                byte[] a = (byte[])e;
                Object e2 = tree.get(j + i2);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"tree[j + i2]");
                byte[] b = (byte[])e2;
                byte[] buf = ArraysKt.plus((byte[])a, (byte[])b);
                tree.add(ExtensionsKt.hashTwice(buf));
            }
            j += size;
        }
        return tree;
    }

    @NotNull
    public final byte[] getMerkleRoot(@NotNull List<byte[]> merkleTree) {
        Intrinsics.checkNotNullParameter(merkleTree, (String)"merkleTree");
        return (byte[])((byte[])CollectionsKt.last(merkleTree)).clone();
    }

    @NotNull
    public final byte[] generateDocumentId(@NotNull byte[] dataContractId, @NotNull byte[] ownerId, @NotNull String type, @NotNull byte[] entropy) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        Charset utf8charset = Charset.forName("UTF-8");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(dataContractId);
        stream.write(ownerId);
        Intrinsics.checkNotNullExpressionValue((Object)utf8charset, (String)"utf8charset");
        byte[] byArray = type.getBytes(utf8charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        stream.write(byArray);
        stream.write(entropy);
        byte[] byArray2 = stream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"stream.toByteArray()");
        return ExtensionsKt.hashTwice(byArray2);
    }

    @NotNull
    public final byte[] generateDataContractId(@NotNull byte[] ownerId, @NotNull byte[] entropy) {
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(ownerId);
        stream.write(entropy);
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
        return ExtensionsKt.hashTwice(byArray);
    }
}

