/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dashj.platform.dpp.util.ByteArray20;
import org.dashj.platform.dpp.util.ByteArray32;
import org.dashj.platform.dpp.util.ByteArray36;
import org.dashj.platform.dpp.util.EnumBytes;
import org.dashj.platform.dpp.util.EnumString;
import org.dashj.platform.sdk.Hash256;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.PlatformValue;
import org.dashj.platform.sdk.PlatformValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u001c\u0010\b\u001a\u00020\u00012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00070\n\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00070\n2\u0006\u0010\t\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00070\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n\u001a(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00070\n\u001a\u0010\u0010\u0013\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0014"}, d2={"convertEnumStringToPlatformValue", "Lorg/dashj/platform/sdk/PlatformValue;", "value", "Lorg/dashj/platform/dpp/util/EnumString;", "convertListToPlatformValue", "list", "", "", "convertMapToPlatformValue", "map", "", "", "convertPlatformValue", "convertPlatformValueArray", "array", "convertPlatformValueMap", "convertProperties", "properties", "convertToPlatformProperties", "convertToPlatformValue", "dpp"})
@SourceDebugExtension(value={"SMAP\nPlatformValueFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformValueFunctions.kt\norg/dashj/platform/dpp/util/PlatformValueFunctionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,185:1\n1549#2:186\n1620#2,3:187\n1549#2:192\n1620#2,3:193\n215#3,2:190\n215#3,2:196\n215#3,2:198\n215#3,2:200\n*S KotlinDebug\n*F\n+ 1 PlatformValueFunctions.kt\norg/dashj/platform/dpp/util/PlatformValueFunctionsKt\n*L\n114#1:186\n114#1:187,3\n129#1:192\n129#1:193,3\n120#1:190,2\n137#1:196,2\n172#1:198,2\n181#1:200,2\n*E\n"})
public final class PlatformValueFunctionsKt {
    @Nullable
    public static final Object convertPlatformValue(@NotNull PlatformValue value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PlatformValue.Tag tag = value.getTag();
        switch (tag == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 1: {
                object = value.getU128();
                break;
            }
            case 2: {
                object = value.getI128();
                break;
            }
            case 3: {
                object = value.getU64();
                break;
            }
            case 4: {
                object = value.getI64();
                break;
            }
            case 5: {
                object = value.getU32();
                break;
            }
            case 6: {
                object = value.getI32();
                break;
            }
            case 7: {
                object = value.getU16();
                break;
            }
            case 8: {
                object = value.getI16();
                break;
            }
            case 9: {
                object = value.getU8();
                break;
            }
            case 10: {
                object = value.getI8();
                break;
            }
            case 11: {
                object = value.getBytes();
                break;
            }
            case 12: {
                byte[] byArray = value.getBytes20();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.bytes20");
                object = new ByteArray20(byArray);
                break;
            }
            case 13: {
                byte[] byArray = value.getBytes32();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.bytes32");
                object = new ByteArray32(byArray);
                break;
            }
            case 14: {
                byte[] byArray = value.getBytes36();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.bytes36");
                object = new ByteArray36(byArray);
                break;
            }
            case 15: {
                byte[] byArray = value.getEnumU8();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.enumU8");
                object = new EnumBytes(byArray);
                break;
            }
            case 16: {
                List list = value.getEnumString();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"value.enumString");
                object = new EnumString(list);
                break;
            }
            case 17: {
                byte[] byArray = value.getIdentifier().getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.identifier.bytes");
                object = new org.dashj.platform.dpp.identifier.Identifier(byArray);
                break;
            }
            case 18: {
                object = value.getFloat();
                break;
            }
            case 19: {
                object = value.getText();
                break;
            }
            case 20: {
                object = value.getBool();
                break;
            }
            case 21: {
                object = null;
                break;
            }
            case 22: {
                object = PlatformValueFunctionsKt.convertPlatformValueArray(value);
                break;
            }
            case 23: {
                object = PlatformValueFunctionsKt.convertPlatformValueMap(value);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported Value " + value.getTag()).toString());
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> convertPlatformValueArray(@NotNull PlatformValue array) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(array.getTag() == PlatformValue.Tag.Array)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List list = array.getArray();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"array.array");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlatformValue platformValue = (PlatformValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(PlatformValueFunctionsKt.convertPlatformValue((PlatformValue)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Map<String, Object> convertPlatformValueMap(@NotNull PlatformValue map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (!(map.getTag() == PlatformValue.Tag.Map)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        HashMap hashMap = new HashMap();
        Map map2 = map.getMap().get_0();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"map.map._0");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            PlatformValue key = (PlatformValue)entry.getKey();
            PlatformValue value = (PlatformValue)entry.getValue();
            if (!(key.getTag() == PlatformValue.Tag.Text)) {
                string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Map map3 = hashMap;
            Intrinsics.checkNotNullExpressionValue((Object)key.getText(), (String)"key.text");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            Object object = PlatformValueFunctionsKt.convertPlatformValue(value);
            map3.put(string, object);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PlatformValue convertListToPlatformValue(@NotNull List<? extends Object> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void item;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PlatformValueFunctionsKt.convertToPlatformValue(item));
        }
        List list2 = (List)destination$iv$iv;
        return new PlatformValue(list2);
    }

    @NotNull
    public static final PlatformValue convertMapToPlatformValue(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        HashMap result = new HashMap();
        Map<String, ? extends Object> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            ((Map)result).put(new PlatformValue(key), PlatformValueFunctionsKt.convertToPlatformValue(value));
        }
        return new PlatformValue(new PlatformValueMap((Map)result));
    }

    @NotNull
    public static final PlatformValue convertToPlatformValue(@Nullable Object value) {
        PlatformValue platformValue;
        Object object = value;
        if (object instanceof Boolean) {
            platformValue = new PlatformValue(((Boolean)value).booleanValue());
        } else if (object instanceof String) {
            platformValue = new PlatformValue((String)value);
        } else if (object instanceof Byte) {
            platformValue = new PlatformValue(((Number)value).byteValue());
        } else if (object instanceof Short) {
            platformValue = new PlatformValue(((Number)value).shortValue());
        } else if (object instanceof Integer) {
            platformValue = new PlatformValue(((Number)value).intValue());
        } else if (object instanceof Long) {
            platformValue = new PlatformValue(((Number)value).longValue());
        } else if (object instanceof BigInteger) {
            platformValue = new PlatformValue((BigInteger)value);
        } else if (object instanceof byte[]) {
            platformValue = new PlatformValue((byte[])value, true);
        } else if (object instanceof ByteArray20) {
            platformValue = new PlatformValue(((ByteArray20)value).getBytes(), true);
        } else if (object instanceof ByteArray32) {
            platformValue = new PlatformValue(((ByteArray32)value).getBytes(), true);
        } else if (object instanceof ByteArray36) {
            platformValue = new PlatformValue(((ByteArray36)value).getBytes(), true);
        } else if (object instanceof EnumBytes) {
            platformValue = new PlatformValue(((EnumBytes)value).getBytes(), PlatformValue.Tag.EnumU8);
        } else if (object instanceof org.dashj.platform.dpp.identifier.Identifier) {
            platformValue = new PlatformValue(new Hash256(((org.dashj.platform.dpp.identifier.Identifier)value).toBuffer()));
        } else if (object instanceof Identifier) {
            platformValue = new PlatformValue(new Hash256(((Identifier)value).get_0().get_0()));
        } else if (object instanceof EnumString) {
            platformValue = PlatformValueFunctionsKt.convertEnumStringToPlatformValue((EnumString)value);
        } else if (object instanceof List) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
            platformValue = PlatformValueFunctionsKt.convertListToPlatformValue((List)value);
        } else if (object instanceof Map) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            platformValue = PlatformValueFunctionsKt.convertMapToPlatformValue((Map)value);
        } else if (value == null) {
            platformValue = new PlatformValue();
        } else {
            throw new IllegalStateException(("no conversion for " + value).toString());
        }
        return platformValue;
    }

    @NotNull
    public static final PlatformValue convertEnumStringToPlatformValue(@NotNull EnumString value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new PlatformValue((List)value, true);
    }

    @NotNull
    public static final Map<String, PlatformValue> convertToPlatformProperties(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        HashMap result = new HashMap();
        Map<String, ? extends Object> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            ((Map)result).put(key, PlatformValueFunctionsKt.convertToPlatformValue(value));
        }
        return result;
    }

    @NotNull
    public static final Map<String, Object> convertProperties(@NotNull Map<String, ? extends PlatformValue> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        HashMap result = new HashMap();
        Map<String, ? extends PlatformValue> $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends PlatformValue>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends PlatformValue> element$iv;
            Map.Entry<String, ? extends PlatformValue> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            PlatformValue value = entry.getValue();
            ((Map)result).put(key, PlatformValueFunctionsKt.convertPlatformValue(value));
        }
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlatformValue.Tag.values().length];
            try {
                nArray[PlatformValue.Tag.U128.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.I128.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.U64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.I64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.U32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.I32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.U16.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.I16.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.U8.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.I8.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Bytes.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Bytes20.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Bytes32.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Bytes36.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.EnumU8.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.EnumString.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Identifier.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Float.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Text.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Bool.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Null.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Array.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformValue.Tag.Map.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

