/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.AbstractBitcoinNetParams;
import org.bitcoinj.params.BinTangDevNetParams;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.wallet.AuthenticationKeyChain;
import org.bitcoinj.wallet.DerivationPathFactory;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.KeyChainGroup;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.authentication.AuthenticationGroupExtension;
import org.dashj.platform.dapiclient.DapiClient;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.dashj.platform.sdk.client.ClientApps;
import org.dashj.platform.sdk.client.ClientOptions;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/dashj/platform/sdk/Client;", "", "clientOptions", "Lorg/dashj/platform/sdk/client/ClientOptions;", "(Lorg/dashj/platform/sdk/client/ClientOptions;)V", "apps", "Lorg/dashj/platform/sdk/client/ClientApps;", "getApps", "()Lorg/dashj/platform/sdk/client/ClientApps;", "authenticationExtension", "Lorg/bitcoinj/wallet/authentication/AuthenticationGroupExtension;", "getAuthenticationExtension", "()Lorg/bitcoinj/wallet/authentication/AuthenticationGroupExtension;", "dapiClient", "Lorg/dashj/platform/dapiclient/DapiClient;", "getDapiClient", "()Lorg/dashj/platform/dapiclient/DapiClient;", "params", "Lorg/bitcoinj/params/AbstractBitcoinNetParams;", "kotlin.jvm.PlatformType", "getParams", "()Lorg/bitcoinj/params/AbstractBitcoinNetParams;", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "wallet", "Lorg/bitcoinj/wallet/Wallet;", "getWallet", "()Lorg/bitcoinj/wallet/Wallet;", "setWallet", "(Lorg/bitcoinj/wallet/Wallet;)V", "dpp"})
public final class Client {
    @NotNull
    private final ClientOptions clientOptions;
    private final AbstractBitcoinNetParams params;
    @NotNull
    private final Platform platform;
    @Nullable
    private Wallet wallet;
    @NotNull
    private final AuthenticationGroupExtension authenticationExtension;

    /*
     * WARNING - void declaration
     */
    public Client(@NotNull ClientOptions clientOptions) {
        DapiClient dapiClient;
        boolean isTestnet;
        DeterministicSeed seed;
        DeterministicSeed deterministicSeed;
        boolean needWallet;
        AbstractBitcoinNetParams abstractBitcoinNetParams;
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        switch (this.clientOptions.getNetwork()) {
            case "testnet": {
                abstractBitcoinNetParams = (AbstractBitcoinNetParams)TestNet3Params.get();
                break;
            }
            case "bintang": {
                abstractBitcoinNetParams = (AbstractBitcoinNetParams)BinTangDevNetParams.get();
                break;
            }
            case "mainnet": {
                abstractBitcoinNetParams = (AbstractBitcoinNetParams)MainNetParams.get();
                break;
            }
            default: {
                throw new IllegalArgumentException("network " + this.clientOptions.getNetwork() + " is not valid");
            }
        }
        AbstractBitcoinNetParams abstractBitcoinNetParams2 = this.params = abstractBitcoinNetParams;
        Intrinsics.checkNotNullExpressionValue((Object)abstractBitcoinNetParams2, (String)"params");
        this.platform = new Platform((NetworkParameters)abstractBitcoinNetParams2);
        this.authenticationExtension = new AuthenticationGroupExtension((NetworkParameters)this.params);
        boolean bl = needWallet = this.clientOptions.getWalletOptions() != null;
        if (this.clientOptions.getWalletOptions() != null) {
            if (this.clientOptions.getWalletOptions().getMnemonic() != null) {
                char[] cArray = new char[]{' '};
                DeterministicSeed deterministicSeed2 = new DeterministicSeed(StringsKt.split$default((CharSequence)this.clientOptions.getWalletOptions().getMnemonic(), (char[])cArray, (boolean)false, (int)0, (int)6, null), null, "", this.clientOptions.getWalletOptions().getCreationTime());
                deterministicSeed = deterministicSeed2;
            } else {
                deterministicSeed = null;
            }
        } else {
            deterministicSeed = seed = null;
        }
        if (needWallet) {
            void $this$_init__u24lambda_u240;
            Wallet wallet;
            DeterministicKeyChain.Builder chainBuilder = DeterministicKeyChain.builder().accountPath(DerivationPathFactory.get((NetworkParameters)this.platform.getParams()).bip44DerivationPath(this.clientOptions.getWalletAccountIndex()));
            if (seed != null) {
                chainBuilder.seed(seed);
            }
            Wallet wallet2 = wallet = new Wallet(this.platform.getParams(), KeyChainGroup.builder((NetworkParameters)this.platform.getParams()).addChain(chainBuilder.build()).build());
            Client client = this;
            boolean bl2 = false;
            this.authenticationExtension.addKeyChains($this$_init__u24lambda_u240.getParams(), $this$_init__u24lambda_u240.getKeyChainSeed(), EnumSet.of((Enum)AuthenticationKeyChain.KeyChainType.BLOCKCHAIN_IDENTITY_FUNDING, (Enum)AuthenticationKeyChain.KeyChainType.BLOCKCHAIN_IDENTITY_TOPUP, (Enum)AuthenticationKeyChain.KeyChainType.BLOCKCHAIN_IDENTITY, (Enum)AuthenticationKeyChain.KeyChainType.INVITATION_FUNDING));
            $this$_init__u24lambda_u240.addExtension((WalletExtension)this.authenticationExtension);
            client.wallet = wallet;
        }
        boolean bl3 = isTestnet = !Intrinsics.areEqual((Object)this.params.getId(), (Object)"org.darkcoin.production");
        if (this.clientOptions.getDapiAddressListProvider() != null) {
            dapiClient = new DapiClient(this.clientOptions.getDapiAddressListProvider(), this.platform.getDpp(), true, isTestnet, this.clientOptions.getTimeout(), this.clientOptions.getRetries(), this.clientOptions.getBanBaseTime(), 0, 128, null);
        } else if (!((Collection)this.clientOptions.getDapiAddresses()).isEmpty()) {
            dapiClient = new DapiClient(this.clientOptions.getDapiAddresses(), this.platform.getDpp(), true, isTestnet, this.clientOptions.getTimeout(), this.clientOptions.getRetries(), this.clientOptions.getBanBaseTime(), 0, 128, null);
        } else {
            String[] stringArray = this.params.getDefaultHPMasternodeList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"params.defaultHPMasternodeList");
            dapiClient = new DapiClient(ArraysKt.toList((Object[])stringArray), this.platform.getDpp(), true, isTestnet, this.clientOptions.getTimeout(), this.clientOptions.getRetries(), this.clientOptions.getBanBaseTime(), 0, 128, null);
        }
        this.platform.setClient(dapiClient);
        this.platform.getApps().putAll(this.clientOptions.getApps());
    }

    public final AbstractBitcoinNetParams getParams() {
        return this.params;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final DapiClient getDapiClient() {
        return this.platform.getClient();
    }

    @NotNull
    public final ClientApps getApps() {
        return new ClientApps((Map<String, ClientAppDefinition>)this.platform.getApps());
    }

    @Nullable
    public final Wallet getWallet() {
        return this.wallet;
    }

    public final void setWallet(@Nullable Wallet wallet) {
        this.wallet = wallet;
    }

    @NotNull
    public final AuthenticationGroupExtension getAuthenticationExtension() {
        return this.authenticationExtension;
    }
}

