/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0015\u001a\u00020\u0004H\u0016R*\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0007j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/dashj/platform/sdk/client/ClientApps;", "", "apps", "", "", "Lorg/dashj/platform/sdk/client/ClientAppDefinition;", "(Ljava/util/Map;)V", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "names", "", "getNames", "()Ljava/util/List;", "addAll", "", "get", "name", "has", "", "set", "definition", "toString", "dpp"})
public final class ClientApps {
    @NotNull
    private final HashMap<String, ClientAppDefinition> apps;

    public ClientApps(@NotNull Map<String, ClientAppDefinition> apps) {
        Intrinsics.checkNotNullParameter(apps, (String)"apps");
        this.apps = new HashMap();
        this.apps.putAll(apps);
    }

    @NotNull
    public final List<String> getNames() {
        Set<String> set = this.apps.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"apps.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    public final void addAll(@NotNull Map<String, ClientAppDefinition> apps) {
        Intrinsics.checkNotNullParameter(apps, (String)"apps");
        this.apps.putAll(apps);
    }

    public final void set(@NotNull String name, @NotNull ClientAppDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        ((Map)this.apps).put(name, definition);
    }

    @NotNull
    public final ClientAppDefinition get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.apps.containsKey(name)) {
            throw new Exception("Application with name " + name + " is not defined");
        }
        ClientAppDefinition clientAppDefinition = this.apps.get(name);
        Intrinsics.checkNotNull((Object)clientAppDefinition);
        return clientAppDefinition;
    }

    public final boolean has(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.apps.containsKey(name);
    }

    @NotNull
    public String toString() {
        return "ClientApps(" + this.apps + ')';
    }
}

