/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.platform;

import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.ECKey;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.contract.DataContractCreateTransition;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\n2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00132\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/dashj/platform/sdk/platform/Contracts;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "broadcast", "Lorg/dashj/platform/dpp/contract/DataContractCreateTransition;", "dataContract", "Lorg/dashj/platform/dpp/contract/DataContract;", "identity", "Lorg/dashj/platform/dpp/identity/Identity;", "privateKey", "Lorg/bitcoinj/core/ECKey;", "index", "", "create", "documentDefinitions", "", "", "get", "identifier", "Lorg/dashj/platform/dpp/identifier/Identifier;", "Companion", "dpp"})
public final class Contracts {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    private static final Logger log;

    public Contracts(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final DataContractCreateTransition broadcast(@NotNull DataContract dataContract, @NotNull Identity identity, @NotNull ECKey privateKey, int index) {
        Intrinsics.checkNotNullParameter((Object)dataContract, (String)"dataContract");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        DataContractCreateTransition dataContractCreateTransition = this.platform.getDpp().getDataContract().createDataContractCreateTransition(dataContract);
        this.platform.broadcastStateTransition(dataContractCreateTransition, identity, privateKey, index);
        return dataContractCreateTransition;
    }

    @NotNull
    public final DataContract create(@NotNull Map<String, Object> documentDefinitions, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter(documentDefinitions, (String)"documentDefinitions");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return this.platform.getDpp().getDataContract().create(identity.getId().toBuffer(), documentDefinitions);
    }

    @Nullable
    public final DataContract get(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(Identifier.Companion.from$default(Identifier.Companion, identifier, null, 2, null));
    }

    @Nullable
    public final DataContract get(@NotNull Identifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        ClientAppDefinition localContract = null;
        for (String appName : this.platform.getApps().keySet()) {
            ClientAppDefinition app;
            ClientAppDefinition clientAppDefinition = app = this.platform.getApps().get(appName);
            Intrinsics.checkNotNull((Object)clientAppDefinition);
            if (!Intrinsics.areEqual((Object)clientAppDefinition.getContractId(), (Object)identifier)) continue;
            localContract = app;
            break;
        }
        ClientAppDefinition clientAppDefinition = localContract;
        if ((clientAppDefinition != null ? clientAppDefinition.getContract() : null) != null) {
            return localContract.getContract();
        }
        try {
            DataContract dataContract = this.platform.getStateRepository().fetchDataContract(identifier);
            Intrinsics.checkNotNull((Object)dataContract);
            DataContract contract = dataContract;
            ClientAppDefinition app = new ClientAppDefinition(contract.getId(), contract);
            if (localContract == null) {
                Map map = this.platform.getApps();
                String string = new Date().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Date().toString()");
                map.put(string, app);
            } else {
                localContract.setContract(contract);
            }
            return contract;
        }
        catch (Exception e) {
            log.error("Failed to get dataContract: " + e);
            throw e;
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(Contracts.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Contracts::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dashj/platform/sdk/platform/Contracts$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

