/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.platform;

import com.google.common.base.Preconditions;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.document.Document;
import org.dashj.platform.dpp.document.DocumentFactory;
import org.dashj.platform.dpp.errors.DriveErrorMetadata;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.voting.ContenderWithSerializedDocument;
import org.dashj.platform.dpp.voting.Contenders;
import org.dashj.platform.dpp.voting.ContestedDocumentResourceVotePoll;
import org.dashj.platform.dpp.voting.ResourceVote;
import org.dashj.platform.dpp.voting.ResourceVoteChoice;
import org.dashj.platform.dpp.voting.Vote;
import org.dashj.platform.dpp.voting.VotePoll;
import org.dashj.platform.dpp.voting.VotePollsGroupedByTimestamp;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.dashj.platform.sdk.platform.Contracts;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJL\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J,\u0010\r\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00172\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00010%J\u001e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010$\u001a\u00020*J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020*J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010,\u001a\u00020*JJ\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\u0006\u00103\u001a\u0002002\b\b\u0002\u00104\u001a\u0002022\b\b\u0002\u00105\u001a\u000202J*\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019072\u0006\u0010\"\u001a\u00020\u00192\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001909H\u0002J,\u0010:\u001a\u00020;2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eJ4\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eJT\u0010?\u001a\b\u0012\u0004\u0012\u00020.0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\u0006\u00103\u001a\u0002002\b\b\u0002\u00104\u001a\u0002022\b\b\u0002\u0010@\u001a\u00020A2\b\b\u0002\u00105\u001a\u000202R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006C"}, d2={"Lorg/dashj/platform/sdk/platform/Documents;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "broadcast", "", "identity", "Lorg/dashj/platform/dpp/identity/Identity;", "privateKey", "Lorg/bitcoinj/core/ECKey;", "create", "", "Lorg/dashj/platform/dpp/document/Document;", "replace", "delete", "broadcastVote", "Lorg/dashj/platform/dpp/voting/Vote;", "resourceVoteChoice", "Lorg/dashj/platform/dpp/voting/ResourceVoteChoice;", "dataContractId", "Lorg/dashj/platform/dpp/identifier/Identifier;", "documentType", "", "indexName", "indexValues", "voterProTxHash", "Lorg/bitcoinj/core/Sha256Hash;", "identityPublicKey", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "signerCallback", "Lorg/dashj/platform/sdk/callbacks/Signer;", "typeLocator", "userId", "opts", "", "deserialize", "bytes", "", "get", "Lorg/dashj/platform/dapiclient/model/DocumentQuery;", "getAll", "documentQuery", "getAllVotePolls", "Lorg/dashj/platform/dpp/voting/VotePoll;", "startTime", "", "startTimeIncluded", "", "endTime", "endTimeIncluded", "orderAscending", "getAppnameAndType", "Lkotlin/Pair;", "appNames", "", "getVoteContenders", "Lorg/dashj/platform/dpp/voting/Contenders;", "indexes", "getVoteFromMasternode", "proTxHash", "getVotePolls", "limit", "", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nDocuments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Documents.kt\norg/dashj/platform/sdk/platform/Documents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n1855#2:331\n1855#2,2:332\n1856#2:334\n766#2:335\n857#2,2:336\n*S KotlinDebug\n*F\n+ 1 Documents.kt\norg/dashj/platform/sdk/platform/Documents\n*L\n253#1:331\n254#1:332,2\n253#1:334\n313#1:335\n313#1:336,2\n*E\n"})
public final class Documents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    public static final int DOCUMENT_LIMIT = 100;
    @NotNull
    private static final Logger log;

    public Documents(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    public final void broadcast(@NotNull Identity identity, @NotNull ECKey privateKey, @Nullable List<Document> create, @Nullable List<Document> replace, @Nullable List<Document> delete) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        HashMap transitionMap = new HashMap();
        if (create != null) {
            ((Map)transitionMap).put("create", create);
        }
        if (replace != null) {
            ((Map)transitionMap).put("replace", replace);
        }
        if (delete != null) {
            ((Map)transitionMap).put("delete", delete);
        }
        throw new NotImplementedError(null, 1, null);
    }

    public static /* synthetic */ void broadcast$default(Documents documents, Identity identity, ECKey eCKey, List list, List list2, List list3, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        documents.broadcast(identity, eCKey, list, list2, list3);
    }

    @NotNull
    public final Document create(@NotNull String typeLocator, @NotNull Identifier userId, @NotNull Map<String, Object> opts) {
        Intrinsics.checkNotNullParameter((Object)typeLocator, (String)"typeLocator");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        DashPlatformProtocol dpp = this.platform.getDpp();
        Set<String> set = this.platform.getApps().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"platform.apps.keys");
        Set<String> appNames = set;
        Pair<String, String> pair = this.getAppnameAndType(typeLocator, appNames);
        String appName = (String)pair.component1();
        String fieldType = (String)pair.component2();
        if (!this.platform.getApps().containsKey(appName)) {
            throw new Exception("Cannot find contractId for " + appName);
        }
        Contracts contracts = this.platform.getContracts();
        ClientAppDefinition clientAppDefinition = this.platform.getApps().get(appName);
        Intrinsics.checkNotNull((Object)clientAppDefinition);
        DataContract dataContract = contracts.get(clientAppDefinition.getContractId());
        DocumentFactory documentFactory = dpp.getDocument();
        DataContract dataContract2 = dataContract;
        Intrinsics.checkNotNull((Object)dataContract2);
        return documentFactory.create(dataContract2, userId, fieldType, opts);
    }

    private final Pair<String, String> getAppnameAndType(String typeLocator, Set<String> appNames) {
        String appName = null;
        String fieldType = null;
        if (StringsKt.contains$default((CharSequence)typeLocator, (char)'.', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'.'};
            List split = StringsKt.split$default((CharSequence)typeLocator, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            appName = (String)split.get(0);
            fieldType = (String)split.get(1);
        } else {
            appName = (String)CollectionsKt.first((Iterable)appNames);
            fieldType = typeLocator;
        }
        return new Pair((Object)appName, (Object)fieldType);
    }

    @NotNull
    public final List<Document> getAll(@NotNull String typeLocator, @NotNull DocumentQuery documentQuery) {
        Intrinsics.checkNotNullParameter((Object)typeLocator, (String)"typeLocator");
        Intrinsics.checkNotNullParameter((Object)documentQuery, (String)"documentQuery");
        DocumentQuery query = documentQuery.clone();
        int limit = query.getLimit();
        int total = 0;
        if (limit > 100) {
            query.setLimit(100);
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        List<Document> documentList = null;
        int requests = 0;
        do {
            try {
                documentList = this.platform.getDocuments().get(typeLocator, query);
                ++requests;
                if (!((Collection)documentList).isEmpty()) {
                    if (limit == -1) {
                        documents.addAll((Collection)documentList);
                    } else if (total + documentList.size() > limit) {
                        int cfr_ignored_0 = total - limit;
                        int n = limit - total;
                        for (int i = 0; i < n; ++i) {
                            documents.add(documentList.get(i));
                        }
                    } else {
                        documents.addAll((Collection)documentList);
                    }
                    query.setStartAt(((Document)CollectionsKt.last(documentList)).getId());
                }
                total += documentList.size();
            }
            catch (Exception e) {
                log.warn("Exception " + e);
                throw e;
            }
        } while (requests == 0 || documentList.size() >= 100);
        return documents;
    }

    @NotNull
    public final List<Document> get(@NotNull String typeLocator, @NotNull DocumentQuery opts) {
        Intrinsics.checkNotNullParameter((Object)typeLocator, (String)"typeLocator");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Set<String> set = this.platform.getApps().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"platform.apps.keys");
        Set<String> appNames = set;
        Pair<String, String> pair = this.getAppnameAndType(typeLocator, appNames);
        String appName = (String)pair.component1();
        String fieldType = (String)pair.component2();
        if (!this.platform.getApps().containsKey(appName)) {
            throw new Exception("No app named " + appName + " specified.");
        }
        ClientAppDefinition appDefinition = this.platform.getApps().get(appName);
        if (appDefinition == null || appDefinition.getContractId().toBuffer().length == 0) {
            throw new Exception("Missing contract ID for " + appName);
        }
        Identifier contractId = appDefinition.getContractId();
        return this.get(contractId, fieldType, opts);
    }

    @NotNull
    public final List<Document> get(@NotNull Identifier dataContractId, @NotNull String documentType, @NotNull DocumentQuery opts) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        try {
            return this.platform.getStateRepository().fetchDocuments(dataContractId, documentType, opts);
        }
        catch (StatusRuntimeException e) {
            log.error("Document query: unable to get documents of " + dataContractId + ": " + new DriveErrorMetadata(String.valueOf(e.getTrailers())) + "  with " + opts, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Document query: unable to get documents of " + dataContractId + " with " + opts, (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final Document deserialize(@NotNull byte[] bytes, @NotNull Identifier dataContractId, @NotNull String documentType) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        return this.platform.getClient().deserializeDocument(bytes, dataContractId, documentType);
    }

    @NotNull
    public final Contenders getVoteContenders(@NotNull Identifier dataContractId, @NotNull String documentType, @NotNull String indexName, @NotNull List<String> indexes) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        Preconditions.checkArgument((((CharSequence)documentType).length() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((((CharSequence)indexName).length() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!((Collection)indexes).isEmpty() ? 1 : 0) != 0);
        return this.platform.getClient().getVoteContenders(dataContractId, documentType, indexName, indexes);
    }

    @NotNull
    public final Vote broadcastVote(@NotNull ResourceVoteChoice resourceVoteChoice, @NotNull Identifier dataContractId, @NotNull String documentType, @NotNull String indexName, @NotNull List<String> indexValues, @NotNull Sha256Hash voterProTxHash, @NotNull IdentityPublicKey identityPublicKey, @NotNull Signer signerCallback) {
        Intrinsics.checkNotNullParameter((Object)resourceVoteChoice, (String)"resourceVoteChoice");
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter(indexValues, (String)"indexValues");
        Intrinsics.checkNotNullParameter((Object)voterProTxHash, (String)"voterProTxHash");
        Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
        Intrinsics.checkNotNullParameter((Object)signerCallback, (String)"signerCallback");
        Vote vote = new Vote(new ResourceVote(resourceVoteChoice, new ContestedDocumentResourceVotePoll(dataContractId, documentType, indexName, indexValues)));
        return this.platform.getClient().broadcastVote(vote, voterProTxHash, identityPublicKey, signerCallback);
    }

    @NotNull
    public final List<VotePoll> getVotePolls(@NotNull Identifier dataContractId, @NotNull String documentType, long startTime, boolean startTimeIncluded, long endTime, boolean endTimeIncluded, int limit, boolean orderAscending) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        VotePollsGroupedByTimestamp votePollsGroupedByTimestamp = this.platform.getClient().getVotePolls(startTime, startTimeIncluded, endTime, endTimeIncluded, limit, orderAscending);
        ArrayList<VotePoll> result = new ArrayList<VotePoll>();
        Iterable $this$forEach$iv = votePollsGroupedByTimestamp.getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair votePollGroup = (Pair)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)votePollGroup.getSecond();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VotePoll votePoll = (VotePoll)element$iv2;
                boolean bl2 = false;
                if (!(votePoll instanceof ContestedDocumentResourceVotePoll) || !Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)votePoll).getDataContractId(), (Object)dataContractId) || !Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)votePoll).getDocumentTypeName(), (Object)documentType)) continue;
                result.add(votePoll);
            }
        }
        return result;
    }

    public static /* synthetic */ List getVotePolls$default(Documents documents, Identifier identifier, String string, long l, boolean bl, long l2, boolean bl2, int n, boolean bl3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x40) != 0) {
            n = 100;
        }
        if ((n2 & 0x80) != 0) {
            bl3 = true;
        }
        return documents.getVotePolls(identifier, string, l, bl, l2, bl2, n, bl3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VotePoll> getAllVotePolls(@NotNull Identifier dataContractId, @NotNull String documentType, long startTime, boolean startTimeIncluded, long endTime, boolean endTimeIncluded, boolean orderAscending) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        int count = 0;
        long currentStartTime = startTime;
        boolean currentStartTimeIncluded = startTimeIncluded;
        ArrayList results = new ArrayList();
        do {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            long l;
            List<VotePoll> batch = this.getVotePolls(dataContractId, documentType, currentStartTime, currentStartTimeIncluded, endTime, endTimeIncluded, 100, orderAscending);
            count = batch.size();
            VotePoll lastVotePoll = (VotePoll)CollectionsKt.lastOrNull(batch);
            if (lastVotePoll instanceof ContestedDocumentResourceVotePoll) {
                long contenders2;
                Contenders voteContenders = this.getVoteContenders(((ContestedDocumentResourceVotePoll)lastVotePoll).getDataContractId(), ((ContestedDocumentResourceVotePoll)lastVotePoll).getDocumentTypeName(), ((ContestedDocumentResourceVotePoll)lastVotePoll).getIndexName(), ((ContestedDocumentResourceVotePoll)lastVotePoll).getIndexValues());
                Iterator iterator = ((Iterable)voteContenders.getMap().entrySet()).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry contenders2 = (Map.Entry)iterator.next();
                boolean bl = false;
                byte[] byArray = ((ContenderWithSerializedDocument)contenders2.getValue()).getSerializedDocument();
                Intrinsics.checkNotNull((Object)byArray);
                Document document = this.deserialize(byArray, ((ContestedDocumentResourceVotePoll)lastVotePoll).getDataContractId(), ((ContestedDocumentResourceVotePoll)lastVotePoll).getDocumentTypeName());
                Long l2 = document.getCreatedAt();
                long l3 = contenders2 = l2 != null ? l2 : 0L;
                while (iterator.hasNext()) {
                    Map.Entry contenders222 = (Map.Entry)iterator.next();
                    $i$a$-minOf-Documents$getAllVotePolls$createdAt$1 = false;
                    byte[] byArray2 = ((ContenderWithSerializedDocument)contenders222.getValue()).getSerializedDocument();
                    Intrinsics.checkNotNull((Object)byArray2);
                    Document document2 = this.deserialize(byArray2, ((ContestedDocumentResourceVotePoll)lastVotePoll).getDataContractId(), ((ContestedDocumentResourceVotePoll)lastVotePoll).getDocumentTypeName());
                    Long l4 = document2.getCreatedAt();
                    long contenders222 = l4 != null ? l4 : 0L;
                    if (contenders2 <= contenders222) continue;
                    contenders2 = contenders222;
                }
                long createdAt = contenders2;
                l = createdAt + Companion.votingPeriod(this.platform.getParams());
            } else {
                l = -1L;
            }
            currentStartTime = l;
            currentStartTimeIncluded = true;
            Iterable iterable = batch;
            ArrayList arrayList = results;
            boolean $i$f$filter = false;
            void createdAt = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VotePoll it = (VotePoll)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it instanceof ContestedDocumentResourceVotePoll ? Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)it).getDataContractId(), (Object)dataContractId) && Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)it).getDocumentTypeName(), (Object)documentType) : false;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            arrayList.addAll((List)destination$iv$iv);
        } while (count == 100 && currentStartTime != -1L);
        return results;
    }

    public static /* synthetic */ List getAllVotePolls$default(Documents documents, Identifier identifier, String string, long l, boolean bl, long l2, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        if ((n & 0x40) != 0) {
            bl3 = true;
        }
        return documents.getAllVotePolls(identifier, string, l, bl, l2, bl2, bl3);
    }

    public final void getVoteFromMasternode(@NotNull Sha256Hash proTxHash, @NotNull Identifier dataContractId, @NotNull String documentType, @NotNull String indexName, @NotNull List<String> indexes) {
        Intrinsics.checkNotNullParameter((Object)proTxHash, (String)"proTxHash");
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        this.platform.getClient().getLastVoteFromMasternode(proTxHash, dataContractId, documentType, indexName, indexes);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Documents.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Documents::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/dashj/platform/sdk/platform/Documents$Companion;", "", "()V", "DOCUMENT_LIMIT", "", "log", "Lorg/slf4j/Logger;", "votingPeriod", "", "params", "Lorg/bitcoinj/core/NetworkParameters;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public final long votingPeriod(@NotNull NetworkParameters params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return Intrinsics.areEqual((Object)params.getId(), (Object)"org.darkcoin.production") ? TimeUnit.DAYS.toMillis(14L) : TimeUnit.MINUTES.toMillis(90L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

