/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.platform;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.evolution.AssetLockTransaction;
import org.bitcoinj.quorums.InstantSendLock;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.ChainAssetLockProof;
import org.dashj.platform.dpp.identity.IdentityTopUpTransition;
import org.dashj.platform.dpp.identity.InstantAssetLockProof;
import org.dashj.platform.sdk.AssetLockProof;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.Identity;
import org.dashj.platform.sdk.IdentityPublicKey;
import org.dashj.platform.sdk.IdentityV0;
import org.dashj.platform.sdk.KeyID;
import org.dashj.platform.sdk.Revision;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.dashsdk;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ<\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ<\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ,\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lorg/dashj/platform/sdk/platform/Identities;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "get", "Lorg/dashj/platform/dpp/identity/Identity;", "id", "", "Lorg/dashj/platform/dpp/identifier/Identifier;", "getByPublicKeyHash", "pubKeyHash", "", "register", "outputIndex", "", "transaction", "Lorg/bitcoinj/evolution/AssetLockTransaction;", "coreHeight", "assetLockPrivateKey", "Lorg/bitcoinj/core/ECKey;", "identityPublicKeys", "", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "signer", "Lorg/dashj/platform/sdk/callbacks/Signer;", "instantLock", "Lorg/bitcoinj/quorums/InstantSendLock;", "signedLockTransaction", "topUp", "", "identityId", "Lorg/bitcoinj/core/Transaction;", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nIdentities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Identities.kt\norg/dashj/platform/sdk/platform/Identities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1208#2,2:169\n1238#2,4:171\n1208#2,2:175\n1238#2,4:177\n*S KotlinDebug\n*F\n+ 1 Identities.kt\norg/dashj/platform/sdk/platform/Identities\n*L\n61#1:169,2\n61#1:171,4\n98#1:175,2\n98#1:177,4\n*E\n"})
public final class Identities {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    private static final Logger log;

    public Identities(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final org.dashj.platform.dpp.identity.Identity register(@NotNull AssetLockTransaction signedLockTransaction, @NotNull InstantSendLock instantLock, @NotNull List<org.dashj.platform.dpp.identity.IdentityPublicKey> identityPublicKeys, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)signedLockTransaction, (String)"signedLockTransaction");
        Intrinsics.checkNotNullParameter((Object)instantLock, (String)"instantLock");
        Intrinsics.checkNotNullParameter(identityPublicKeys, (String)"identityPublicKeys");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        ECKey eCKey = signedLockTransaction.getAssetLockPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"signedLockTransaction.assetLockPublicKey");
        return this.register(0L, signedLockTransaction, instantLock, eCKey, identityPublicKeys, signer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.dashj.platform.dpp.identity.Identity register(long outputIndex, @NotNull AssetLockTransaction transaction, @NotNull InstantSendLock instantLock, @NotNull ECKey assetLockPrivateKey, @NotNull List<org.dashj.platform.dpp.identity.IdentityPublicKey> identityPublicKeys, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)instantLock, (String)"instantLock");
        Intrinsics.checkNotNullParameter((Object)assetLockPrivateKey, (String)"assetLockPrivateKey");
        Intrinsics.checkNotNullParameter(identityPublicKeys, (String)"identityPublicKeys");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        try {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            InstantAssetLockProof assetLock = new InstantAssetLockProof(outputIndex, (Transaction)transaction, instantLock);
            org.dashj.platform.dpp.identifier.Identifier identityId = assetLock.createIdentifier();
            Iterable iterable = identityPublicKeys;
            Identifier identifier = identityId.toNative();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var14_15 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                org.dashj.platform.dpp.identity.IdentityPublicKey identityPublicKey = (org.dashj.platform.dpp.identity.IdentityPublicKey)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                org.dashj.platform.dpp.identity.IdentityPublicKey it = (org.dashj.platform.dpp.identity.IdentityPublicKey)element$iv$iv;
                KeyID keyID = new KeyID(it.getId());
                boolean bl2 = false;
                IdentityPublicKey identityPublicKey2 = it.toNative();
                map.put(keyID, identityPublicKey2);
            }
            Revision revision = new Revision(1);
            BigInteger bigInteger = BigInteger.ZERO;
            Map map = destination$iv$iv;
            Identifier identifier2 = identifier;
            IdentityV0 identityV0 = new IdentityV0(identifier2, map, bigInteger, revision);
            Identity identity = new Identity(identityV0);
            Result identityResult = dashsdk.platformMobilePutPutIdentitySdk((SWIGTYPE_p_DashSdk)this.platform.getRustSdk(), (Identity)identity, (AssetLockProof)new AssetLockProof(assetLock.toNative()), (byte[])assetLockPrivateKey.getPrivKeyBytes(), (long)signer.getNativeContext(), (BigInteger)BigInteger.valueOf(signer.getSignerCallback()), (boolean)this.platform.isTestNet());
            Object object = identityResult.unwrap();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identityResult.unwrap()");
            return new org.dashj.platform.dpp.identity.Identity((Identity)object);
        }
        catch (Exception e) {
            log.info("registerIdentity failure: " + e);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.dashj.platform.dpp.identity.Identity register(long outputIndex, @NotNull AssetLockTransaction transaction, long coreHeight, @NotNull ECKey assetLockPrivateKey, @NotNull List<org.dashj.platform.dpp.identity.IdentityPublicKey> identityPublicKeys, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)assetLockPrivateKey, (String)"assetLockPrivateKey");
        Intrinsics.checkNotNullParameter(identityPublicKeys, (String)"identityPublicKeys");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        try {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            log.info("AssetLockTransaction: " + transaction.getTxId());
            TransactionOutPoint transactionOutPoint = transaction.getOutput(outputIndex).getOutPointFor();
            Intrinsics.checkNotNullExpressionValue((Object)transactionOutPoint, (String)"transaction.getOutput(outputIndex).outPointFor");
            ChainAssetLockProof assetLock = new ChainAssetLockProof(coreHeight, transactionOutPoint);
            org.dashj.platform.dpp.identifier.Identifier identityId = assetLock.createIdentifier();
            Iterable iterable = identityPublicKeys;
            Identifier identifier = identityId.toNative();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var15_15 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                org.dashj.platform.dpp.identity.IdentityPublicKey identityPublicKey = (org.dashj.platform.dpp.identity.IdentityPublicKey)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                org.dashj.platform.dpp.identity.IdentityPublicKey it = (org.dashj.platform.dpp.identity.IdentityPublicKey)element$iv$iv;
                KeyID keyID = new KeyID(it.getId());
                boolean bl2 = false;
                IdentityPublicKey identityPublicKey2 = it.toNative();
                map.put(keyID, identityPublicKey2);
            }
            Revision revision = new Revision(1);
            BigInteger bigInteger = BigInteger.ZERO;
            Map map = destination$iv$iv;
            Identifier identifier2 = identifier;
            IdentityV0 identityV0 = new IdentityV0(identifier2, map, bigInteger, revision);
            Identity identity = new Identity(identityV0);
            Result identityResult = dashsdk.platformMobilePutPutIdentitySdk((SWIGTYPE_p_DashSdk)this.platform.getRustSdk(), (Identity)identity, (AssetLockProof)new AssetLockProof(assetLock.toNative()), (byte[])assetLockPrivateKey.getPrivKeyBytes(), (long)signer.getNativeContext(), (BigInteger)BigInteger.valueOf(signer.getSignerCallback()), (boolean)this.platform.isTestNet());
            Object object = identityResult.unwrap();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identityResult.unwrap()");
            return new org.dashj.platform.dpp.identity.Identity((Identity)object);
        }
        catch (Exception e) {
            log.info("registerIdentity failure: ", (Throwable)e);
            throw e;
        }
    }

    @Nullable
    public final org.dashj.platform.dpp.identity.Identity get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.get(Identifier.Companion.from$default(org.dashj.platform.dpp.identifier.Identifier.Companion, id, null, 2, null));
    }

    @Nullable
    public final org.dashj.platform.dpp.identity.Identity get(@NotNull org.dashj.platform.dpp.identifier.Identifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.platform.getStateRepository().fetchIdentity(id);
    }

    @Nullable
    public final org.dashj.platform.dpp.identity.Identity getByPublicKeyHash(@NotNull byte[] pubKeyHash) {
        Intrinsics.checkNotNullParameter((Object)pubKeyHash, (String)"pubKeyHash");
        return this.platform.getStateRepository().fetchIdentityFromPubKeyHash(pubKeyHash);
    }

    public final boolean topUp(@NotNull org.dashj.platform.dpp.identifier.Identifier identityId, @NotNull AssetLockTransaction signedLockTransaction, @NotNull InstantSendLock instantLock) {
        Intrinsics.checkNotNullParameter((Object)identityId, (String)"identityId");
        Intrinsics.checkNotNullParameter((Object)signedLockTransaction, (String)"signedLockTransaction");
        Intrinsics.checkNotNullParameter((Object)instantLock, (String)"instantLock");
        Transaction transaction = (Transaction)signedLockTransaction;
        ECKey eCKey = signedLockTransaction.getAssetLockPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"signedLockTransaction.assetLockPublicKey");
        return this.topUp(identityId, 0L, transaction, instantLock, eCKey);
    }

    public final boolean topUp(@NotNull org.dashj.platform.dpp.identifier.Identifier identityId, long outputIndex, @NotNull Transaction transaction, @NotNull InstantSendLock instantLock, @NotNull ECKey assetLockPrivateKey) {
        Intrinsics.checkNotNullParameter((Object)identityId, (String)"identityId");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)instantLock, (String)"instantLock");
        Intrinsics.checkNotNullParameter((Object)assetLockPrivateKey, (String)"assetLockPrivateKey");
        try {
            InstantAssetLockProof assetLock = new InstantAssetLockProof(outputIndex, transaction, instantLock);
            IdentityTopUpTransition identityTopupTransition = this.platform.getDpp().getIdentity().createIdentityTopUpTransition(identityId, assetLock);
            identityTopupTransition.signByPrivateKey(assetLockPrivateKey);
            this.platform.broadcastStateTransition(identityTopupTransition);
            return true;
        }
        catch (Exception e) {
            log.info("topup failure: ", (Throwable)e);
            throw e;
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(Identities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Identities::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dashj/platform/sdk/platform/Identities$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

