/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.platform;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.dashj.platform.dapiclient.DapiClient;
import org.dashj.platform.dapiclient.SystemIds;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dpp.document.DataDocumentTransition;
import org.dashj.platform.dpp.document.Document;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.util.Entropy;
import org.dashj.platform.dpp.voting.Contenders;
import org.dashj.platform.dpp.voting.ContestedDocumentResourceVotePoll;
import org.dashj.platform.dpp.voting.ContestedResource;
import org.dashj.platform.dpp.voting.ContestedResources;
import org.dashj.platform.dpp.voting.ResourceVoteChoice;
import org.dashj.platform.dpp.voting.Vote;
import org.dashj.platform.dpp.voting.VotePoll;
import org.dashj.platform.sdk.PlatformValue;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.dashj.platform.sdk.platform.Documents;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 G2\u00020\u0001:\u0001GB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0019J\u0010\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\fJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010%\u001a\u00020\u0019J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010%\u001a\u00020\fJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010%\u001a\u00020&J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0#J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0#J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0#J\u001a\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010!\u001a\u00020\fH\u0002J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140#2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020&0#J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u00140#2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020&0#H\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u00102\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\fJ\u0016\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ(\u00107\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0019J*\u0010;\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00108\u001a\u0002092\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ2\u0010<\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00108\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010=\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\fJ\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020\u0019J\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020\fJ\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020&J:\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010B\u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010C\u001a\u00020\u001b2\b\b\u0002\u0010D\u001a\u00020E2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006H"}, d2={"Lorg/dashj/platform/sdk/platform/Names;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "broadcastVote", "Lorg/dashj/platform/dpp/voting/Vote;", "resourceVoteChoice", "Lorg/dashj/platform/dpp/voting/ResourceVoteChoice;", "normalizedLabel", "", "voterProTxHash", "Lorg/bitcoinj/core/Sha256Hash;", "identityPublicKey", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "signerCallback", "Lorg/dashj/platform/sdk/callbacks/Signer;", "createDomainDocument", "Lorg/dashj/platform/dpp/document/Document;", "identity", "Lorg/dashj/platform/dpp/identity/Identity;", "name", "preorderSaltBase", "", "isUniqueIdentity", "", "createPreorderDocument", "saltedDomainHash", "deserialize", "bytes", "get", "parentDomain", "getAllContestedNames", "", "getByOwnerId", "ownerId", "Lorg/dashj/platform/dpp/identifier/Identifier;", "getByUserIdAlias", "getContestedNames", "getCurrentVotePolls", "Lorg/dashj/platform/dpp/voting/VotePoll;", "getCurrentlyContestedNames", "getDocumentQuery", "Lorg/dashj/platform/dapiclient/model/DocumentQuery;", "getList", "userIds", "getListHelper", "getPreorder", "getVoteContenders", "Lorg/dashj/platform/dpp/voting/Contenders;", "getVoteFromMasternode", "", "proTxHash", "preorder", "identityHDPrivateKey", "Lorg/bitcoinj/core/ECKey;", "preOrderSaltRaw", "register", "registerName", "resolve", "resolveByRecord", "record", "value", "search", "text", "retrieveAll", "limit", "", "startAfter", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Names.kt\norg/dashj/platform/sdk/platform/Names\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,510:1\n1549#2:511\n1620#2,3:512\n1549#2:515\n1620#2,3:516\n1855#2,2:519\n*S KotlinDebug\n*F\n+ 1 Names.kt\norg/dashj/platform/sdk/platform/Names\n*L\n386#1:511\n386#1:512,3\n411#1:515\n411#1:516,3\n430#1:519,2\n*E\n"})
public final class Names {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String DEFAULT_PARENT_DOMAIN = "dash";
    @NotNull
    public static final String DPNS_DATA_CONTRACT = "dpns";
    @NotNull
    public static final String DOMAIN_DOCUMENT = "domain";
    @NotNull
    public static final String PREORDER_DOCUMENT = "preorder";
    @NotNull
    public static final String DPNS_DOMAIN_DOCUMENT = "dpns.domain";
    @NotNull
    public static final String DPNS_PREORDER_DOCUMENT = "dpns.preorder";
    @NotNull
    public static final String CONTESTED_INDEX = "parentNameAndLabel";
    @NotNull
    public static final String SALTEDDOMAINHASH_KEY = "saltedDomainHash";
    public static final int MAX_LIMIT = 100;

    public Names(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @Nullable
    public final Document register(@NotNull String name, @NotNull Identity identity, @NotNull ECKey identityHDPrivateKey, boolean isUniqueIdentity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)identityHDPrivateKey, (String)"identityHDPrivateKey");
        byte[] entropy = Entropy.generate();
        Document document = this.preorder(name, identity, identityHDPrivateKey, entropy);
        return document != null ? this.registerName(name, identity, identityHDPrivateKey, entropy, isUniqueIdentity) : null;
    }

    public static /* synthetic */ Document register$default(Names names, String string, Identity identity, ECKey eCKey, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return names.register(string, identity, eCKey, bl);
    }

    @Nullable
    public final Document preorder(@NotNull String name, @NotNull Identity identity, @NotNull ECKey identityHDPrivateKey, @NotNull byte[] preOrderSaltRaw) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)identityHDPrivateKey, (String)"identityHDPrivateKey");
        Intrinsics.checkNotNullParameter((Object)preOrderSaltRaw, (String)"preOrderSaltRaw");
        Pair<String, String> pair = Companion.normalizedNames(name);
        String normalizedParentDomainName = (String)pair.component1();
        String normalizedLabel = (String)pair.component2();
        String fullDomainName = normalizedLabel + '.' + normalizedParentDomainName;
        Sha256Hash saltedDomainHash = Companion.getSaltedDomainHash(preOrderSaltRaw, fullDomainName);
        if (this.platform.getApps().get(DPNS_DATA_CONTRACT) == null) {
            throw new Error("DPNS is required to register a new name.");
        }
        Document preorderDocument = this.createPreorderDocument(saltedDomainHash, identity);
        Object object = new Pair[]{TuplesKt.to((Object)"create", (Object)CollectionsKt.listOf((Object)preorderDocument))};
        HashMap map = MapsKt.hashMapOf((Pair[])object);
        try {
            object = preorderDocument;
        }
        catch (Exception x) {
            object = null;
        }
        return object;
    }

    @NotNull
    public final Document createPreorderDocument(@NotNull Sha256Hash saltedDomainHash, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)saltedDomainHash, (String)SALTEDDOMAINHASH_KEY);
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        HashMap map = new HashMap(1);
        ((Map)map).put(SALTEDDOMAINHASH_KEY, saltedDomainHash.getBytes());
        Document preorderDocument = this.platform.getDocuments().create(DPNS_PREORDER_DOCUMENT, identity.getId(), map);
        return preorderDocument;
    }

    @Nullable
    public final Document registerName(@NotNull String name, @NotNull Identity identity, @NotNull ECKey identityHDPrivateKey, @NotNull byte[] preorderSaltBase, boolean isUniqueIdentity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)identityHDPrivateKey, (String)"identityHDPrivateKey");
        Intrinsics.checkNotNullParameter((Object)preorderSaltBase, (String)"preorderSaltBase");
        Document domainDocument = this.createDomainDocument(identity, name, preorderSaltBase, isUniqueIdentity);
        log.info("domainDocument: " + domainDocument.toJSON());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"create", (Object)CollectionsKt.listOf((Object)domainDocument))};
        HashMap map = MapsKt.hashMapOf((Pair[])pairArray);
        return domainDocument;
    }

    public static /* synthetic */ Document registerName$default(Names names, String string, Identity identity, ECKey eCKey, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return names.registerName(string, identity, eCKey, byArray, bl);
    }

    @NotNull
    public final Document createDomainDocument(@NotNull Identity identity, @NotNull String name, @NotNull byte[] preorderSaltBase, boolean isUniqueIdentity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)preorderSaltBase, (String)"preorderSaltBase");
        String recordType = isUniqueIdentity ? "identity" : "dashAliasIdentityId";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)recordType, (Object)identity.getId())};
        HashMap records = MapsKt.hashMapOf((Pair[])pairArray);
        Pair<String, String> pair = new Pair<String, String>[]{TuplesKt.to((Object)"allowSubdomains", (Object)false)};
        HashMap subdomainRules = MapsKt.hashMapOf((Pair[])pair);
        pair = Companion.normalizedNames(name);
        String normalizedParentDomainName = (String)pair.component1();
        String normalizedLabel = (String)pair.component2();
        HashMap fields = new HashMap(7);
        ((Map)fields).put("label", Names.Companion.getLabel(name));
        ((Map)fields).put("normalizedLabel", Companion.normalizeString(normalizedLabel));
        ((Map)fields).put("normalizedParentDomainName", normalizedParentDomainName);
        ((Map)fields).put("parentDomainName", normalizedParentDomainName);
        ((Map)fields).put("preorderSalt", preorderSaltBase);
        ((Map)fields).put("records", records);
        ((Map)fields).put("subdomainRules", subdomainRules);
        Document domainDocument = this.platform.getDocuments().create(DPNS_DOMAIN_DOCUMENT, identity.getId(), fields);
        return domainDocument;
    }

    public static /* synthetic */ Document createDomainDocument$default(Names names, Identity identity, String string, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return names.createDomainDocument(identity, string, byArray, bl);
    }

    private final DocumentQuery getDocumentQuery(String name, String parentDomain) {
        return new DocumentQuery.Builder(null, null, 0, null, null, 31, null).where("normalizedParentDomainName", "==", parentDomain).where("normalizedLabel", "==", Companion.normalizeString(name)).build();
    }

    static /* synthetic */ DocumentQuery getDocumentQuery$default(Names names, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DEFAULT_PARENT_DOMAIN;
        }
        return names.getDocumentQuery(string, string2);
    }

    @Nullable
    public final Document get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.get(name, DEFAULT_PARENT_DOMAIN);
    }

    @Nullable
    public final Document resolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Pair<String, String> pair = Companion.normalizedNames(name);
        String domain = (String)pair.component1();
        String label = (String)pair.component2();
        return this.get(label, domain);
    }

    @Nullable
    public final Document get(@NotNull String name, @NotNull String parentDomain) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parentDomain, (String)"parentDomain");
        List<Document> documents = this.platform.getDocuments().get(DPNS_DOMAIN_DOCUMENT, this.getDocumentQuery(name, parentDomain));
        return !((Collection)documents).isEmpty() ? documents.get(0) : null;
    }

    @NotNull
    public final List<Document> search(@NotNull String text, @NotNull String parentDomain, boolean retrieveAll, int limit, @Nullable Identifier startAfter) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)parentDomain, (String)"parentDomain");
        DocumentQuery.Builder documentQuery = new DocumentQuery.Builder(null, null, 0, null, null, 31, null).where("normalizedParentDomainName", "==", parentDomain).where("normalizedLabel", "startsWith", Companion.normalizeString(text)).orderBy("normalizedLabel", true).limit(retrieveAll ? -1 : limit).startAfter(startAfter);
        return this.platform.getDocuments().getAll(DPNS_DOMAIN_DOCUMENT, documentQuery.build());
    }

    public static /* synthetic */ List search$default(Names names, String string, String string2, boolean bl, int n, Identifier identifier, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            identifier = null;
        }
        return names.search(string, string2, bl, n, identifier);
    }

    @NotNull
    public final List<Document> getByOwnerId(@NotNull byte[] ownerId) {
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        return this.getByOwnerId(Identifier.Companion.from(ownerId));
    }

    @NotNull
    public final List<Document> getByOwnerId(@NotNull String ownerId) {
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        return this.getByOwnerId(Identifier.Companion.from$default(Identifier.Companion, ownerId, null, 2, null));
    }

    @NotNull
    public final List<Document> getByOwnerId(@NotNull Identifier ownerId) {
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        return this.resolveByRecord("identity", ownerId);
    }

    @NotNull
    public final List<Document> getByUserIdAlias(@NotNull Identifier ownerId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        try {
            list = this.resolveByRecord("dashAliasIdentityId", ownerId);
        }
        catch (Exception e) {
            list = new ArrayList();
        }
        return list;
    }

    @NotNull
    public final List<Document> resolveByRecord(@NotNull String record, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.resolveByRecord(record, Identifier.Companion.from(value));
    }

    @NotNull
    public final List<Document> resolveByRecord(@NotNull String record, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.resolveByRecord(record, Identifier.Companion.from$default(Identifier.Companion, value, null, 2, null));
    }

    @NotNull
    public final List<Document> resolveByRecord(@NotNull String record, @NotNull Identifier value) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object[] objectArray = new Object[]{"records." + record, "==", value};
        DocumentQuery.Builder documentQuery = new DocumentQuery.Builder(null, null, 0, null, null, 31, null).where(CollectionsKt.listOf((Object[])objectArray));
        List<Document> results = this.platform.getDocuments().get(DPNS_DOMAIN_DOCUMENT, documentQuery.build());
        return results;
    }

    @NotNull
    public final List<Document> getList(@NotNull List<Identifier> userIds) {
        int subsetSize;
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        ArrayList documents = new ArrayList();
        for (int startAt = 0; startAt < userIds.size(); startAt += subsetSize) {
            subsetSize = startAt + 100 > userIds.size() ? userIds.size() - startAt : 100;
            List<Identifier> userIdSubSet = userIds.subList(startAt, startAt + subsetSize);
            List<Document> documentSubset = this.getListHelper(userIdSubSet);
            documents.addAll(documentSubset);
        }
        return documents;
    }

    private final List<Document> getListHelper(List<Identifier> userIds) {
        DocumentQuery.Builder documentQuery = new DocumentQuery.Builder(null, null, 0, null, null, 31, null);
        documentQuery.whereIn("records.identity", userIds).orderBy("records.identity", true);
        List<Document> documents = this.platform.getDocuments().get(DPNS_DOMAIN_DOCUMENT, documentQuery.build());
        return documents;
    }

    @NotNull
    public final Contenders getVoteContenders(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DapiClient dapiClient = this.platform.getClient();
        ClientAppDefinition clientAppDefinition = this.platform.getApps().get(DPNS_DATA_CONTRACT);
        Intrinsics.checkNotNull((Object)clientAppDefinition);
        Object[] objectArray = new String[]{DEFAULT_PARENT_DOMAIN, name};
        return dapiClient.getVoteContenders(clientAppDefinition.getContractId(), DOMAIN_DOCUMENT, CONTESTED_INDEX, CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getContestedNames() {
        List list;
        DapiClient dapiClient = this.platform.getClient();
        ClientAppDefinition clientAppDefinition = this.platform.getApps().get(DPNS_DATA_CONTRACT);
        Intrinsics.checkNotNull((Object)clientAppDefinition);
        ContestedResources resources = DapiClient.getContestedResources$default(dapiClient, clientAppDefinition.getContractId(), DOMAIN_DOCUMENT, 0, null, false, 28, null);
        if (!((Collection)resources.getList()).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = resources.getList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ContestedResource contestedResource = (ContestedResource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PlatformValue.Tag tag = it.getValue().getTag();
                if ((tag == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) != 1) {
                    throw new IllegalStateException((it.getValue() + " is not a PlatformValue.Text").toString());
                }
                collection.add(it.getValue().getText());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllContestedNames() {
        int count = 0;
        PlatformValue startAt = null;
        boolean startAtInclude = false;
        ArrayList results = new ArrayList();
        do {
            List list;
            DapiClient dapiClient = this.platform.getClient();
            ClientAppDefinition clientAppDefinition = this.platform.getApps().get(DPNS_DATA_CONTRACT);
            Intrinsics.checkNotNull((Object)clientAppDefinition);
            ContestedResources resources = dapiClient.getContestedResources(clientAppDefinition.getContractId(), DOMAIN_DOCUMENT, 100, startAt, startAtInclude);
            if (!((Collection)resources.getList()).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = resources.getList();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ContestedResource contestedResource = (ContestedResource)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    PlatformValue.Tag tag = it.getValue().getTag();
                    if ((tag == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) != 1) {
                        throw new IllegalStateException((it.getValue() + " is not a PlatformValue.Text").toString());
                    }
                    collection.add(it.getValue().getText());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List nextList = list;
            count = nextList.size();
            results.addAll(nextList);
            ContestedResource contestedResource = (ContestedResource)CollectionsKt.lastOrNull(resources.getList());
            Object object = startAt = contestedResource != null ? contestedResource.getValue() : null;
        } while (count == 100);
        return results;
    }

    @NotNull
    public final List<String> getCurrentlyContestedNames() {
        ArrayList<String> resources = new ArrayList<String>();
        Iterable $this$forEach$iv = this.getCurrentVotePolls();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VotePoll it = (VotePoll)element$iv;
            boolean bl = false;
            if (!(it instanceof ContestedDocumentResourceVotePoll) || !Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)it).getDataContractId(), (Object)SystemIds.INSTANCE.getDpnsDataContractId()) || !Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)it).getIndexName(), (Object)CONTESTED_INDEX) || !Intrinsics.areEqual((Object)((ContestedDocumentResourceVotePoll)it).getIndexValues().get(0), (Object)DEFAULT_PARENT_DOMAIN)) continue;
            String normalizedLabelValue = ((ContestedDocumentResourceVotePoll)it).getIndexValues().get(1);
            resources.add(normalizedLabelValue);
        }
        return resources;
    }

    @NotNull
    public final Document deserialize(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Documents documents = this.platform.getDocuments();
        ClientAppDefinition clientAppDefinition = this.platform.getApps().get(DPNS_DATA_CONTRACT);
        Intrinsics.checkNotNull((Object)clientAppDefinition);
        return documents.deserialize(bytes, clientAppDefinition.getContractId(), DOMAIN_DOCUMENT);
    }

    @NotNull
    public final Vote broadcastVote(@NotNull ResourceVoteChoice resourceVoteChoice, @NotNull String normalizedLabel, @NotNull Sha256Hash voterProTxHash, @NotNull IdentityPublicKey identityPublicKey, @NotNull Signer signerCallback) {
        Intrinsics.checkNotNullParameter((Object)resourceVoteChoice, (String)"resourceVoteChoice");
        Intrinsics.checkNotNullParameter((Object)normalizedLabel, (String)"normalizedLabel");
        Intrinsics.checkNotNullParameter((Object)voterProTxHash, (String)"voterProTxHash");
        Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
        Intrinsics.checkNotNullParameter((Object)signerCallback, (String)"signerCallback");
        Object[] objectArray = new String[]{DEFAULT_PARENT_DOMAIN, Companion.normalizeString(normalizedLabel)};
        return this.platform.getDocuments().broadcastVote(resourceVoteChoice, SystemIds.INSTANCE.getDpnsDataContractId(), DOMAIN_DOCUMENT, CONTESTED_INDEX, CollectionsKt.listOf((Object[])objectArray), voterProTxHash, identityPublicKey, signerCallback);
    }

    @Nullable
    public final Document getPreorder(@NotNull byte[] saltedDomainHash) {
        Intrinsics.checkNotNullParameter((Object)saltedDomainHash, (String)SALTEDDOMAINHASH_KEY);
        List<Document> documents = this.platform.getDocuments().get(DPNS_PREORDER_DOCUMENT, DocumentQuery.Companion.builder().where(SALTEDDOMAINHASH_KEY, "==", saltedDomainHash).build());
        return !((Collection)documents).isEmpty() ? documents.get(0) : null;
    }

    @NotNull
    public final List<VotePoll> getCurrentVotePolls() {
        long currentTime = System.currentTimeMillis();
        return Documents.getAllVotePolls$default(this.platform.getDocuments(), SystemIds.INSTANCE.getDpnsDataContractId(), DOMAIN_DOCUMENT, currentTime, true, currentTime + Documents.Companion.votingPeriod(this.platform.getParams()), false, false, 96, null);
    }

    public final void getVoteFromMasternode(@NotNull Sha256Hash proTxHash, @NotNull String normalizedLabel) {
        Intrinsics.checkNotNullParameter((Object)proTxHash, (String)"proTxHash");
        Intrinsics.checkNotNullParameter((Object)normalizedLabel, (String)"normalizedLabel");
        Documents documents = this.platform.getDocuments();
        ClientAppDefinition clientAppDefinition = this.platform.getApps().get(DPNS_DATA_CONTRACT);
        Intrinsics.checkNotNull((Object)clientAppDefinition);
        Object[] objectArray = new String[]{DEFAULT_PARENT_DOMAIN, normalizedLabel};
        documents.getVoteFromMasternode(proTxHash, clientAppDefinition.getContractId(), DOMAIN_DOCUMENT, CONTESTED_INDEX, CollectionsKt.listOf((Object[])objectArray));
    }

    static {
        Logger logger = LoggerFactory.getLogger(Names.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Names::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010\u0014\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/dashj/platform/sdk/platform/Names$Companion;", "", "()V", "CONTESTED_INDEX", "", "DEFAULT_PARENT_DOMAIN", "DOMAIN_DOCUMENT", "DPNS_DATA_CONTRACT", "DPNS_DOMAIN_DOCUMENT", "DPNS_PREORDER_DOCUMENT", "MAX_LIMIT", "", "PREORDER_DOCUMENT", "SALTEDDOMAINHASH_KEY", "log", "Lorg/slf4j/Logger;", "getFullName", "label", "parentDomain", "getLabel", "name", "getSaltedDomainHash", "Lorg/bitcoinj/core/Sha256Hash;", "preOrderSaltRaw", "", "fullName", "getSaltedDomainHashBytes", "isUniqueIdentity", "", "dataDocumentTransition", "Lorg/dashj/platform/dpp/document/DataDocumentTransition;", "domainDocument", "Lorg/dashj/platform/dpp/document/Document;", "isUsernameContestable", "username", "normalizeString", "text", "normalizedNames", "Lkotlin/Pair;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isUniqueIdentity(@NotNull Document domainDocument) {
            Intrinsics.checkNotNullParameter((Object)domainDocument, (String)"domainDocument");
            Object object = domainDocument.getData().get("records");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map records = (Map)object;
            return records.containsKey("identity");
        }

        public final boolean isUniqueIdentity(@NotNull DataDocumentTransition dataDocumentTransition) {
            Intrinsics.checkNotNullParameter((Object)dataDocumentTransition, (String)"dataDocumentTransition");
            Object object = dataDocumentTransition.getData().get("records");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map records = (Map)object;
            return records.containsKey("identity");
        }

        @NotNull
        public final Pair<String, String> normalizedNames(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int nameSlice = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
            String normalizedParentDomainName = nameSlice == -1 ? Names.DEFAULT_PARENT_DOMAIN : StringsKt.slice((String)name, (IntRange)RangesKt.until((int)(nameSlice + 1), (int)name.length()));
            String label = nameSlice == -1 ? name : StringsKt.slice((String)name, (IntRange)RangesKt.until((int)0, (int)nameSlice));
            String normalizedLabel = this.normalizeString(label);
            return new Pair((Object)normalizedParentDomainName, (Object)normalizedLabel);
        }

        @NotNull
        public final String normalizeString(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String string = text.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (char)'o', (char)'0', (boolean)false, (int)4, null), (char)'i', (char)'1', (boolean)false, (int)4, null), (char)'l', (char)'1', (boolean)false, (int)4, null);
        }

        private final String getLabel(String name) {
            int nameSlice = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
            return nameSlice == -1 ? name : StringsKt.slice((String)name, (IntRange)new IntRange(0, nameSlice));
        }

        @NotNull
        public final String getFullName(@NotNull String label, @NotNull String parentDomain) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)parentDomain, (String)"parentDomain");
            String normalizedLabel = this.normalizeString(label);
            String normalizedParentDomainName = this.normalizeString(parentDomain);
            return normalizedLabel + '.' + normalizedParentDomainName;
        }

        @NotNull
        public final byte[] getSaltedDomainHashBytes(@NotNull byte[] preOrderSaltRaw, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)preOrderSaltRaw, (String)"preOrderSaltRaw");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            byte[] byArray = this.getSaltedDomainHash(preOrderSaltRaw, name).getBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSaltedDomainHash(preOrderSaltRaw, name).bytes");
            return byArray;
        }

        @NotNull
        public final Sha256Hash getSaltedDomainHash(@NotNull byte[] preOrderSaltRaw, @NotNull String fullName) {
            Intrinsics.checkNotNullParameter((Object)preOrderSaltRaw, (String)"preOrderSaltRaw");
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            ByteArrayOutputStream baos = new ByteArrayOutputStream(preOrderSaltRaw.length + fullName.length());
            baos.write(preOrderSaltRaw);
            String string = this.normalizeString(fullName);
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            baos.write(byArray);
            Sha256Hash sha256Hash = Sha256Hash.twiceOf((byte[])baos.toByteArray());
            Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"twiceOf(baos.toByteArray())");
            return sha256Hash;
        }

        public final boolean isUsernameContestable(@NotNull String username) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Regex regex = new Regex("^[a-zA-Z01-]{3,19}$");
            return regex.matches((CharSequence)username);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlatformValue.Tag.values().length];
            try {
                nArray[PlatformValue.Tag.Text.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

