/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.platform;

import com.google.common.base.Stopwatch;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.listeners.NewBestBlockListener;
import org.bitcoinj.evolution.SimplifiedMasternodeListManager;
import org.dashj.platform.dapiclient.DapiClient;
import org.dashj.platform.dapiclient.MaxRetriesReachedException;
import org.dashj.platform.dapiclient.NoAvailableAddressesForRetryException;
import org.dashj.platform.dapiclient.SystemIds;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.statetransition.StateTransitionIdentitySigned;
import org.dashj.platform.dpp.util.Entropy;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.dashj.platform.sdk.platform.Contracts;
import org.dashj.platform.sdk.platform.Documents;
import org.dashj.platform.sdk.platform.Identities;
import org.dashj.platform.sdk.platform.MockPlatformStateRepository;
import org.dashj.platform.sdk.platform.Names;
import org.dashj.platform.sdk.platform.PlatformStateRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 b2\u00020\u0001:\u0001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\n0CJ\u000e\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020FJ(\u0010D\u001a\u00020A2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020MJ\u0010\u0010N\u001a\u00020?2\b\b\u0002\u0010O\u001a\u00020?J\f\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0CJ\u001a\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0S2\u0006\u0010T\u001a\u00020\nJ\u001c\u0010U\u001a\u0010\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020\n\u0018\u00010S2\u0006\u0010T\u001a\u00020\nJ\u001a\u0010V\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010W0CH\u0002J\u000e\u0010X\u001a\u00020?2\u0006\u0010Y\u001a\u00020\nJ\u0006\u0010Z\u001a\u00020?J\u0010\u0010[\u001a\u00020A2\b\u0010\\\u001a\u0004\u0018\u00010]J\u000e\u0010^\u001a\u00020A2\u0006\u0010_\u001a\u00020`J\u0006\u0010a\u001a\u00020AR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/dashj/platform/sdk/platform/Platform;", "", "params", "Lorg/bitcoinj/core/NetworkParameters;", "(Lorg/bitcoinj/core/NetworkParameters;)V", "_blockHeight", "", "_coreBlockHeight", "apps", "Ljava/util/HashMap;", "", "Lorg/dashj/platform/sdk/client/ClientAppDefinition;", "Lkotlin/collections/HashMap;", "getApps", "()Ljava/util/HashMap;", "blockHeight", "getBlockHeight", "()J", "client", "Lorg/dashj/platform/dapiclient/DapiClient;", "getClient", "()Lorg/dashj/platform/dapiclient/DapiClient;", "setClient", "(Lorg/dashj/platform/dapiclient/DapiClient;)V", "contracts", "Lorg/dashj/platform/sdk/platform/Contracts;", "getContracts", "()Lorg/dashj/platform/sdk/platform/Contracts;", "coreBlockHeight", "getCoreBlockHeight", "documents", "Lorg/dashj/platform/sdk/platform/Documents;", "getDocuments", "()Lorg/dashj/platform/sdk/platform/Documents;", "dpp", "Lorg/dashj/platform/dpp/DashPlatformProtocol;", "getDpp", "()Lorg/dashj/platform/dpp/DashPlatformProtocol;", "identities", "Lorg/dashj/platform/sdk/platform/Identities;", "getIdentities", "()Lorg/dashj/platform/sdk/platform/Identities;", "names", "Lorg/dashj/platform/sdk/platform/Names;", "getNames", "()Lorg/dashj/platform/sdk/platform/Names;", "setNames", "(Lorg/dashj/platform/sdk/platform/Names;)V", "newBestBlockListener", "Lorg/bitcoinj/core/listeners/NewBestBlockListener;", "getParams", "()Lorg/bitcoinj/core/NetworkParameters;", "rustSdk", "Lorg/dashj/platform/sdk/SWIGTYPE_p_DashSdk;", "getRustSdk", "()Lorg/dashj/platform/sdk/SWIGTYPE_p_DashSdk;", "stateRepository", "Lorg/dashj/platform/sdk/platform/PlatformStateRepository;", "getStateRepository", "()Lorg/dashj/platform/sdk/platform/PlatformStateRepository;", "setStateRepository", "(Lorg/dashj/platform/sdk/platform/PlatformStateRepository;)V", "useWhiteList", "", "appendWhiteList", "", "banList", "", "broadcastStateTransition", "signedStateTransition", "Lorg/dashj/platform/dpp/statetransition/StateTransitionIdentitySigned;", "stateTransition", "identity", "Lorg/dashj/platform/dpp/identity/Identity;", "privateKey", "Lorg/bitcoinj/core/ECKey;", "keyIndex", "", "check", "fullTest", "getAppList", "Lorg/dashj/platform/dpp/identifier/Identifier;", "getAppnameAndType", "Lkotlin/Pair;", "typeLocator", "getDataContractIdAndType", "getMnList", "", "hasApp", "appName", "isTestNet", "setBlockChain", "blockChain", "Lorg/bitcoinj/core/AbstractBlockChain;", "setMasternodeListManager", "masternodeListManager", "Lorg/bitcoinj/evolution/SimplifiedMasternodeListManager;", "useValidNodes", "Companion"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\norg/dashj/platform/sdk/platform/Platform\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n125#2:258\n152#2,3:259\n1#3:262\n1855#4,2:263\n*S KotlinDebug\n*F\n+ 1 Platform.kt\norg/dashj/platform/sdk/platform/Platform\n*L\n97#1:258\n97#1:259,3\n158#1:263,2\n*E\n"})
public final class Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkParameters params;
    private long _coreBlockHeight;
    private long _blockHeight;
    @NotNull
    private PlatformStateRepository stateRepository;
    @NotNull
    private final DashPlatformProtocol dpp;
    @NotNull
    private final HashMap<String, ClientAppDefinition> apps;
    @NotNull
    private final Contracts contracts;
    @NotNull
    private final Documents documents;
    @NotNull
    private final Identities identities;
    @NotNull
    private Names names;
    public DapiClient client;
    private boolean useWhiteList;
    @NotNull
    private final NewBestBlockListener newBestBlockListener;
    @NotNull
    private static final Logger log;
    private static final boolean MOCK_DAPI = false;

    public Platform(@NotNull NetworkParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.params = params;
        this.stateRepository = Companion.mockDAPI() ? (PlatformStateRepository)new MockPlatformStateRepository(this) : new PlatformStateRepository(this);
        this.dpp = new DashPlatformProtocol(this.stateRepository, this.params);
        this.apps = new HashMap();
        this.contracts = new Contracts(this);
        this.documents = new Documents(this);
        this.identities = new Identities(this);
        this.names = new Names(this);
        ((Map)this.apps).put("dpns", new ClientAppDefinition(SystemIds.INSTANCE.getDpnsDataContractId(), null, 2, null));
        ((Map)this.apps).put("dashpay", new ClientAppDefinition(SystemIds.INSTANCE.getDashpayDataContractId(), null, 2, null));
        String string = this.params.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.id");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"test", (boolean)false, (int)2, null)) {
            this.useWhiteList = true;
            ((Map)this.apps).put("dashwallet", new ClientAppDefinition("Bhptm3yBDhLkRNt7ofjpwaBHhMUKjDrQoPufKzQaxmpK", null, 2, null));
        } else {
            String string2 = this.params.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"params.id");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"bintang", (boolean)false, (int)2, null)) {
                ((Map)this.apps).put("dashwallet", new ClientAppDefinition("Fds5DDfXoLwpUZ71AAVYZP1uod8S7Ze2bR28JExBvZKR", null, 2, null));
            } else {
                String string3 = this.params.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"params.id");
                if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"production", (boolean)false, (int)2, null)) {
                    ((Map)this.apps).put("dashwallet", new ClientAppDefinition("EVKMFboB3QBUa9Jo7PP5bsLyohzUz8zvw5c2gJs1SfcX", null, 2, null));
                }
            }
        }
        System.loadLibrary("sdklib");
        String[] stringArray = this.params.getDefaultHPMasternodeList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"params.defaultHPMasternodeList");
        this.setClient(new DapiClient(ArraysKt.toList((Object[])stringArray), this.dpp, true, this.isTestNet(), 0L, 0, 0, 0, 240, null));
        this.newBestBlockListener = arg_0 -> Platform.newBestBlockListener$lambda$3(this, arg_0);
    }

    @NotNull
    public final NetworkParameters getParams() {
        return this.params;
    }

    public final long getCoreBlockHeight() {
        return this._coreBlockHeight;
    }

    public final long getBlockHeight() {
        return this._blockHeight;
    }

    @NotNull
    public final PlatformStateRepository getStateRepository() {
        return this.stateRepository;
    }

    public final void setStateRepository(@NotNull PlatformStateRepository platformStateRepository) {
        Intrinsics.checkNotNullParameter((Object)platformStateRepository, (String)"<set-?>");
        this.stateRepository = platformStateRepository;
    }

    @NotNull
    public final SWIGTYPE_p_DashSdk getRustSdk() {
        return this.getClient().getRustSdk();
    }

    @NotNull
    public final DashPlatformProtocol getDpp() {
        return this.dpp;
    }

    @NotNull
    public final HashMap<String, ClientAppDefinition> getApps() {
        return this.apps;
    }

    @NotNull
    public final Contracts getContracts() {
        return this.contracts;
    }

    @NotNull
    public final Documents getDocuments() {
        return this.documents;
    }

    @NotNull
    public final Identities getIdentities() {
        return this.identities;
    }

    @NotNull
    public final Names getNames() {
        return this.names;
    }

    public final void setNames(@NotNull Names names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"<set-?>");
        this.names = names;
    }

    @NotNull
    public final DapiClient getClient() {
        DapiClient dapiClient = this.client;
        if (dapiClient != null) {
            return dapiClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        return null;
    }

    public final void setClient(@NotNull DapiClient dapiClient) {
        Intrinsics.checkNotNullParameter((Object)dapiClient, (String)"<set-?>");
        this.client = dapiClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Identifier> getAppList() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.apps;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ClientAppDefinition)it.getValue()).getContractId());
        }
        return (List)destination$iv$iv;
    }

    public final void broadcastStateTransition(@NotNull StateTransitionIdentitySigned stateTransition, @NotNull Identity identity, @NotNull ECKey privateKey, int keyIndex) {
        Intrinsics.checkNotNullParameter((Object)stateTransition, (String)"stateTransition");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        IdentityPublicKey identityPublicKey = identity.getPublicKeyById(keyIndex);
        Intrinsics.checkNotNull((Object)identityPublicKey);
        String string = privateKey.getPrivateKeyAsHex();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"privateKey.privateKeyAsHex");
        stateTransition.sign(identityPublicKey, string);
        this.broadcastStateTransition(stateTransition);
    }

    public static /* synthetic */ void broadcastStateTransition$default(Platform platform, StateTransitionIdentitySigned stateTransitionIdentitySigned, Identity identity, ECKey eCKey, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 1;
        }
        platform.broadcastStateTransition(stateTransitionIdentitySigned, identity, eCKey, n);
    }

    public final void broadcastStateTransition(@NotNull StateTransitionIdentitySigned signedStateTransition) {
        Intrinsics.checkNotNullParameter((Object)signedStateTransition, (String)"signedStateTransition");
        this.stateRepository.broadcastStateTransition(signedStateTransition);
    }

    public final boolean hasApp(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        return this.apps.containsKey(appName);
    }

    @Nullable
    public final Pair<Identifier, String> getDataContractIdAndType(@NotNull String typeLocator) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)typeLocator, (String)"typeLocator");
        Pair<String, String> pair2 = this.getAppnameAndType(typeLocator);
        String dataContractName = (String)pair2.component1();
        String documentType = (String)pair2.component2();
        ClientAppDefinition clientAppDefinition = this.apps.get(dataContractName);
        if (clientAppDefinition != null) {
            ClientAppDefinition it = clientAppDefinition;
            boolean bl = false;
            pair = new Pair((Object)it.getContractId(), (Object)documentType);
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public final Pair<String, String> getAppnameAndType(@NotNull String typeLocator) {
        Intrinsics.checkNotNullParameter((Object)typeLocator, (String)"typeLocator");
        Set<String> set = this.apps.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"apps.keys");
        Set<String> appNames = set;
        String appName = null;
        String fieldType = null;
        if (StringsKt.contains$default((CharSequence)typeLocator, (char)'.', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'.'};
            List split = StringsKt.split$default((CharSequence)typeLocator, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            appName = (String)split.get(0);
            fieldType = (String)split.get(1);
        } else {
            appName = (String)CollectionsKt.first((Iterable)appNames);
            fieldType = typeLocator;
        }
        return new Pair((Object)appName, (Object)fieldType);
    }

    public final void setMasternodeListManager(@NotNull SimplifiedMasternodeListManager masternodeListManager) {
        Intrinsics.checkNotNullParameter((Object)masternodeListManager, (String)"masternodeListManager");
        DapiClient dapiClient = this.getClient();
        String[] stringArray = this.params.getDefaultHPMasternodeList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"params.defaultHPMasternodeList");
        dapiClient.setSimplifiedMasternodeListManager(masternodeListManager, ArraysKt.toList((Object[])stringArray));
        String[] stringArray2 = this.params.getDefaultHPMasternodeList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"params.defaultHPMasternodeList");
        this.appendWhiteList(ArraysKt.toList((Object[])stringArray2));
    }

    public final void appendWhiteList(@NotNull List<String> banList) {
        Intrinsics.checkNotNullParameter(banList, (String)"banList");
        Iterable $this$forEach$iv = banList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.getClient().getDapiAddressListProvider().addAcceptedAddress(it);
        }
    }

    public final void useValidNodes() {
        this.setClient(new DapiClient(CollectionsKt.emptyList(), this.dpp, false, !Intrinsics.areEqual((Object)this.params.getId(), (Object)"org.darkcoin.production"), 0L, 0, 0, 0, 240, null));
    }

    private final List<Map<String, Object>> getMnList() {
        boolean success = false;
        while (true) {
            try {
                Map<String, Object> mnListDiff;
                String baseBlockHash = this.getClient().getBlockHash(0);
                String blockHash = this.getClient().getBestBlockHash();
                DapiClient dapiClient = this.getClient();
                String string = baseBlockHash;
                Intrinsics.checkNotNull((Object)string);
                String string2 = blockHash;
                Intrinsics.checkNotNull((Object)string2);
                Map<String, Object> map = mnListDiff = dapiClient.getMnListDiff(string, string2);
                Intrinsics.checkNotNull(map);
                Object object = map.get("mnList");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
                return (List)object;
            }
            catch (Exception e) {
                log.warn("Error: " + e);
                continue;
            }
            break;
        }
    }

    public final boolean check(boolean fullTest) {
        boolean bl;
        try {
            boolean bl2;
            Stopwatch watch = Stopwatch.createStarted();
            if (fullTest) {
                ClientAppDefinition clientAppDefinition = this.apps.get("dpns");
                Intrinsics.checkNotNull((Object)clientAppDefinition);
                if (this.contracts.get(clientAppDefinition.getContractId()) == null) {
                    return false;
                }
            }
            ClientAppDefinition clientAppDefinition = this.apps.get("dpns");
            Intrinsics.checkNotNull((Object)clientAppDefinition);
            this.documents.get(clientAppDefinition.getContractId(), "domain", DocumentQuery.Companion.builder().limit(5).build());
            if (fullTest) {
                this.identities.get(Identifier.Companion.from(Entropy.generate()));
            }
            try {
                log.info("platform check: " + watch);
                bl2 = true;
            }
            catch (StatusRuntimeException e) {
                log.info("platform check: " + watch);
                bl2 = e.getStatus().getCode() == Status.Code.INTERNAL;
            }
            catch (MaxRetriesReachedException e) {
                boolean bl3;
                log.info("platform check: " + watch);
                if (e.getCause() instanceof StatusRuntimeException) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type io.grpc.StatusRuntimeException");
                    bl3 = ((StatusRuntimeException)throwable).getStatus().getCode() == Status.Code.INTERNAL;
                } else {
                    log.warn("platform check: " + e);
                    bl3 = false;
                }
                bl2 = bl3;
            }
            catch (NoAvailableAddressesForRetryException e) {
                log.warn("platform check: " + e);
                bl2 = false;
            }
            bl = bl2;
        }
        catch (StatusRuntimeException e) {
            log.warn("platform check: " + (Object)((Object)e));
            bl = false;
        }
        catch (MaxRetriesReachedException e) {
            log.warn("platform check: max retries: " + e);
            bl = false;
        }
        catch (NoAvailableAddressesForRetryException e) {
            log.warn("platform check: no available addresses: " + e);
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean check$default(Platform platform, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return platform.check(bl);
    }

    public final boolean isTestNet() {
        return !Intrinsics.areEqual((Object)this.params.getId(), (Object)"org.darkcoin.production");
    }

    public final void setBlockChain(@Nullable AbstractBlockChain blockChain) {
        if (blockChain != null) {
            blockChain.addNewBestBlockListener(this.newBestBlockListener);
            this._coreBlockHeight = blockChain.getBestChainHeight();
        }
    }

    private static final void newBestBlockListener$lambda$3(Platform this$0, StoredBlock block) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (block != null) {
            this$0._coreBlockHeight = block.getHeight();
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(Platform.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Platform::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/dashj/platform/sdk/platform/Platform$Companion;", "", "()V", "MOCK_DAPI", "", "log", "Lorg/slf4j/Logger;", "mockDAPI", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean mockDAPI() {
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

