/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.sdk.platform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.quorums.InstantSendLock;
import org.dashj.platform.dapiclient.DapiClient;
import org.dashj.platform.dapiclient.errors.NotFoundException;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.Factory;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.document.Document;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.statetransition.StateTransitionIdentitySigned;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.client.ClientAppDefinition;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 U2\u00020\u0001:\u0001UB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007J\u0016\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011J\u0010\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020%J\u0012\u0010/\u001a\u0004\u0018\u00010\b2\u0006\u00100\u001a\u00020\u0007H\u0016J&\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00142\u0006\u00100\u001a\u00020\u0007H\u0016J\u0010\u00108\u001a\u0004\u0018\u00010\u00142\u0006\u00109\u001a\u00020\u0011J\b\u0010:\u001a\u00020\u0011H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00100\u001a\u000204H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0011H\u0016J\u0010\u0010@\u001a\u00020%2\u0006\u0010?\u001a\u00020\u0011H\u0016J \u0010A\u001a\u00020%2\u0006\u00102\u001a\u00020\u00072\u0006\u0010B\u001a\u0002042\u0006\u00100\u001a\u00020\u0007H\u0016J\u000e\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020\u0011J\u0010\u0010C\u001a\u00020%2\u0006\u0010E\u001a\u00020\bH\u0016J\u000e\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020\u0011J\u0010\u0010F\u001a\u00020%2\u0006\u0010H\u001a\u00020\rH\u0016J\u000e\u0010I\u001a\u00020%2\u0006\u0010J\u001a\u00020\u0011J\u0010\u0010I\u001a\u00020%2\u0006\u0010K\u001a\u00020\u0014H\u0016J\u001e\u0010L\u001a\u00020%2\u0006\u0010K\u001a\u00020\u00072\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0QJ\u0010\u0010R\u001a\u00020>2\u0006\u0010S\u001a\u00020TH\u0016R0\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR0\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR<\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR0\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0014`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0017j\b\u0012\u0004\u0012\u00020\u0011`\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR0\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u0006j\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR$\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0017j\b\u0012\u0004\u0012\u00020\u0007`\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR$\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0017j\b\u0012\u0004\u0012\u00020\u0007`\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001a\u00a8\u0006V"}, d2={"Lorg/dashj/platform/sdk/platform/PlatformStateRepository;", "Lorg/dashj/platform/dpp/StateRepository;", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "contractsMap", "Ljava/util/HashMap;", "Lorg/dashj/platform/dpp/identifier/Identifier;", "Lorg/dashj/platform/dpp/contract/DataContract;", "Lkotlin/collections/HashMap;", "getContractsMap", "()Ljava/util/HashMap;", "documentsMap", "Lorg/dashj/platform/dpp/document/Document;", "getDocumentsMap", "identityHashesMap", "", "", "getIdentityHashesMap", "identityMap", "Lorg/dashj/platform/dpp/identity/Identity;", "getIdentityMap", "outPointBufferSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getOutPointBufferSet", "()Ljava/util/HashSet;", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "preorderSalts", "Lorg/bitcoinj/core/Sha256Hash;", "getPreorderSalts", "validDocuments", "getValidDocuments", "validIdentities", "getValidIdentities", "addValidDocument", "", "identityId", "addValidIdentity", "addValidPreorderSalt", "preorderSalt", "saltedDomainHash", "broadcastStateTransition", "signedStateTransition", "Lorg/dashj/platform/dpp/statetransition/StateTransitionIdentitySigned;", "dump", "fetchDataContract", "id", "fetchDocuments", "contractId", "documentType", "", "where", "", "fetchIdentity", "fetchIdentityFromPubKeyHash", "pubKeyHash", "fetchLatestPlatformBlockHeader", "fetchTransaction", "Lorg/bitcoinj/core/Transaction;", "isAssetLockTransactionOutPointAlreadyUsed", "", "outPointBuffer", "markAssetLockTransactionOutPointAsUsed", "removeDocument", "type", "storeDataContract", "dataContractBytes", "dataContract", "storeDocument", "documentBytes", "document", "storeIdentity", "identityBytes", "identity", "storeIdentityPublicKeyHashes", "publicKeyHashes", "validDocumentIdList", "validIdentityIdList", "validPreorderSalts", "", "verifyInstantLock", "instantLock", "Lorg/bitcoinj/quorums/InstantSendLock;", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nPlatformStateRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformStateRepository.kt\norg/dashj/platform/sdk/platform/PlatformStateRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,242:1\n1#2:243\n1549#3:244\n1620#3,3:245\n1747#3,3:251\n515#4:248\n500#4,2:249\n502#4,4:254\n215#5,2:258\n215#5,2:260\n215#5,2:262\n*S KotlinDebug\n*F\n+ 1 PlatformStateRepository.kt\norg/dashj/platform/sdk/platform/PlatformStateRepository\n*L\n116#1:244\n116#1:245,3\n158#1:251,3\n157#1:248\n157#1:249,2\n157#1:254,4\n200#1:258,2\n204#1:260,2\n208#1:262,2\n*E\n"})
public class PlatformStateRepository
implements StateRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    private final HashMap<Identifier, Identity> identityMap;
    @NotNull
    private final HashSet<Identifier> validIdentities;
    @NotNull
    private final HashMap<Identifier, Document> documentsMap;
    @NotNull
    private final HashSet<Identifier> validDocuments;
    @NotNull
    private final HashMap<Identifier, List<byte[]>> identityHashesMap;
    @NotNull
    private final HashMap<Identifier, DataContract> contractsMap;
    @NotNull
    private final HashSet<byte[]> outPointBufferSet;
    @NotNull
    private final HashMap<Sha256Hash, Sha256Hash> preorderSalts;
    @NotNull
    private static final Logger log;

    public PlatformStateRepository(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        this.identityMap = new HashMap();
        this.validIdentities = new HashSet();
        this.documentsMap = new HashMap();
        this.validDocuments = new HashSet();
        this.identityHashesMap = new HashMap();
        this.contractsMap = new HashMap();
        this.outPointBufferSet = new HashSet();
        this.preorderSalts = new HashMap();
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    protected final HashMap<Identifier, Identity> getIdentityMap() {
        return this.identityMap;
    }

    @NotNull
    protected final HashSet<Identifier> getValidIdentities() {
        return this.validIdentities;
    }

    @NotNull
    protected final HashMap<Identifier, Document> getDocumentsMap() {
        return this.documentsMap;
    }

    @NotNull
    protected final HashSet<Identifier> getValidDocuments() {
        return this.validDocuments;
    }

    @NotNull
    protected final HashMap<Identifier, List<byte[]>> getIdentityHashesMap() {
        return this.identityHashesMap;
    }

    @NotNull
    protected final HashMap<Identifier, DataContract> getContractsMap() {
        return this.contractsMap;
    }

    @NotNull
    protected final HashSet<byte[]> getOutPointBufferSet() {
        return this.outPointBufferSet;
    }

    @NotNull
    protected final HashMap<Sha256Hash, Sha256Hash> getPreorderSalts() {
        return this.preorderSalts;
    }

    @Override
    @Nullable
    public DataContract fetchDataContract(@NotNull Identifier id) {
        ClientAppDefinition contractInfo;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (this.contractsMap.containsKey(id)) {
                return this.contractsMap.get(id);
            }
            Collection<ClientAppDefinition> collection = this.platform.getApps().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"platform.apps.values");
            Iterable iterable = collection;
            for (Object t : iterable) {
                ClientAppDefinition it = (ClientAppDefinition)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContractId(), (Object)id)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        ClientAppDefinition clientAppDefinition = contractInfo = (ClientAppDefinition)v1;
        if ((clientAppDefinition != null ? clientAppDefinition.getContract() : null) != null) {
            return contractInfo.getContract();
        }
        DataContract contractResponse = this.platform.getClient().getDataContract(id.toBuffer(), true);
        return contractResponse;
    }

    @Override
    @NotNull
    public List<Document> fetchDocuments(@NotNull Identifier contractId, @NotNull String documentType, @NotNull Object where) {
        Intrinsics.checkNotNullParameter((Object)contractId, (String)"contractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        DocumentQuery cfr_ignored_0 = (DocumentQuery)where;
        List<Document> documentResponse = this.platform.getClient().getDocuments(contractId.toBuffer(), documentType, (DocumentQuery)where, true);
        return documentResponse;
    }

    @Override
    @Nullable
    public Transaction fetchTransaction(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        byte[] byArray = this.platform.getClient().getTransactionBytes(id);
        if (byArray == null) {
            return null;
        }
        byte[] txData = byArray;
        return new Transaction(null, txData);
    }

    @Override
    public boolean isAssetLockTransactionOutPointAlreadyUsed(@NotNull byte[] outPointBuffer) {
        Intrinsics.checkNotNullParameter((Object)outPointBuffer, (String)"outPointBuffer");
        return this.outPointBufferSet.contains(outPointBuffer);
    }

    @Override
    public void markAssetLockTransactionOutPointAsUsed(@NotNull byte[] outPointBuffer) {
        Intrinsics.checkNotNullParameter((Object)outPointBuffer, (String)"outPointBuffer");
        this.outPointBufferSet.add(outPointBuffer);
    }

    @Override
    public void removeDocument(@NotNull Identifier contractId, @NotNull String type, @NotNull Identifier id) {
        Intrinsics.checkNotNullParameter((Object)contractId, (String)"contractId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
    }

    @Override
    public void storeDataContract(@NotNull DataContract dataContract) {
        Intrinsics.checkNotNullParameter((Object)dataContract, (String)"dataContract");
        if (!this.contractsMap.containsKey(dataContract.getId())) {
            ((Map)this.contractsMap).put(dataContract.getId(), dataContract);
        }
        log.info("store dataContract: {}", (Object)ExtensionsKt.toHex(dataContract.toBuffer()));
    }

    @Override
    public void storeDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ((Map)this.documentsMap).put(document.getId(), document);
        log.info("store document[{}]: {}", (Object)document.getType(), (Object)ExtensionsKt.toHex(document.toBuffer()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeIdentity(@NotNull Identity identity) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        if (!this.identityMap.containsKey(identity.getId())) {
            ((Map)this.identityMap).put(identity.getId(), identity);
        }
        Iterable iterable = identity.getPublicKeys();
        Identifier identifier = identity.getId();
        PlatformStateRepository platformStateRepository = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            byte[] byArray;
            void it;
            IdentityPublicKey identityPublicKey = (IdentityPublicKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: 
                case 2: {
                    byArray = it.getData();
                    break;
                }
                case 3: {
                    byArray = ECKey.fromPublicOnly((byte[])it.getData()).getPubKeyHash();
                    break;
                }
                default: {
                    byArray = Sha256Hash.twiceOf((byte[])it.getData()).getBytes();
                }
            }
            collection.add(byArray);
        }
        collection = (List)destination$iv$iv;
        platformStateRepository.storeIdentityPublicKeyHashes(identifier, (List<byte[]>)collection);
        log.info("store identity: {}", (Object)ExtensionsKt.toHex(identity.toBuffer()));
    }

    @Override
    public void storeIdentityPublicKeyHashes(@NotNull Identifier identity, @NotNull List<byte[]> publicKeyHashes) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter(publicKeyHashes, (String)"publicKeyHashes");
        ((Map)this.identityHashesMap).put(identity, publicKeyHashes);
    }

    @Override
    public boolean verifyInstantLock(@NotNull InstantSendLock instantLock) {
        Intrinsics.checkNotNullParameter((Object)instantLock, (String)"instantLock");
        return false;
    }

    @Override
    @Nullable
    public Identity fetchIdentity(@NotNull Identifier id) {
        Identity identity;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.identityMap.containsKey(id)) {
            return this.identityMap.get(id);
        }
        try {
            Identity identityResponse = this.platform.getClient().getIdentity(id.toBuffer(), true);
        }
        catch (NotFoundException e) {
            identity = null;
        }
        Identity identity2 = identity;
        if (identity2 != null) {
            this.storeIdentity(identity2);
        }
        return identity2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Identity fetchIdentityFromPubKeyHash(@NotNull byte[] pubKeyHash) {
        Identity identity;
        Intrinsics.checkNotNullParameter((Object)pubKeyHash, (String)"pubKeyHash");
        try {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.identityHashesMap;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Map.Entry element$iv$iv;
                block6: {
                    Map.Entry entry = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Iterable $this$any$iv = (Iterable)entry.getValue();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            byte[] it = (byte[])element$iv;
                            boolean bl3 = false;
                            if (!Arrays.equals(it, pubKeyHash)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Identifier identifier = (Identifier)CollectionsKt.first((Iterable)destination$iv$iv.keySet());
            identity = this.fetchIdentity(identifier);
        }
        catch (NoSuchElementException e) {
            identity = this.platform.getClient().getIdentityByFirstPublicKey(pubKeyHash, false);
        }
        return identity;
    }

    @Override
    @NotNull
    public byte[] fetchLatestPlatformBlockHeader() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void addValidIdentity(@NotNull Identifier identityId) {
        Intrinsics.checkNotNullParameter((Object)identityId, (String)"identityId");
        this.validIdentities.add(identityId);
    }

    @NotNull
    public final List<Identifier> validIdentityIdList() {
        Set<Identifier> set = this.identityMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"identityMap.keys");
        List result = CollectionsKt.toMutableList((Collection)set);
        result.addAll((Collection)this.validIdentities);
        return result;
    }

    public final void addValidDocument(@NotNull Identifier identityId) {
        Intrinsics.checkNotNullParameter((Object)identityId, (String)"identityId");
        this.validDocuments.add(identityId);
    }

    @NotNull
    public final List<Identifier> validDocumentIdList() {
        Set<Identifier> set = this.documentsMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"documentsMap.keys");
        List result = CollectionsKt.toMutableList((Collection)set);
        result.addAll((Collection)this.validDocuments);
        return result;
    }

    public final void addValidPreorderSalt(@NotNull byte[] preorderSalt, @NotNull byte[] saltedDomainHash) {
        Intrinsics.checkNotNullParameter((Object)preorderSalt, (String)"preorderSalt");
        Intrinsics.checkNotNullParameter((Object)saltedDomainHash, (String)"saltedDomainHash");
        Map map = this.preorderSalts;
        Sha256Hash sha256Hash = Sha256Hash.wrap((byte[])preorderSalt);
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"wrap(preorderSalt)");
        Sha256Hash sha256Hash2 = sha256Hash;
        Sha256Hash sha256Hash3 = Sha256Hash.wrap((byte[])saltedDomainHash);
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash3, (String)"wrap(saltedDomainHash)");
        Sha256Hash sha256Hash4 = sha256Hash3;
        map.put(sha256Hash2, sha256Hash4);
    }

    @NotNull
    public final Map<Sha256Hash, Sha256Hash> validPreorderSalts() {
        return this.preorderSalts;
    }

    public final void dump() {
        Map.Entry it;
        Map.Entry element$iv;
        System.out.println((Object)"dataContracts:");
        Map $this$forEach$iv = this.contractsMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            System.out.println((Object)ExtensionsKt.toHex(((DataContract)it.getValue()).toBuffer()));
        }
        System.out.println((Object)"identities:");
        $this$forEach$iv = this.identityMap;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            System.out.println((Object)ExtensionsKt.toHex(((Identity)it.getValue()).toBuffer()));
        }
        System.out.println((Object)"documents:");
        $this$forEach$iv = this.documentsMap;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            System.out.println((Object)(((Document)it.getValue()).getType() + ": " + ExtensionsKt.toHex(((Document)it.getValue()).toBuffer())));
        }
    }

    public void broadcastStateTransition(@NotNull StateTransitionIdentitySigned signedStateTransition) {
        Intrinsics.checkNotNullParameter((Object)signedStateTransition, (String)"signedStateTransition");
        DapiClient.broadcastStateTransition$default(this.platform.getClient(), signedStateTransition, false, 2, null);
    }

    public final void storeDataContract(@NotNull byte[] dataContractBytes) {
        Intrinsics.checkNotNullParameter((Object)dataContractBytes, (String)"dataContractBytes");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(dataContractBytes);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawDataContract = (Map)pair.component2();
        Integer n = protocolVersion;
        rawDataContract.put("protocolVersion", n);
        DataContract contract = new DataContract(rawDataContract);
        this.storeDataContract(contract);
    }

    public final void storeDocument(@NotNull byte[] documentBytes) {
        Intrinsics.checkNotNullParameter((Object)documentBytes, (String)"documentBytes");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(documentBytes);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawDocument = (Map)pair.component2();
        Integer n = protocolVersion;
        rawDocument.put("protocolVersion", n);
        DataContract dataContract = this.fetchDataContract(Identifier.Companion.from$default(Identifier.Companion, rawDocument.get("$dataContractId"), null, 2, null));
        Intrinsics.checkNotNull((Object)dataContract);
        Document document = new Document(rawDocument, dataContract);
        this.storeDocument(document);
    }

    public final void storeIdentity(@NotNull byte[] identityBytes) {
        Intrinsics.checkNotNullParameter((Object)identityBytes, (String)"identityBytes");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(identityBytes);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawIdentity = (Map)pair.component2();
        Integer n = protocolVersion;
        rawIdentity.put("protocolVersion", n);
        Identity identity = new Identity(rawIdentity);
        this.storeIdentity(identity);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PlatformStateRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PlatformStateRepository::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dashj/platform/sdk/platform/PlatformStateRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyType.values().length];
            try {
                nArray[KeyType.ECDSA_HASH160.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.BIP13_SCRIPT_HASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.ECDSA_SECP256K1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

