/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.wallet;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.sdk.BlockHeight;
import org.dashj.platform.sdk.CoreBlockHeight;
import org.dashj.platform.sdk.Document;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.IdentityPublicKey;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.dashsdk;
import org.dashj.platform.sdk.platform.Names;
import org.dashj.platform.sdk.platform.Platform;
import org.dashj.platform.wallet.IdentityVerifyDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\nJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\nJ \u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/dashj/platform/wallet/IdentityVerify;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "create", "Lorg/dashj/platform/wallet/IdentityVerifyDocument;", "normalizedLabel", "", "normalizedParentDomainName", "url", "identity", "Lorg/dashj/platform/dpp/identity/Identity;", "signer", "Lorg/dashj/platform/sdk/callbacks/Signer;", "createDocument", "createForDashDomain", "username", "get", "", "userId", "query", "Lorg/dashj/platform/dapiclient/model/DocumentQuery;", "Lorg/dashj/platform/dpp/identifier/Identifier;", "createdAfter", "", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nIdentityVerify.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityVerify.kt\norg/dashj/platform/wallet/IdentityVerify\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1549#2:145\n1620#2,3:146\n1549#2:149\n1620#2,3:150\n*S KotlinDebug\n*F\n+ 1 IdentityVerify.kt\norg/dashj/platform/wallet/IdentityVerify\n*L\n115#1:145\n115#1:146,3\n141#1:149\n141#1:150,3\n*E\n"})
public final class IdentityVerify {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    public static final String DOCUMENT = "dashwallet.identityVerify";
    private static final Logger log = LoggerFactory.getLogger(IdentityVerify.class);

    public IdentityVerify(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final IdentityVerifyDocument createForDashDomain(@NotNull String username, @NotNull String url, @NotNull Identity identity, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        return this.create(Names.Companion.normalizeString(username), "dash", url, identity, signer);
    }

    @NotNull
    public final IdentityVerifyDocument create(@NotNull String normalizedLabel, @NotNull String normalizedParentDomainName, @NotNull String url, @NotNull Identity identity, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)normalizedLabel, (String)"normalizedLabel");
        Intrinsics.checkNotNullParameter((Object)normalizedParentDomainName, (String)"normalizedParentDomainName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        IdentityVerifyDocument existingIdentityVerifyDocument = this.get(identity.getId(), normalizedLabel, normalizedParentDomainName);
        if (existingIdentityVerifyDocument != null) {
            log.info("identity verify document already exists");
            return existingIdentityVerifyDocument;
        }
        IdentityVerifyDocument identityVerifyDocument = this.createDocument(normalizedLabel, normalizedParentDomainName, url, identity);
        org.dashj.platform.dpp.identity.IdentityPublicKey identityPublicKey = identity.getFirstPublicKey(SecurityLevel.HIGH);
        if (identityPublicKey == null) {
            throw new IllegalStateException("can't find a public key with HIGH security level".toString());
        }
        org.dashj.platform.dpp.identity.IdentityPublicKey highIdentityPublicKey = identityPublicKey;
        SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk = this.platform.getRustSdk();
        Document document = identityVerifyDocument.toNative();
        org.dashj.platform.dpp.identifier.Identifier identifier = identityVerifyDocument.getDataContractId();
        Intrinsics.checkNotNull((Object)identifier);
        Result documentResult = dashsdk.platformMobilePutPutDocumentSdk((SWIGTYPE_p_DashSdk)sWIGTYPE_p_DashSdk, (Document)document, (Identifier)identifier.toNative(), (String)identityVerifyDocument.getType(), (IdentityPublicKey)highIdentityPublicKey.toNative(), (BlockHeight)new BlockHeight(10000), (CoreBlockHeight)new CoreBlockHeight(this.platform.getCoreBlockHeight()), (long)signer.getNativeContext(), (BigInteger)BigInteger.valueOf(signer.getSignerCallback()));
        Document domain = (Document)documentResult.unwrap();
        Intrinsics.checkNotNullExpressionValue((Object)domain, (String)"domain");
        org.dashj.platform.dpp.identifier.Identifier identifier2 = identityVerifyDocument.getDataContractId();
        Intrinsics.checkNotNull((Object)identifier2);
        return new IdentityVerifyDocument(new org.dashj.platform.dpp.document.Document(domain, identifier2));
    }

    @NotNull
    public final IdentityVerifyDocument createDocument(@NotNull String normalizedLabel, @NotNull String normalizedParentDomainName, @NotNull String url, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)normalizedLabel, (String)"normalizedLabel");
        Intrinsics.checkNotNullParameter((Object)normalizedParentDomainName, (String)"normalizedParentDomainName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"normalizedLabel", (Object)normalizedLabel), TuplesKt.to((Object)"normalizedParentDomainName", (Object)normalizedParentDomainName), TuplesKt.to((Object)"url", (Object)url)};
        org.dashj.platform.dpp.document.Document document = this.platform.getDocuments().create(DOCUMENT, identity.getId(), MapsKt.mutableMapOf((Pair[])pairArray));
        document.setRevision(1L);
        return new IdentityVerifyDocument(document);
    }

    @NotNull
    public final List<IdentityVerifyDocument> get(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return IdentityVerify.get$default(this, Identifier.Companion.from$default(org.dashj.platform.dpp.identifier.Identifier.Companion, userId, null, 2, null), 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IdentityVerifyDocument> get(@NotNull org.dashj.platform.dpp.identifier.Identifier userId, long createdAfter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        DocumentQuery.Builder queryBuilder = new DocumentQuery.Builder(null, null, 0, null, null, 31, null).where("$ownerId", "==", userId);
        if (createdAfter != -1L) {
            Object[] objectArray = new Object[]{"$createdAt", ">=", createdAfter};
            queryBuilder.where(CollectionsKt.listOf((Object[])objectArray));
        }
        DocumentQuery query = queryBuilder.build();
        Iterable $this$map$iv = this.platform.getDocuments().get(DOCUMENT, query);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.dashj.platform.dpp.document.Document document = (org.dashj.platform.dpp.document.Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IdentityVerifyDocument((org.dashj.platform.dpp.document.Document)it));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List get$default(IdentityVerify identityVerify, org.dashj.platform.dpp.identifier.Identifier identifier, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        return identityVerify.get(identifier, l);
    }

    @Nullable
    public final IdentityVerifyDocument get(@NotNull org.dashj.platform.dpp.identifier.Identifier userId, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return this.get(userId, Names.Companion.normalizeString(username), "dash");
    }

    @Nullable
    public final IdentityVerifyDocument get(@NotNull org.dashj.platform.dpp.identifier.Identifier userId, @NotNull String normalizedLabel, @NotNull String normalizedParentDomainName) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)normalizedLabel, (String)"normalizedLabel");
        Intrinsics.checkNotNullParameter((Object)normalizedParentDomainName, (String)"normalizedParentDomainName");
        DocumentQuery.Builder queryBuilder = DocumentQuery.Builder.orderBy$default(new DocumentQuery.Builder(null, null, 0, null, null, 31, null).where("$ownerId", "==", userId).where("normalizedParentDomainName", "==", normalizedParentDomainName).where("normalizedLabel", "==", normalizedLabel), "normalizedLabel", false, 2, null);
        DocumentQuery query = queryBuilder.build();
        List<org.dashj.platform.dpp.document.Document> result = this.platform.getDocuments().get(DOCUMENT, query);
        return !((Collection)result).isEmpty() ? new IdentityVerifyDocument((org.dashj.platform.dpp.document.Document)CollectionsKt.first(result)) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IdentityVerifyDocument> get(@NotNull DocumentQuery query) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List<org.dashj.platform.dpp.document.Document> result = this.platform.getDocuments().get(DOCUMENT, query);
        Iterable $this$map$iv = result;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            org.dashj.platform.dpp.document.Document document = (org.dashj.platform.dpp.document.Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IdentityVerifyDocument((org.dashj.platform.dpp.document.Document)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/dashj/platform/wallet/IdentityVerify$Companion;", "", "()V", "DOCUMENT", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

