/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.wallet;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.sdk.BlockHeight;
import org.dashj.platform.sdk.CoreBlockHeight;
import org.dashj.platform.sdk.Document;
import org.dashj.platform.sdk.Identifier;
import org.dashj.platform.sdk.IdentityPublicKey;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.dashsdk;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0016\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/dashj/platform/wallet/TxMetadata;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "create", "Lorg/dashj/platform/dpp/document/Document;", "keyIndex", "", "encryptionKeyIndex", "encryptedMetadata", "", "identity", "Lorg/dashj/platform/dpp/identity/Identity;", "id", "signer", "Lorg/dashj/platform/sdk/callbacks/Signer;", "createDocument", "get", "", "userId", "", "Lorg/dashj/platform/dpp/identifier/Identifier;", "createdAfter", "", "Companion", "dpp"})
public final class TxMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    public static final String DOCUMENT = "dashwallet.tx_metadata";

    public TxMetadata(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final org.dashj.platform.dpp.document.Document create(int keyIndex, int encryptionKeyIndex, @NotNull byte[] encryptedMetadata, @NotNull Identity identity, int id, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)encryptedMetadata, (String)"encryptedMetadata");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        org.dashj.platform.dpp.document.Document profileDocument = this.createDocument(keyIndex, encryptionKeyIndex, encryptedMetadata, identity);
        profileDocument.setCreatedAt(new Date().getTime());
        org.dashj.platform.dpp.identity.IdentityPublicKey identityPublicKey = identity.getFirstPublicKey(Purpose.AUTHENTICATION, SecurityLevel.HIGH);
        if (identityPublicKey == null) {
            throw new IllegalStateException("can't find a public key with HIGH security level".toString());
        }
        org.dashj.platform.dpp.identity.IdentityPublicKey highIdentityPublicKey = identityPublicKey;
        SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk = this.platform.getRustSdk();
        Document document = profileDocument.toNative();
        org.dashj.platform.dpp.identifier.Identifier identifier = profileDocument.getDataContractId();
        Intrinsics.checkNotNull((Object)identifier);
        Result documentResult = dashsdk.platformMobilePutPutDocumentSdk((SWIGTYPE_p_DashSdk)sWIGTYPE_p_DashSdk, (Document)document, (Identifier)identifier.toNative(), (String)profileDocument.getType(), (IdentityPublicKey)highIdentityPublicKey.toNative(), (BlockHeight)new BlockHeight(10000), (CoreBlockHeight)new CoreBlockHeight(this.platform.getCoreBlockHeight()), (long)signer.getNativeContext(), (BigInteger)BigInteger.valueOf(signer.getSignerCallback()));
        Document domain = (Document)documentResult.unwrap();
        Intrinsics.checkNotNullExpressionValue((Object)domain, (String)"domain");
        org.dashj.platform.dpp.identifier.Identifier identifier2 = profileDocument.getDataContractId();
        Intrinsics.checkNotNull((Object)identifier2);
        return new org.dashj.platform.dpp.document.Document(domain, identifier2);
    }

    @NotNull
    public final org.dashj.platform.dpp.document.Document createDocument(int keyIndex, int encryptionKeyIndex, @NotNull byte[] encryptedMetadata, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)encryptedMetadata, (String)"encryptedMetadata");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"keyIndex", (Object)keyIndex), TuplesKt.to((Object)"encryptionKeyIndex", (Object)encryptionKeyIndex), TuplesKt.to((Object)"encryptedMetadata", (Object)encryptedMetadata)};
        org.dashj.platform.dpp.document.Document document = this.platform.getDocuments().create(DOCUMENT, identity.getId(), MapsKt.mutableMapOf((Pair[])pairArray));
        document.setRevision(1L);
        document.setCreatedAt(new Date().getTime());
        return document;
    }

    @NotNull
    public final List<org.dashj.platform.dpp.document.Document> get(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return TxMetadata.get$default(this, Identifier.Companion.from$default(org.dashj.platform.dpp.identifier.Identifier.Companion, userId, null, 2, null), 0L, 2, null);
    }

    @NotNull
    public final List<org.dashj.platform.dpp.document.Document> get(@NotNull org.dashj.platform.dpp.identifier.Identifier userId, long createdAfter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        DocumentQuery.Builder queryBuilder = DocumentQuery.Builder.orderBy$default(new DocumentQuery.Builder(null, null, 0, null, null, 31, null).where("$ownerId", "==", userId), "$createdAt", false, 2, null);
        if (createdAfter != -1L) {
            Object[] objectArray = new Object[]{"$createdAt", ">=", createdAfter};
            queryBuilder.where(CollectionsKt.listOf((Object[])objectArray));
        }
        DocumentQuery query = queryBuilder.build();
        return this.platform.getDocuments().get(DOCUMENT, query);
    }

    public static /* synthetic */ List get$default(TxMetadata txMetadata, org.dashj.platform.dpp.identifier.Identifier identifier, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        return txMetadata.get(identifier, l);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dashj/platform/wallet/TxMetadata$Companion;", "", "()V", "DOCUMENT", "", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

