/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.autoversioning;

import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersioningService;

import java.util.Date;

/**
 *
 *
 * @author Fabio Bolognesi (fabio at atmire dot com)
 * @author Mark Diggory (markd at atmire dot com)
 * @author Ben Bosman (ben at atmire dot com)
 */
public interface AutoVersioningService extends VersioningService {

    AutoVersion getAutoVersion(Context c, int versionID);

    Item restoreAutoVersion(Context c, int versionID, String summary);

    AutoVersionHistory findAutoVersionHistory(Context c, int itemId);

    AutoVersion updateVersionByVersionId(Context c, int itemId, int versionId, String summary);

    boolean canVersion(Context c, Item item);

    AutoVersion createNewWorkingVersionInSubmission(Context context, int itemID, String summary);
    AutoVersionImpl updateVersionHistory(Context c, Item item, String summary, String log, Date date);
    AutoVersionImpl updateVersionHistory(Context c, Item item, int versionId, String summary, String log, Date date);

    AutoVersionHistory findVersionByHistoryId(Context c, int versionHistoryId) ;
}
