/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.autoversioning;

import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;

public class AutoVersioningConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(AutoVersioningConsumer.class);
    private MultiValueMap itemsToProcess;

    public void initialize() throws Exception {
    }

    public void finish(Context ctx) throws Exception {
    }

    public void consume(Context ctx, Event event) throws Exception {
        Bitstream bitstream;
        DSpaceObject dso;
        if (this.itemsToProcess == null) {
            this.itemsToProcess = new MultiValueMap();
        }
        int st = event.getSubjectType();
        int et = event.getEventType();
        if (st == 2 && (et == 64 || et == 2 || et == 4)) {
            Item item = (Item)event.getSubject(ctx);
            this.itemsToProcess.put((Object)item, (Object)event);
        } else if (st == 0 && (et == 2 || et == 4) && (dso = (bitstream = (Bitstream)event.getSubject(ctx)).getParentObject()) != null && dso.getType() == 2) {
            Item item = (Item)dso;
            this.itemsToProcess.put((Object)item, (Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Context ctx) throws Exception {
        if (this.itemsToProcess != null) {
            AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
            for (Object obj : this.itemsToProcess.keySet()) {
                Collection events = this.itemsToProcess.getCollection(obj);
                ctx.turnOffAuthorisationSystem();
                try {
                    Item item = (Item)obj;
                    if (item == null || !item.isArchived()) continue;
                    String summary = "";
                    if (this.eventsToString(events).contains("INSTALL")) {
                        summary = "Create New Item";
                    } else {
                        summary = new DSpace().getRequestService().getCurrentRequest().getHttpServletRequest().getParameter("summary");
                        if (summary == null) {
                            summary = "Modify Item";
                        }
                    }
                    Integer versionId = (Integer)new DSpace().getRequestService().getCurrentRequest().getAttribute("versionID");
                    if (versionId != null) {
                        versioningService.updateVersionHistory(ctx, item, versionId, summary, this.eventsToString(events), new Date());
                    } else {
                        versioningService.updateVersionHistory(ctx, item, summary, this.eventsToString(events), new Date());
                    }
                    ctx.getDBConnection().commit();
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
                finally {
                    ctx.restoreAuthSystemState();
                }
            }
        }
        this.itemsToProcess = null;
    }

    private String eventsToString(Collection<Event> events) {
        String s = "";
        for (Event event : events) {
            s = s + event.toString() + "\n";
        }
        return s;
    }

    private static AutoVersionHistory retrieveVersionHistory(Context c, Item item) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.findAutoVersionHistory(c, item.getID());
    }
}

