/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.autoversioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.ItemAutoVersionProvider;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierService;
import org.dspace.utils.DSpace;
import org.dspace.versioning.AbstractVersionProvider;

public class DefaultItemAutoVersionProvider
extends AbstractVersionProvider
implements ItemAutoVersionProvider {
    @Override
    public Item createNewItemAndAddItInWorkspace(Context context, Item nativeItem) {
        try {
            WorkspaceItem workspaceItem = WorkspaceItem.create((Context)context, (Collection)nativeItem.getOwningCollection(), (boolean)false);
            Item itemNew = workspaceItem.getItem();
            itemNew.update();
            return itemNew;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteVersionedItem(Context c, AutoVersion versionToDelete, AutoVersionHistory history) {
        try {
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            Item itemToDelete = versionToDelete.getItem();
            if (itemToDelete != null) {
                identifierService.delete(c, (DSpaceObject)itemToDelete);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IdentifierException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Item updateItemState(Context c, Item itemNew, Item previousItem) {
        try {
            this.copyMetadata(itemNew, previousItem);
            this.createBundlesAndAddBitstreams(c, itemNew, previousItem);
            List policies = AuthorizeManager.findPoliciesByDSOAndType((Context)c, (DSpaceObject)previousItem, (String)ResourcePolicy.TYPE_CUSTOM);
            AuthorizeManager.addPolicies((Context)c, (List)policies, (DSpaceObject)itemNew);
            itemNew.update();
            return itemNew;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

