/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.InternalDSpaceAIPDisseminator;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.bitstore.BitstreamStorageOutputStream;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class AIPManifestWriter {
    private static Logger log = Logger.getLogger(AIPManifestWriter.class);
    private static String PACKAGER_NAME = "INTERNAL-AIP";

    public Bitstream updateAIP(Context context, DSpaceObject dso, boolean force) throws SQLException, IOException, PackageException, CrosswalkException, AuthorizeException, NoSuchAlgorithmException {
        InternalDSpaceAIPDisseminator dip = (InternalDSpaceAIPDisseminator)((Object)PluginManager.getNamedPlugin(PackageDisseminator.class, (String)PACKAGER_NAME));
        if (dip == null) {
            log.error((Object)("Error, Cannot find PackageDisseminator type: " + PACKAGER_NAME));
            throw new PackageException("Cannot find PackageDisseminator type: " + PACKAGER_NAME);
        }
        PackageParameters pkgParams = new PackageParameters();
        pkgParams.addProperty("manifestOnly", "true");
        pkgParams.addProperty("internal", "true");
        pkgParams.addProperty("includeBundles", "+all");
        pkgParams.put((Object)"context", (Object)context);
        BitstreamStorageOutputStream bos = BitstreamStorageManager.store(context, BitstreamFormat.findByShortDescription((Context)context, (String)"http://www.loc.gov/METS/"));
        dip.disseminate(context, dso, pkgParams, bos);
        int bitstreamId = bos.getBitstreamID();
        Bitstream aipBitstream = Bitstream.find((Context)context, (int)bitstreamId);
        if (aipBitstream == null) {
            throw new IOException("Writing to AIP bitstream failed, see log.");
        }
        aipBitstream.setName("mets.xml");
        return aipBitstream;
    }

    public static Bitstream dereferenceAbsoluteURI(Context context, URI uri) throws SQLException {
        TableRow row = BitstreamStorageManager.dereferenceAbsoluteURI(context, uri);
        if (row == null) {
            return null;
        }
        return new Bitstream(context, row);
    }

    public URI getAbsoluteURI(Context context, Bitstream bitstream) {
        try {
            TableRow bRow = DatabaseManager.findByUnique((Context)context, (String)"Bitstream", (String)"bitstream_id", (Object)bitstream.getID());
            URI result = BitstreamStorageManager.getAbsoluteURI(bRow, bitstream.getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bitstream.getAbsoluteURI returning = \"" + result + "\""));
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

