/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class BitstreamUtil {
    private static Logger log = Logger.getLogger(BitstreamUtil.class);

    public static void delete(Context context, Bitstream bitstream, boolean cleanup) throws SQLException, IOException {
        bitstream.delete();
        if (cleanup) {
            BitstreamStorageManager.cleanup(context, bitstream.getID(), true, true);
        }
    }

    public static void delete(Bitstream bitstream) throws SQLException {
        bitstream.delete();
    }

    public static boolean isDeleted(Bitstream bitstream) throws SQLException {
        return bitstream.isDeleted();
    }

    public static Bitstream findByUuid(Context context, String uuid) throws SQLException {
        Bitstream fromCache;
        TableRow row;
        if (uuid.contains(":")) {
            uuid = uuid.substring(uuid.lastIndexOf(":") + 1);
        }
        if ((row = DatabaseManager.findByUnique((Context)context, (String)"bitstream", (String)"uuid", (Object)uuid)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"find_bitstream", (String)("not_found,bitstream_id=" + uuid)));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader((Context)context, (String)"find_bitstream", (String)("uuid=" + uuid)));
        }
        if ((fromCache = (Bitstream)context.fromCache(Bitstream.class, row.getIntColumn("bitstream_id"))) != null) {
            return fromCache;
        }
        return new Bitstream(context, row);
    }

    public static String getUuid(Context context, Bitstream bitstream) throws SQLException {
        TableRowIterator row = DatabaseManager.query((Context)context, (String)("select * from bitstream where bitstream_id = " + bitstream.getID()), (Object[])new Object[0]);
        if (row.hasNext()) {
            return row.next().getStringColumn("uuid");
        }
        return null;
    }

    public static Date getLastModifiedDate(Context context, Bitstream bitstream) throws SQLException {
        TableRowIterator row = DatabaseManager.query((Context)context, (String)("select * from bitstream where bitstream_id = " + bitstream.getID()), (Object[])new Object[0]);
        if (row.hasNext()) {
            return row.next().getDateColumn("last_modified_date");
        }
        return null;
    }

    public static Date getDateCreated(Context context, Bitstream bitstream) throws SQLException {
        TableRowIterator row = DatabaseManager.query((Context)context, (String)("select * from bitstream where bitstream_id = " + bitstream.getID()), (Object[])new Object[0]);
        if (row.hasNext()) {
            return row.next().getDateColumn("create_date");
        }
        return null;
    }
}

