/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersioningUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.bitstore.BitstreamStorageOutputStream;

public class OREManifestWriter {
    static SimpleDateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    protected String encode(String id) {
        try {
            return URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(id);
        }
    }

    public Bitstream updateORE(Context c, Item newItem, AutoVersion version, boolean b) throws NoSuchAlgorithmException, SQLException, IOException {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("cito", "http://purl.org/spar/cito/");
        model.setNsPrefix("ore", "http://www.openarchives.org/ore/terms/");
        model.setNsPrefix("dc", "http://purl.org/dc/elements/1.1/");
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        BitstreamStorageOutputStream bos = BitstreamStorageManager.store(c, BitstreamFormat.findByShortDescription((Context)c, (String)"http://www.openarchives.org/ore/terms/"));
        int id = bos.getBitstreamID();
        String identifier = bos.getBitstreamUuid();
        String identifierEncoded = this.encode(identifier);
        Resource aggregation = model.createResource("https://cn.dataone.org/cn/v1/resolve/" + identifierEncoded + "#aggregation").addProperty(RDF.type, (RDFNode)ORE.Aggregation).addProperty(DCTerms.title, newItem.getMetadata("dc.title"));
        Resource rem = model.createResource("https://cn.dataone.org/cn/v1/resolve/" + identifierEncoded).addProperty(RDF.type, (RDFNode)ORE.ResourceMap).addProperty(DC.format, "application/rdf+xml").addProperty(DCTerms.created, dateFormatUTC.format(new Date())).addProperty(DCTerms.creator, ConfigurationManager.getProperty((String)"dspace.url")).addProperty(DCTerms.identifier, identifier).addProperty(DCTerms.modified, dateFormatUTC.format(new Date())).addProperty(ORE.describes, (RDFNode)aggregation);
        Bitstream mets = version.getAIPBitstream();
        Resource scimeta = model.createResource("https://cn.dataone.org/cn/v1/resolve/" + this.encode(AutoVersioningUtil.getPid(c, mets))).addProperty(DCTerms.identifier, AutoVersioningUtil.getPid(c, mets));
        aggregation.addProperty(ORE.aggregates, (RDFNode)scimeta);
        for (Bundle bundle : newItem.getBundles()) {
            for (Bitstream bits : bundle.getBitstreams()) {
                Resource scidata = model.createResource("https://cn.dataone.org/cn/v1/resolve/" + this.encode(AutoVersioningUtil.getPid(c, bits)));
                if (bits.getDescription() != null) {
                    scidata.addProperty(DCTerms.description, bits.getDescription());
                }
                if (bits.getName() != null) {
                    scidata.addProperty(DCTerms.title, bits.getName());
                }
                scidata.addProperty(DCTerms.identifier, AutoVersioningUtil.getPid(c, bits));
                scidata.addProperty(CITO.isDocumentedBy, (RDFNode)scimeta);
                scimeta.addProperty(CITO.documents, (RDFNode)scidata);
                aggregation.addProperty(ORE.aggregates, (RDFNode)scidata);
            }
        }
        model.write((OutputStream)bos);
        bos.close();
        Bitstream oreBitstream = Bitstream.find((Context)c, (int)bos.getBitstreamID());
        oreBitstream.setName("ore.rdf");
        return oreBitstream;
    }

    static {
        dateFormatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class CITO {
        private static Model m_model = ModelFactory.createDefaultModel();
        public static final String NS = "http://purl.org/spar/cito/";
        public static final Property isDocumentedBy = m_model.createProperty("http://purl.org/spar/cito/isDocumentedBy");
        public static final Property documents = m_model.createProperty("http://purl.org/spar/cito/documents");
    }

    public static class ORE {
        private static Model m_model = ModelFactory.createDefaultModel();
        public static final String NS = "http://www.openarchives.org/ore/terms/";
        public static final Property describes = m_model.createProperty("http://www.openarchives.org/ore/terms/describes");
        public static final Property aggregates = m_model.createProperty("http://www.openarchives.org/ore/terms/aggregates");
        public static final Resource Aggregation = m_model.createProperty("http://www.openarchives.org/ore/terms/Aggregation");
        public static final Resource ResourceMap = m_model.createProperty("http://www.openarchives.org/ore/terms/ResourceMap");
    }
}

