/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.xmlui.aspect.autoversioning;

import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.*;
import org.dspace.authorize.AuthorizeException;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.content.Item;
import org.dspace.content.Bitstream;
import org.dspace.utils.DSpace;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.versioning.VersioningService;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.sql.SQLException;

/**
 * User: lantian @ atmire . com
 * Date: 9/27/13
 * Time: 3:52 PM
 */
public class AutoVersionViewer extends AbstractDSpaceTransformer{

    private static final Message T_dspace_home =
            message("xmlui.general.dspace_home");
    private static final Message T_trail =
            message("xmlui.Version.versionhistory.trail");

    public void addPageMeta(PageMeta pageMeta) throws SAXException,
            WingException, UIException, SQLException, IOException,
            AuthorizeException
    {
        boolean isItemView=parameters.getParameterAsInteger("itemID",-1) == -1;

        // retrieve version ID from Request:
        AutoVersioningService versioningService = (AutoVersioningService) new DSpace().getSingletonService(VersioningService.class);

        // Get our parameters and state
        int versionId = parameters.getParameterAsInteger("versionID",-1);

        AutoVersion version = versioningService.getAutoVersion(context, versionId);

        AutoVersionHistory vh = versioningService.findVersionByHistoryId(context, version.getVersionHistoryID());
        AutoVersion latest = vh.getLatestVersion();
        Item item = latest.getItem();

        if(item!=null){
            String title = item.getMetadata("dc.title");
            pageMeta.addTrailLink(contextPath + "/",T_dspace_home);
            HandleUtil.buildHandleTrail(item, pageMeta, contextPath);
            if(title!=null&&title.length()>0)
                pageMeta.addTrailLink(contextPath+"/handle/"+item.getHandle(),title);
            else
                pageMeta.addTrail().addContent("Item");

            pageMeta.addTrail().addContent(T_trail);
        }
        else
        {
            pageMeta.addTrailLink(contextPath + "/",T_dspace_home);
            pageMeta.addTrail().addContent(T_trail);
        }
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException, ProcessingException {

        //todo:add login check for version
        // retrieve version ID from Request:
        AutoVersioningService versioningService = (AutoVersioningService) new DSpace().getSingletonService(VersioningService.class);

        // Get our parameters and state
        int versionId = parameters.getParameterAsInteger("versionID",-1);

        AutoVersion version = versioningService.getAutoVersion(context, versionId);

        AutoVersionHistory vh = versioningService.findVersionByHistoryId(context, version.getVersionHistoryID());
        AutoVersion latest = vh.getLatestVersion();
        Item item = latest.getItem();

        String title = "";

        if(item != null)
        {
            title += "Version " + version.getVersionNumber() + " for Item: " + item.getHandle();
        }
        else
        {
            title +="Version " + version.getVersionNumber() + "for Deleted Item : " + version.getHandle();
        }

        // Build the item viewer division.
        Division division = body.addDivision("version-view","primary");
        division.setHead(title);

        //metadata/internal/*/*/mets.xml
        Bitstream bitstream = version.getAIPBitstream();
        if(bitstream!=null){
            ReferenceSet referenceSet = division.addReferenceSet("version-viewer", ReferenceSet.TYPE_DETAIL_VIEW);

            referenceSet.addReference(bitstream);

            Division restoreForm = division.addInteractiveDivision("restore-version",contextPath+"/restore-version",Division.METHOD_POST);
            List list = restoreForm.addList("version",List.TYPE_FORM);
            list.addItem().addHidden("versionId");
            //list.addItem().addButton("revision","revision").setValue("Restore this version");
        }
        else
        {
            division.addPara("No Version Manifest (METS) Present");
        }

        Table table = division.addTable("version-details", 7, 2);
        table.setHead("Version Details");

        Row header = table.addRow(Row.ROLE_HEADER);
        header.addCell().addContent("Attribute");
        header.addCell().addContent("Value");

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Version Id");
            row.addCell().addContent(version.getVersionId());
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Version Number");
            row.addCell().addContent(version.getVersionNumber());
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Item Id");
            row.addCell().addContent(version.getItemID());
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Summary");
            row.addCell().addContent(version.getSummary());
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Create Date");
            row.addCell().addContent(version.getVersionDate().toString());
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Creator");
            if(version.getEperson() != null) {
                row.addCell().addXref("mailto:" + version.getEperson().getEmail(), version.getEperson().getFullName());
            }else {
                row.addCell("No Creator Recorded");
            }
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Version Manifest (METS)");
            if(version.getAIPBitstream() != null) {
                row.addCell().addXref(
                        contextPath+"/bitstream/id/" + version.getAIPBitstream().getID() + "/mets.xml",
                        "View/Download");
            }else {
                row.addCell().addContent("No Version Manifest Present");
            }
        }

        {
            Row row = table.addRow(Row.ROLE_DATA);
            row.addCell().addContent("Version Manifest (ORE)");
            if(version.getAIPBitstream() != null) {
                row.addCell().addXref(
                        contextPath+"/bitstream/id/" + version.getOREBitstream().getID() + "/ore.xml",
                        "View/Download");
            }
        }



        Division log = division.addDivision("version-log");
        log.setHead("Version Event Logs");

        if(StringUtils.isBlank(version.getVersionLog())){
            log.addPara("version-log-para","version-log-para").addContent("No log");
        }else{
            String[] splitVersionLog = version.getVersionLog().split("org.dspace.event.Event");

            Table versionLogs = log.addTable("versionLogTable", splitVersionLog.length, 1);

            Row headers =versionLogs.addRow(Row.ROLE_HEADER);
            headers.addCell().addContent("Events that Generated Version");

            for (String eventRow : splitVersionLog) {
                if (StringUtils.isNotBlank(eventRow)) {
                    String[] eventParts = eventRow.split(",");
                    Row data = versionLogs.addRow(Row.ROLE_DATA);
                    for(String eventPart :eventParts){
                        data.addCellContent(eventPart);
                    }
                }
            }
        }



    }

}
