/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.xmlui.objectmanager;

import org.dspace.app.xmlui.wing.WingException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.core.Context;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

import java.io.IOException;
import java.sql.SQLException;

/**
 * User: lantian @ atmire . com
 * Date: 9/27/13
 * Time: 2:25 PM
 */
public class BitstreamAdapter extends AbstractAdapter{


    private Bitstream bitstream;

    private Context context;

    public BitstreamAdapter(Context context, Bitstream bitstream, String contextPath)
    {
        super(contextPath);
        this.bitstream = bitstream;
        this.context = context;
    }

    protected String getMETSOBJID()
    {
        if (bitstream.getHandle() != null)
        {
            return contextPath + "/handle/" + bitstream.getHandle();
        }
        return null;
    }

    protected String getMETSOBJEDIT()
    {
        return contextPath+"/admin/bitstream?bitstreamID=" + bitstream.getID();
    }

    /**
     * Return the item's handle as the METS ID
     */
    protected String getMETSID()
    {
        if (bitstream.getHandle() == null)
        {
            return "bitstream:" + bitstream.getID();
        }
        else
        {
            return "hdl:" + bitstream.getHandle();
        }
    }

    /**
     * Return the official METS SIP Profile.
     */
    protected String getMETSProfile() throws WingException
    {
        return "DSPACE METS SIP Profile 1.0";
    }

    protected String getMETSLabel()
    {
        return "DSpace Item";
    }

    /**
     * Render the complete METS document from Bitstream only
     */
    public void renderMETS(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws WingException, SAXException, CrosswalkException, IOException, SQLException
    {

        // ///////////////////////////////
        // Send the actual XML content
        try {
            SAXFilter filter = new SAXFilter(contentHandler, lexicalHandler, namespaces);
            // Allow the basics for XML
            filter.allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
            // Special option, only allow elements below the second level to pass through. This
            // will trim out the METS declaration and only leave the actual METS parts to be
            // included.
            filter.allowElements(-1);

            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(filter);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", filter);
            reader.parse(new InputSource(bitstream.retrieve()));
        }
        catch (AuthorizeException ae)
        {
            // just ignore the authorize exception and continue on
            // without parsing the xml document.
        }
    }



}
