/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.autoversioning;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;
import org.xml.sax.SAXException;

public class AutoVersionViewer
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = AutoVersionViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = AutoVersionViewer.message((String)"xmlui.Version.versionhistory.trail");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        int versionId;
        AutoVersion version;
        boolean isItemView = this.parameters.getParameterAsInteger("itemID", -1) == -1;
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        AutoVersionHistory vh = versioningService.findVersionByHistoryId(this.context, (version = versioningService.getAutoVersion(this.context, versionId = this.parameters.getParameterAsInteger("versionID", -1))).getVersionHistoryID());
        AutoVersion latest = vh.getLatestVersion();
        Item item = latest.getItem();
        if (item != null) {
            String title = item.getMetadata("dc.title");
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            HandleUtil.buildHandleTrail((DSpaceObject)item, (PageMeta)pageMeta, (String)this.contextPath);
            if (title != null && title.length() > 0) {
                pageMeta.addTrailLink(this.contextPath + "/handle/" + item.getHandle(), title);
            } else {
                pageMeta.addTrail().addContent("Item");
            }
            pageMeta.addTrail().addContent(T_trail);
        } else {
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            pageMeta.addTrail().addContent(T_trail);
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException, ProcessingException {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        int versionId = this.parameters.getParameterAsInteger("versionID", -1);
        AutoVersion version = versioningService.getAutoVersion(this.context, versionId);
        AutoVersionHistory vh = versioningService.findVersionByHistoryId(this.context, version.getVersionHistoryID());
        AutoVersion latest = vh.getLatestVersion();
        Item item = latest.getItem();
        String title = "";
        title = item != null ? title + "Version " + version.getVersionNumber() + " for Item: " + item.getHandle() : title + "Version " + version.getVersionNumber() + "for Deleted Item : " + version.getHandle();
        Division division = body.addDivision("version-view", "primary");
        division.setHead(title);
        Bitstream bitstream = version.getAIPBitstream();
        if (bitstream != null) {
            ReferenceSet referenceSet = division.addReferenceSet("version-viewer", "detailView");
            referenceSet.addReference((Object)bitstream);
            Division restoreForm = division.addInteractiveDivision("restore-version", this.contextPath + "/restore-version", "post");
            List list = restoreForm.addList("version", "form");
            list.addItem().addHidden("versionId");
        } else {
            division.addPara("No Version Manifest (METS) Present");
        }
        Table table = division.addTable("version-details", 7, 2);
        table.setHead("Version Details");
        Row header = table.addRow("header");
        header.addCell().addContent("Attribute");
        header.addCell().addContent("Value");
        Row row = table.addRow("data");
        row.addCell().addContent("Version Id");
        row.addCell().addContent(version.getVersionId());
        row = table.addRow("data");
        row.addCell().addContent("Version Number");
        row.addCell().addContent(version.getVersionNumber());
        row = table.addRow("data");
        row.addCell().addContent("Item Id");
        row.addCell().addContent(version.getItemID());
        row = table.addRow("data");
        row.addCell().addContent("Summary");
        row.addCell().addContent(version.getSummary());
        row = table.addRow("data");
        row.addCell().addContent("Create Date");
        row.addCell().addContent(version.getVersionDate().toString());
        row = table.addRow("data");
        row.addCell().addContent("Creator");
        if (version.getEperson() != null) {
            row.addCell().addXref("mailto:" + version.getEperson().getEmail(), version.getEperson().getFullName());
        } else {
            row.addCell("No Creator Recorded");
        }
        row = table.addRow("data");
        row.addCell().addContent("Version Manifest (METS)");
        if (version.getAIPBitstream() != null) {
            row.addCell().addXref(this.contextPath + "/bitstream/id/" + version.getAIPBitstream().getID() + "/mets.xml", "View/Download");
        } else {
            row.addCell().addContent("No Version Manifest Present");
        }
        row = table.addRow("data");
        row.addCell().addContent("Version Manifest (ORE)");
        if (version.getAIPBitstream() != null) {
            row.addCell().addXref(this.contextPath + "/bitstream/id/" + version.getOREBitstream().getID() + "/ore.xml", "View/Download");
        }
        Division log = division.addDivision("version-log");
        log.setHead("Version Event Logs");
        if (StringUtils.isBlank((String)version.getVersionLog())) {
            log.addPara("version-log-para", "version-log-para").addContent("No log");
        } else {
            String[] splitVersionLog = version.getVersionLog().split("org.dspace.event.Event");
            Table versionLogs = log.addTable("versionLogTable", splitVersionLog.length, 1);
            Row headers = versionLogs.addRow("header");
            headers.addCell().addContent("Events that Generated Version");
            for (String eventRow : splitVersionLog) {
                if (!StringUtils.isNotBlank((String)eventRow)) continue;
                String[] eventParts = eventRow.split(",");
                Row data = versionLogs.addRow("data");
                for (String eventPart : eventParts) {
                    data.addCellContent(eventPart);
                }
            }
        }
    }
}

