/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.autoversioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.xml.sax.SAXException;

public class AutoVersionHistoryForm
extends AbstractDSpaceTransformer {
    private static final Message T_head2 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.head2");
    private static final Message T_column1 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column1");
    private static final Message T_column2 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column2");
    private static final Message T_column3 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column3");
    private static final Message T_column4 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column4");
    private static final Message T_column5 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column5");
    private static final Message T_column6 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column6");
    private static final Message T_column7 = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column7");
    private static final Message T_submit_update = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.update");
    private static final Message T_submit_cancel = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.return");
    private static final Message T_submit_delete = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.delete");
    private static final Message T_legend = AutoVersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.legend");
    private static final Message T_dspace_home = AutoVersionHistoryForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = AutoVersionHistoryForm.message((String)"xmlui.Version.versionhistory.trail");
    private static final Message T_title = AutoVersionHistoryForm.message((String)"xmlui.administrative.version.ManageVersionMain.title");
    private static final Message T_version_trail = AutoVersionHistoryForm.message((String)"xmlui.administrative.version.general.version_trail");
    private static final Message T_go = AutoVersionHistoryForm.message((String)"xmlui.general.go");
    private static final int PAGE_SIZE = 15;
    private static Logger log = Logger.getLogger(AutoVersionHistoryForm.class);

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        boolean isItemView;
        boolean bl = isItemView = this.parameters.getParameterAsInteger("itemID", -1) != -1;
        if (isItemView) {
            Item item = this.getItem();
            AutoVersionHistory versionHistory = this.retrieveVersionHistory(item);
            if (versionHistory != null && !versionHistory.getLatestVersion().getItem().equals((Object)item)) {
                item = versionHistory.getLatestVersion().getItem();
            }
            if (item != null) {
                String title = item.getMetadata("dc.title");
                pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
                HandleUtil.buildHandleTrail((DSpaceObject)item, (PageMeta)pageMeta, (String)this.contextPath);
                if (title != null && title.length() > 0) {
                    pageMeta.addTrailLink(this.contextPath + "/handle/" + item.getHandle(), title);
                } else {
                    pageMeta.addTrail().addContent("Item");
                }
                pageMeta.addTrail().addContent(T_trail);
            } else {
                pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
                pageMeta.addTrail().addContent(T_trail);
            }
        } else {
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
            pageMeta.addTrail().addContent("Versions");
        }
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        boolean isItemView = this.parameters.getParameterAsInteger("itemID", -1) != -1;
        boolean isAdmin = AuthorizeManager.isAdmin((Context)this.context);
        if (isItemView) {
            Item item = this.getItem();
            AutoVersionHistory versionHistory = this.retrieveVersionHistory(item);
            AutoVersion v = versionHistory.getLatestVersion();
            Item i = v.getItem();
            i.equals((Object)item);
            if (versionHistory != null && !versionHistory.getLatestVersion().getItem().equals((Object)item)) {
                item = versionHistory.getLatestVersion().getItem();
            }
            if ((item == null || !AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)item.getOwningCollection())) && ((Boolean)new DSpace().getConfigurationService().getPropertyAsType("versioning.item.history.view.admin", (Object)false)).booleanValue()) {
                return;
            }
            if (versionHistory != null) {
                Division main = this.createMain(body);
                this.createTableForItem(main, versionHistory, isAdmin);
                if (isAdmin) {
                    this.addButtons(main);
                    main.addHidden("versioning-continue").setValue(this.knot.getId());
                }
                Para note = main.addPara();
                note.addContent(T_legend);
            }
        }
    }

    private Item getItem() throws WingException {
        try {
            if (this.parameters.getParameterAsInteger("itemID", -1) == -1) {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (!(dso instanceof Item)) {
                    return null;
                }
                return (Item)dso;
            }
            return Item.find((Context)this.context, (int)this.parameters.getParameterAsInteger("itemID", -1));
        }
        catch (SQLException e) {
            throw new WingException((Throwable)e);
        }
    }

    private AutoVersionHistory retrieveVersionHistory(Item item) throws WingException {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (item == null) {
            return null;
        }
        return versioningService.findAutoVersionHistory(this.context, item.getID());
    }

    private Division createMain(Body body) throws WingException {
        Division main = body.addInteractiveDivision("view-verion-history", this.contextPath + "/item/versionhistory", "post", "view version history");
        main.setHead(T_head2);
        return main;
    }

    private void createVersionHistoryRow(Table table, AutoVersion version, boolean isLatestVersion, boolean isAdmin) throws WingException {
        Row row = table.addRow(null, "data", "metadata-value");
        if (isAdmin && !isLatestVersion) {
            CheckBox remove = row.addCell().addCheckBox("remove");
            remove.setLabel("remove");
            remove.addOption(version.getVersionId());
        } else {
            row.addCell();
        }
        row.addCell().addXref(this.contextPath + "/item/versionhistory?versioning-continue=" + this.knot.getId() + "&versionID=" + version.getVersionId() + "&itemID=" + version.getItemID() + "&submit_show", Integer.toString(version.getVersionId()));
        row.addCell().addContent(Integer.toString(version.getVersionNumber()));
        if (version.getItem() != null && isLatestVersion) {
            row.addCell().addXref("/handle/" + version.getHandle(), version.getHandle() + "*");
        } else {
            row.addCell().addContent(version.getHandle());
        }
        row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
        row.addCell("summary", "data", "version-summary").addContent(version.getSummary());
        if (isAdmin) {
            Cell actionRow = row.addCell("actions", "data", "actions");
            String[] versionViewLink = version.getViewVersionLink(this.context, this.knot.getId(), this.contextPath, isLatestVersion);
            if (versionViewLink[0] != null && versionViewLink[0].length() > 0) {
                actionRow.addXref(versionViewLink[0], versionViewLink[1]);
            } else {
                actionRow.addContent(versionViewLink[1]);
            }
            String[] restorelink = version.getRestoreVersionLink(this.context, this.knot.getId(), this.contextPath, isLatestVersion);
            if (restorelink[0] != null && restorelink[0].length() > 0) {
                actionRow.addXref(restorelink[0], restorelink[1]);
            } else {
                actionRow.addContent(restorelink[1]);
            }
            actionRow.addXref(this.contextPath + "/item/versionhistory?versioning-continue=" + this.knot.getId() + "&versionID=" + version.getVersionId() + "&itemID=" + version.getItemID() + "&submit_update", T_submit_update);
        }
    }

    private void createTableForItem(Division main, AutoVersionHistory history, boolean isAdmin) throws WingException, SQLException {
        Table table = main.addTable("versionhistory", 1, 1);
        this.createTableHeader(table, isAdmin);
        if (history != null) {
            for (AutoVersion version : history.getVersions()) {
                if (version.getItem() != null && this.isItemInSubmission(version.getItem())) continue;
                boolean isLatestVersion = false;
                if (version.getVersionNumber() == history.getLatestVersion().getVersionNumber()) {
                    isLatestVersion = true;
                }
                this.createVersionHistoryRow(table, version, isLatestVersion, isAdmin);
            }
        }
    }

    private void createTableHeader(Table table, Boolean isAdmin) throws WingException {
        Row header = table.addRow("header");
        if (isAdmin.booleanValue()) {
            header.addCell().addContent("");
        }
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        header.addCell().addContent(T_column4);
        header.addCell().addContent(T_column5);
        header.addCell("actions", "header", "actions").addContent(T_column6);
    }

    private boolean isItemInSubmission(Item item) throws SQLException {
        WorkspaceItem workspaceItem = WorkspaceItem.findByItem((Context)this.context, (Item)item);
        Object workflowItem = ConfigurationManager.getProperty((String)"workflow", (String)"workflow.framework").equals("xmlworkflow") ? XmlWorkflowItem.findByItem((Context)this.context, (Item)item) : WorkflowItem.findByItem((Context)this.context, (Item)item);
        return workspaceItem != null || workflowItem != null;
    }

    private void addButtons(Division main) throws WingException {
        Para actions = main.addPara();
        actions.addButton("submit_delete").setValue(T_submit_delete);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
    }
}

