/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.autoversioning;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.autoversioning.AutoVersionHistoryForm;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersionDAO;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.DCDate;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;

public class ManageAutoVersionMain
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(AutoVersionHistoryForm.class);
    private static final Message T_title = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.title");
    private static final Message T_version_trail = ManageAutoVersionMain.message((String)"xmlui.administrative.version.general.version_trail");
    private static final Message T_main_head = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.main_head");
    private static final Message T_actions_head = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.actions_head");
    private static final Message T_actions_create = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.actions_create");
    private static final Message T_actions_create_link = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.actions_create_link");
    private static final Message T_actions_browse = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.actions_browse");
    private static final Message T_actions_browse_link = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.actions_browse_link");
    private static final Message T_actions_search = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.actions_search");
    private static final Message T_search_help = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_help");
    private static final Message T_dspace_home = ManageAutoVersionMain.message((String)"xmlui.general.dspace_home");
    private static final Message T_go = ManageAutoVersionMain.message((String)"xmlui.general.go");
    private static final Message T_search_head = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_head");
    private static final Message T_search_column0 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column0");
    private static final Message T_search_column1 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column1");
    private static final Message T_search_column2 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column2");
    private static final Message T_search_column3 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column3");
    private static final Message T_search_column4 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column4");
    private static final Message T_search_column5 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column5");
    private static final Message T_search_column6 = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.search_column6");
    private static final Message T_submit_delete = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.submit_delete");
    private static final Message T_no_results = ManageAutoVersionMain.message((String)"xmlui.administrative.version.ManageVersionMain.no_results");
    private static final Message T_submit_update = ManageAutoVersionMain.message((String)"xmlui.aspect.versioning.VersionHistoryForm.update");
    private static final int PAGE_SIZE = 15;

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(null, T_version_trail);
    }

    public void addBody(Body body) throws WingException, SQLException {
        int page = this.parameters.getParameterAsInteger("page", 0);
        int highlightID = this.parameters.getParameterAsInteger("highlightID", -1);
        String query = ManageAutoVersionMain.decodeFromURL((String)this.parameters.getParameter("query", null));
        String baseURL = this.contextPath + "/admin/versions?administrative-continue=" + this.knot.getId();
        int resultCount = AutoVersionDAO.searchResultCount((Context)this.context, (String)query);
        AutoVersion[] versions = AutoVersionDAO.search((Context)this.context, (String)query, (int)(page * 15), (int)15);
        boolean isAdmin = AuthorizeManager.isAdmin((Context)this.context);
        Division main = body.addInteractiveDivision("version-main", this.contextPath + "/admin/versions", "post", "primary administrative version");
        main.setHead(T_main_head);
        Division actions = main.addDivision("versions-actions");
        actions.setHead(T_actions_head);
        List actionsList = actions.addList("actions");
        actionsList.addLabel(T_actions_browse);
        actionsList.addItemXref(baseURL + "&query&submit_search", T_actions_browse_link);
        actionsList.addLabel(T_actions_search);
        Item actionItem = actionsList.addItem();
        Text queryField = actionItem.addText("query");
        queryField.setAutofocus("autofocus");
        if (query != null) {
            queryField.setValue(query);
        }
        queryField.setHelp(T_search_help);
        actionItem.addButton("submit_search").setValue(T_go);
        Division search = main.addDivision("version-search");
        search.setHead(T_search_head);
        if (resultCount > 15) {
            int firstIndex = page * 15 + 1;
            int lastIndex = page * 15 + versions.length;
            String nextURL = null;
            String prevURL = null;
            if (page < resultCount / 15) {
                nextURL = baseURL + "&page=" + (page + 1);
            }
            if (page > 0) {
                prevURL = baseURL + "&page=" + (page - 1);
            }
            search.setSimplePagination(resultCount, firstIndex, lastIndex, prevURL, nextURL);
        }
        Table table = search.addTable("versionhistory", 1, 1);
        this.createTableHeader(table, isAdmin);
        AutoVersionHistory vh = null;
        for (AutoVersion version : versions) {
            if (vh == null || version.getVersionHistoryID() != vh.getVersionHistoryId()) {
                vh = this.retrieveVersionHistory(version.getVersionHistoryID());
            }
            boolean isLatestVersion = version.isLastestVersion(this.context, vh);
            this.createVersionHistoryRow(table, version, isLatestVersion, isAdmin);
        }
        if (versions.length <= 0) {
            Cell cell = table.addRow().addCell(1, 4);
            cell.addHighlight("italic").addContent(T_no_results);
        } else {
            search.addPara().addButton("submit_delete").setValue(T_submit_delete);
        }
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void createTableHeader(Table table, Boolean isAdmin) throws WingException {
        Row header = table.addRow("header");
        header.addCell().addContent(T_search_column0);
        header.addCell().addContent(T_search_column1);
        header.addCell().addContent(T_search_column2);
        header.addCell().addContent(T_search_column3);
        header.addCell().addContent(T_search_column4);
        header.addCell().addContent(T_search_column5);
        header.addCell("actions", "header", "actions").addContent(T_search_column6);
    }

    private AutoVersionHistory retrieveVersionHistory(Integer versionHistoryId) throws WingException {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (versionHistoryId == null) {
            return null;
        }
        return versioningService.findVersionByHistoryId(this.context, versionHistoryId.intValue());
    }

    private void createVersionHistoryRow(Table table, AutoVersion version, boolean isLatestVersion, boolean isAdmin) throws WingException {
        Row row = table.addRow(null, "data", "metadata-value");
        if (isAdmin && !isLatestVersion) {
            CheckBox remove = row.addCell().addCheckBox("remove");
            remove.setLabel("remove");
            remove.addOption(version.getVersionId());
        } else {
            row.addCell();
        }
        row.addCell().addXref(this.contextPath + "/item/versionhistory?versioning-continue=" + this.knot.getId() + "&versionID=" + version.getVersionId() + "&itemID=" + version.getItemID() + "&submit_show", Integer.toString(version.getVersionId()));
        row.addCell().addContent(Integer.toString(version.getVersionHistoryID()) + ':' + Integer.toString(version.getVersionNumber()));
        if (version.getItem() != null && isLatestVersion) {
            row.addCell().addXref("/handle/" + version.getHandle(), version.getHandle() + "*");
        } else {
            row.addCell().addContent(version.getHandle());
        }
        row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
        row.addCell("summary", "data", "version-summary").addContent(version.getSummary());
        if (isAdmin) {
            Cell actionRow = row.addCell("actions", "data", "actions");
            String[] versionViewLink = version.getViewVersionLink(this.context, this.knot.getId(), this.contextPath, isLatestVersion);
            if (versionViewLink[0] != null && versionViewLink[0].length() > 0) {
                actionRow.addXref(versionViewLink[0], versionViewLink[1]);
            } else {
                actionRow.addContent(versionViewLink[1]);
            }
            String[] restorelink = version.getRestoreVersionLink(this.context, this.knot.getId(), this.contextPath, isLatestVersion);
            if (restorelink[0] != null && restorelink[0].length() > 0) {
                actionRow.addXref(restorelink[0], restorelink[1]);
            } else {
                actionRow.addContent(restorelink[1]);
            }
            boolean canEditSummary = version.canEditSummary(this.context, this.knot.getId(), this.contextPath, isLatestVersion);
            if (canEditSummary) {
                actionRow.addXref(this.contextPath + "/item/versionhistory?versioning-continue=" + this.knot.getId() + "&versionID=" + version.getVersionId() + "&itemID=" + version.getItemID() + "&submit_update", T_submit_update);
            } else {
                actionRow.addContent("");
            }
        }
    }
}

