/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.autoversioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.autoversioning.AutoVersionHistory;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer {
    private static final Message T_context_head = Navigation.message((String)"xmlui.administrative.Navigation.context_head");
    private static final Message T_context_create_version = Navigation.message((String)"xmlui.aspect.versioning.VersioningNavigation.context_create_version");
    private static final Message T_context_show_version_history = Navigation.message((String)"xmlui.aspect.versioning.VersioningNavigation.context_show_version_history");

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("discovery");
        options.addList("browse");
        options.addList("account");
        List content = options.addList("context");
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso == null) {
            dso = this.getItemById();
        }
        if (dso != null && dso.getType() == 2) {
            Item item = (Item)dso;
            AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
            boolean canVersion = versioningService.canVersion(this.context, item);
            if (canVersion && item.isArchived()) {
                boolean headAdded = true;
                content.setHead(T_context_head);
                content.addItem().addXref(this.contextPath + "/submit?itemID=" + item.getID() + "&version=create", T_context_create_version);
                if (this.hasVersionHistory(item) && item.canEdit()) {
                    content.addItem().addXref(this.contextPath + "/item/versionhistory?itemID=" + item.getID(), T_context_show_version_history);
                }
            }
        } else if (AuthorizeManager.isAdmin((Context)this.context)) {
            List admin = options.addList("administrative");
            admin.setHead("Administrative");
            List version = admin.addList("versions");
            version.setHead("Version");
            version.addItem().addXref(this.contextPath + "/admin/versions", "Manage Versions");
        }
    }

    private Item getItemById() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Item item = null;
        int itemId = Util.getIntParameter((HttpServletRequest)request, (String)"itemID");
        if (itemId != -1) {
            item = Item.find((Context)this.context, (int)itemId);
        }
        return item;
    }

    private boolean isLatest(Item item) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        AutoVersionHistory history = versioningService.findAutoVersionHistory(this.context, item.getID());
        return history == null || history.getLatestVersion().getItem().getID() == item.getID();
    }

    private boolean hasVersionHistory(Item item) {
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        AutoVersionHistory history = versioningService.findAutoVersionHistory(this.context, item.getID());
        return history != null;
    }
}

