/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.autoversioning;

import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.autoversioning.AutoVersion;
import org.dspace.autoversioning.AutoVersioningService;
import org.dspace.content.DCDate;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;

public class RestoreAutoVersionForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = RestoreAutoVersionForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_item_trail = RestoreAutoVersionForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_title = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.title");
    private static final Message T_trail = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.trail");
    private static final Message T_head1 = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.head1");
    private static final Message T_para1 = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.para1");
    private static final Message T_column1 = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column1");
    private static final Message T_column2 = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column2");
    private static final Message T_column3 = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column3");
    private static final Message T_column4 = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column4");
    private static final Message T_submit_restore = RestoreAutoVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.restore");
    private static final Message T_submit_cancel = RestoreAutoVersionForm.message((String)"xmlui.general.cancel");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, AuthorizeException {
        Division main = this.createMainDivision(body);
        this.createTable(main);
        this.addButtons(main);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Division createMainDivision(Body body) throws WingException {
        Division main = body.addInteractiveDivision("restore-version", this.contextPath + "/item/versionhistory", "post", "restore version");
        main.setHead(T_head1);
        main.addPara(T_para1);
        return main;
    }

    private void createTable(Division main) throws WingException {
        String id = this.parameters.getParameter("versionID", null);
        Table table = main.addTable("version", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        AutoVersioningService versioningService = (AutoVersioningService)new DSpace().getSingletonService(VersioningService.class);
        AutoVersion version = versioningService.getAutoVersion(this.context, Integer.parseInt(id));
        Row row = table.addRow();
        row.addCell().addContent(version.getVersionNumber());
        row.addCell().addContent(version.getEperson().getEmail());
        row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
        row.addCell().addContent(version.getSummary());
        List fields = main.addList("fields", "form");
        Composite addComposite = fields.addItem().addComposite("summary");
        addComposite.setLabel(T_column4);
        addComposite.addTextArea("summary");
    }

    private void addButtons(Division main) throws WingException {
        Para buttons = main.addPara();
        buttons.addButton("submit_restore").setValue(T_submit_restore);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
    }
}

