/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.objectmanager.SAXFilter;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.core.Context;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BitstreamAdapter
extends AbstractAdapter {
    private Bitstream bitstream;
    private Context context;

    public BitstreamAdapter(Context context, Bitstream bitstream, String contextPath) {
        super(contextPath);
        this.bitstream = bitstream;
        this.context = context;
    }

    protected String getMETSOBJID() {
        if (this.bitstream.getHandle() != null) {
            return this.contextPath + "/handle/" + this.bitstream.getHandle();
        }
        return null;
    }

    protected String getMETSOBJEDIT() {
        return this.contextPath + "/admin/bitstream?bitstreamID=" + this.bitstream.getID();
    }

    protected String getMETSID() {
        if (this.bitstream.getHandle() == null) {
            return "bitstream:" + this.bitstream.getID();
        }
        return "hdl:" + this.bitstream.getHandle();
    }

    protected String getMETSProfile() throws WingException {
        return "DSPACE METS SIP Profile 1.0";
    }

    protected String getMETSLabel() {
        return "DSpace Item";
    }

    public void renderMETS(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        try {
            SAXFilter filter = new SAXFilter(contentHandler, lexicalHandler, this.namespaces);
            filter.allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
            filter.allowElements(-1);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler((ContentHandler)filter);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", filter);
            reader.parse(new InputSource(this.bitstream.retrieve()));
        }
        catch (AuthorizeException authorizeException) {
            // empty catch block
        }
    }
}

