/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.bitstore;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class BitstreamStorageOutputStream
extends DigestOutputStream {
    private static Logger log = Logger.getLogger(BitstreamStorageOutputStream.class);
    private TableRow bitstream = null;
    private Context context = null;
    private long count = 0L;
    private static final String CSA = "MD5";
    boolean closed;
    private Map attrs = new HashMap();

    public BitstreamStorageOutputStream(Context context, TableRow bitstream, OutputStream proxy) throws NoSuchAlgorithmException {
        super(proxy, MessageDigest.getInstance(CSA));
        this.bitstream = bitstream;
        this.context = context;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
        this.attrs.put("size_bytes", this.getByteCount());
        this.attrs.put("checksum", Utils.toHex((byte[])this.getMessageDigest().digest()));
        this.attrs.put("checksum_algorithm", CSA);
        BitstreamStorageOutputStream.updateBitstream(this.bitstream, this.attrs);
        this.bitstream.setColumn("deleted", false);
        try {
            DatabaseManager.update((Context)this.context, (TableRow)this.bitstream);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        int bitstream_id = this.bitstream.getIntColumn("bitstream_id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored bitstream " + bitstream_id + " under id " + this.bitstream.getStringColumn("internal_id")));
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"create_bitstream", (String)("bitstream_id=" + bitstream_id)));
        this.context.addEvent(new Event(1, 0, bitstream_id, null));
    }

    public int getBitstreamID() {
        return this.bitstream.getIntColumn("bitstream_id");
    }

    public void setAttribute(String name, Object value) {
        this.attrs.put(name, value);
    }

    @Override
    public void write(int idx) throws IOException {
        ++this.count;
        super.write(idx);
    }

    @Override
    public void write(byte[] bts) throws IOException {
        this.count += bts != null ? (long)bts.length : 0L;
        super.write(bts);
    }

    @Override
    public void write(byte[] bts, int st, int end) throws IOException {
        this.count += (long)end;
        super.write(bts, st, end);
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    protected static void updateBitstream(TableRow bitstream, Map attrs) throws IOException {
        for (String column : attrs.keySet()) {
            Object value;
            Object val = attrs.get(column);
            if (val == null) continue;
            if (val instanceof String) {
                value = (String)val;
                bitstream.setColumn(column, (String)value);
            }
            if (val instanceof Long) {
                value = (Long)val;
                bitstream.setColumn(column, ((Long)value).longValue());
            }
            if (val instanceof Integer) {
                value = (Integer)val;
                bitstream.setColumn(column, ((Integer)value).intValue());
            }
            if (val instanceof Boolean) {
                value = (Boolean)val;
                bitstream.setColumn(column, ((Boolean)value).booleanValue());
            }
            if (!(val instanceof Date)) continue;
            value = (Date)val;
            bitstream.setColumn(column, (Date)value);
        }
    }
}

