/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.bitstore;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileOutputStream;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.bitstore.BitstreamStorageOutputStream;
import org.dspace.checker.BitstreamInfoDAO;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class ExtendedBitstreamStorageManager {
    private static Logger log = Logger.getLogger(ExtendedBitstreamStorageManager.class);
    private static GeneralFile[] assetStores;
    private static int incoming;
    private static final int digitsPerLevel = 2;
    private static final int directoryLevels = 3;
    private static final String REGISTERED_FLAG = "-R";

    public static int store(Context context, InputStream is) throws SQLException, IOException {
        TableRow bitstream;
        String id = Utils.generateKey();
        Context tempContext = null;
        try {
            tempContext = new Context();
            bitstream = DatabaseManager.row((String)"Bitstream");
            bitstream.setColumn("deleted", true);
            bitstream.setColumn("internal_id", id);
            bitstream.setColumn("store_number", incoming);
            DatabaseManager.insert((Context)tempContext, (TableRow)bitstream);
            tempContext.complete();
        }
        catch (SQLException sqle) {
            if (tempContext != null) {
                tempContext.abort();
            }
            throw sqle;
        }
        GeneralFile file = ExtendedBitstreamStorageManager.getFile(bitstream);
        GeneralFile parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        GeneralFileOutputStream fos = FileFactory.newFileOutputStream((GeneralFile)file);
        DigestInputStream dis = null;
        try {
            dis = new DigestInputStream(is, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException nsae) {
            log.warn((Object)"Caught NoSuchAlgorithmException", (Throwable)nsae);
        }
        Utils.bufferedCopy((InputStream)dis, (OutputStream)fos);
        fos.close();
        is.close();
        bitstream.setColumn("size_bytes", file.length());
        if (dis != null) {
            bitstream.setColumn("checksum", Utils.toHex((byte[])dis.getMessageDigest().digest()));
            bitstream.setColumn("checksum_algorithm", "MD5");
        }
        bitstream.setColumn("deleted", false);
        DatabaseManager.update((Context)context, (TableRow)bitstream);
        int bitstreamId = bitstream.getIntColumn("bitstream_id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored bitstream " + bitstreamId + " in file " + file.getAbsolutePath()));
        }
        return bitstreamId;
    }

    public static BitstreamStorageOutputStream store(Context context) throws SQLException, IOException, NoSuchAlgorithmException {
        return ExtendedBitstreamStorageManager.store(context, (BitstreamFormat)null);
    }

    public static BitstreamStorageOutputStream store(Context context, BitstreamFormat format) throws SQLException, IOException, NoSuchAlgorithmException {
        TableRow bitstream;
        String id = Utils.generateKey();
        Context tempContext = null;
        try {
            tempContext = new Context();
            bitstream = DatabaseManager.create((Context)tempContext, (String)"Bitstream");
            bitstream.setColumn("deleted", true);
            bitstream.setColumn("internal_id", id);
            if (format != null) {
                bitstream.setColumn("bitstream_format_id", format.getID());
            } else {
                bitstream.setColumn("bitstream_format_id", BitstreamFormat.findUnknown((Context)context).getID());
                bitstream.setColumnNull("user_format_description");
            }
            bitstream.setColumn("store_number", incoming);
            DatabaseManager.update((Context)tempContext, (TableRow)bitstream);
            tempContext.complete();
        }
        catch (SQLException sqle) {
            if (tempContext != null) {
                tempContext.abort();
            }
            throw sqle;
        }
        GeneralFile file = ExtendedBitstreamStorageManager.getFile(bitstream);
        GeneralFile parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        GeneralFileOutputStream fos = FileFactory.newFileOutputStream((GeneralFile)file);
        return new BitstreamStorageOutputStream(context, bitstream, (OutputStream)fos);
    }

    public static int register(Context context, int assetstore, String bitstreamPath) throws SQLException, IOException {
        TableRow bitstream;
        String sInternalId = REGISTERED_FLAG + bitstreamPath;
        Context tempContext = null;
        try {
            tempContext = new Context();
            bitstream = DatabaseManager.row((String)"Bitstream");
            bitstream.setColumn("deleted", true);
            bitstream.setColumn("internal_id", sInternalId);
            bitstream.setColumn("store_number", assetstore);
            DatabaseManager.insert((Context)tempContext, (TableRow)bitstream);
            tempContext.complete();
        }
        catch (SQLException sqle) {
            if (tempContext != null) {
                tempContext.abort();
            }
            throw sqle;
        }
        GeneralFile file = ExtendedBitstreamStorageManager.getFile(bitstream);
        if (file instanceof LocalFile) {
            int count;
            DigestInputStream dis = null;
            try {
                dis = new DigestInputStream((InputStream)FileFactory.newFileInputStream((GeneralFile)file), MessageDigest.getInstance("MD5"));
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)"Caught NoSuchAlgorithmException", (Throwable)e);
                throw new IOException("Invalid checksum algorithm", e);
            }
            catch (IOException e) {
                log.error((Object)("File: " + file.getAbsolutePath() + " to be registered cannot be opened - is it " + "really there?"));
                throw e;
            }
            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[4096];
            while ((count = dis.read(buffer, 0, 4096)) != -1) {
            }
            bitstream.setColumn("checksum", Utils.toHex((byte[])dis.getMessageDigest().digest()));
            dis.close();
        } else if (file instanceof SRBFile) {
            if (!file.exists()) {
                log.error((Object)("File: " + file.getAbsolutePath() + " is not in SRB MCAT"));
                throw new IOException("File is not in SRB MCAT");
            }
            int iLastSlash = bitstreamPath.lastIndexOf(47);
            String sFilename = bitstreamPath.substring(iLastSlash + 1);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Caught NoSuchAlgorithmException", (Throwable)e);
                throw new IOException("Invalid checksum algorithm", e);
            }
            bitstream.setColumn("checksum", Utils.toHex((byte[])md.digest(sFilename.getBytes())));
        } else {
            throw new IOException("Unrecognized file type - not local, not SRB");
        }
        bitstream.setColumn("checksum_algorithm", "MD5");
        bitstream.setColumn("size_bytes", file.length());
        bitstream.setColumn("deleted", false);
        DatabaseManager.update((Context)context, (TableRow)bitstream);
        int bitstreamId = bitstream.getIntColumn("bitstream_id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored bitstream " + bitstreamId + " in file " + file.getAbsolutePath()));
        }
        return bitstreamId;
    }

    public static boolean isRegisteredBitstream(String internalId) {
        return internalId.substring(0, REGISTERED_FLAG.length()).equals(REGISTERED_FLAG);
    }

    public static InputStream retrieve(Context context, int id) throws SQLException, IOException {
        TableRow bitstream = DatabaseManager.find((Context)context, (String)"bitstream", (int)id);
        GeneralFile file = ExtendedBitstreamStorageManager.getFile(bitstream);
        return file != null ? FileFactory.newFileInputStream((GeneralFile)file) : null;
    }

    public static void delete(Context context, int id) throws SQLException {
        DatabaseManager.updateQuery((Context)context, (String)"update Bundle set primary_bitstream_id=null where primary_bitstream_id = ? ", (Object[])new Object[]{id});
        DatabaseManager.updateQuery((Context)context, (String)"update Bitstream set deleted = '1' where bitstream_id = ? ", (Object[])new Object[]{id});
    }

    public static void cleanup(Context context, int id, boolean deleteDbRecords, boolean verbose) throws SQLException, IOException {
        TableRow bitstream = DatabaseManager.find((Context)context, (String)"bitstream", (int)id);
        int bid = bitstream.getIntColumn("bitstream_id");
        GeneralFile file = ExtendedBitstreamStorageManager.getFile(bitstream);
        BitstreamInfoDAO bitstreamInfoDAO = new BitstreamInfoDAO();
        if (ExtendedBitstreamStorageManager.isRecent(file)) {
            log.debug((Object)"file is recent");
            return;
        }
        if (deleteDbRecords) {
            log.debug((Object)"deleting db record");
            if (verbose) {
                System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
            }
            bitstreamInfoDAO.deleteBitstreamInfoWithHistory(bid);
            if (verbose) {
                System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
            }
            DatabaseManager.delete((Context)context, (String)"Bitstream", (int)bid);
        }
        if (ExtendedBitstreamStorageManager.isRegisteredBitstream(bitstream.getStringColumn("internal_id"))) {
            return;
        }
        TableRow duplicateBitRow = DatabaseManager.querySingleTable((Context)context, (String)"Bitstream", (String)"SELECT * FROM Bitstream WHERE internal_id = ? AND bitstream_id <> ?", (Object[])new Object[]{bitstream.getStringColumn("internal_id"), bid});
        if (duplicateBitRow == null) {
            boolean success = file.delete();
            String message = "Deleted bitstream " + bid + " (file " + file.getAbsolutePath() + ") with result " + success;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            if (verbose) {
                System.out.println(message);
            }
            if (success) {
                ExtendedBitstreamStorageManager.deleteParents(file);
            }
        }
        System.out.print("Transaction will still need to be commited");
    }

    public static void cleanup(boolean deleteDbRecords, boolean verbose) throws SQLException, IOException {
        Context context = null;
        BitstreamInfoDAO bitstreamInfoDAO = new BitstreamInfoDAO();
        int commitCounter = 0;
        try {
            context = new Context();
            String myQuery = "select * from Bitstream where deleted = '1'";
            List storage = DatabaseManager.queryTable((Context)context, (String)"Bitstream", (String)myQuery, (Object[])new Object[0]).toList();
            for (TableRow row : storage) {
                int bid = row.getIntColumn("bitstream_id");
                GeneralFile file = ExtendedBitstreamStorageManager.getFile(row);
                if (file == null || !file.exists()) {
                    log.debug((Object)"file is null");
                    if (!deleteDbRecords) continue;
                    log.debug((Object)"deleting record");
                    if (verbose) {
                        System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                    }
                    bitstreamInfoDAO.deleteBitstreamInfoWithHistory(bid);
                    if (verbose) {
                        System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                    }
                    DatabaseManager.delete((Context)context, (String)"Bitstream", (int)bid);
                    continue;
                }
                if (ExtendedBitstreamStorageManager.isRecent(file)) {
                    log.debug((Object)"file is recent");
                    continue;
                }
                if (deleteDbRecords) {
                    log.debug((Object)"deleting db record");
                    if (verbose) {
                        System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                    }
                    bitstreamInfoDAO.deleteBitstreamInfoWithHistory(bid);
                    if (verbose) {
                        System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                    }
                    DatabaseManager.delete((Context)context, (String)"Bitstream", (int)bid);
                }
                if (ExtendedBitstreamStorageManager.isRegisteredBitstream(row.getStringColumn("internal_id"))) continue;
                TableRow duplicateBitRow = DatabaseManager.querySingleTable((Context)context, (String)"Bitstream", (String)"SELECT * FROM Bitstream WHERE internal_id = ? AND bitstream_id <> ?", (Object[])new Object[]{row.getStringColumn("internal_id"), bid});
                if (duplicateBitRow == null) {
                    boolean success = file.delete();
                    String message = "Deleted bitstream " + bid + " (file " + file.getAbsolutePath() + ") with result " + success;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)message);
                    }
                    if (verbose) {
                        System.out.println(message);
                    }
                    if (success) {
                        ExtendedBitstreamStorageManager.deleteParents(file);
                    }
                }
                if (++commitCounter % 100 != 0) continue;
                System.out.print("Committing changes to the database...");
                context.commit();
                System.out.println(" Done!");
            }
            context.complete();
        }
        catch (SQLException sqle) {
            if (verbose) {
                System.err.println("Error: " + sqle.getMessage());
            }
            context.abort();
            throw sqle;
        }
        catch (IOException ioe) {
            if (verbose) {
                System.err.println("Error: " + ioe.getMessage());
            }
            context.abort();
            throw ioe;
        }
    }

    public static int clone(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find((Context)context, (String)"bitstream", (int)id);
        row.setColumn("bitstream_id", -1);
        DatabaseManager.insert((Context)context, (TableRow)row);
        return row.getIntColumn("bitstream_id");
    }

    private static boolean isRecent(GeneralFile file) {
        long now;
        long lastmod = file.lastModified();
        if (lastmod >= (now = new Date().getTime())) {
            return true;
        }
        return now - lastmod < 60000L;
    }

    private static synchronized void deleteParents(GeneralFile file) {
        GeneralFile directory;
        GeneralFile[] files;
        if (file == null) {
            return;
        }
        GeneralFile tmp = file;
        for (int i = 0; i < 3 && (files = (directory = tmp.getParentFile()).listFiles()).length == 0; ++i) {
            directory.delete();
            tmp = directory;
        }
    }

    private static GeneralFile getFile(TableRow bitstream) throws IOException {
        if (bitstream == null) {
            return null;
        }
        int storeNumber = bitstream.getIntColumn("store_number");
        if (storeNumber == -1) {
            storeNumber = 0;
        }
        GeneralFile assetstore = assetStores[storeNumber];
        String sInternalId = bitstream.getStringColumn("internal_id");
        String sIntermediatePath = null;
        if (ExtendedBitstreamStorageManager.isRegisteredBitstream(sInternalId)) {
            sInternalId = sInternalId.substring(REGISTERED_FLAG.length());
            sIntermediatePath = "";
        } else {
            if (sInternalId.indexOf(File.separator) != -1) {
                sInternalId = sInternalId.substring(sInternalId.lastIndexOf(File.separator) + 1);
            }
            sIntermediatePath = ExtendedBitstreamStorageManager.getIntermediatePath(sInternalId);
        }
        StringBuffer bufFilename = new StringBuffer();
        if (assetstore instanceof LocalFile) {
            bufFilename.append(assetstore.getCanonicalPath());
            bufFilename.append(File.separator);
            bufFilename.append(sIntermediatePath);
            bufFilename.append(sInternalId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local filename for " + sInternalId + " is " + bufFilename.toString()));
            }
            return new LocalFile(bufFilename.toString());
        }
        if (assetstore instanceof SRBFile) {
            bufFilename.append(sIntermediatePath);
            bufFilename.append(sInternalId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SRB filename for " + sInternalId + " is " + ((SRBFile)assetstore).toString() + bufFilename.toString()));
            }
            return new SRBFile((SRBFile)assetstore, bufFilename.toString());
        }
        return null;
    }

    private static String getIntermediatePath(String iInternalId) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            int digits = i * 2;
            if (i > 0) {
                buf.append(File.separator);
            }
            buf.append(iInternalId.substring(digits, digits + 2));
        }
        buf.append(File.separator);
        return buf.toString();
    }

    public static URI getAbsoluteURI(Context context, Bitstream bitstream) {
        if (bitstream == null) {
            return null;
        }
        try {
            TableRow bRow = DatabaseManager.findByUnique((Context)context, (String)"Bitstream", (String)"bitstream_id", (Object)bitstream.getID());
            return ExtendedBitstreamStorageManager.getAbsoluteURI(bRow);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static URI getAbsoluteURI(TableRow bitstream) {
        if (bitstream == null) {
            return null;
        }
        int storeNumber = bitstream.getIntColumn("store_number");
        String iid = bitstream.getStringColumn("internal_id");
        int bitstreamId = bitstream.getIntColumn("bitstream_id");
        String bitstreamName = bitstream.getStringColumn("name");
        return ExtendedBitstreamStorageManager.getAbsoluteURI(storeNumber, iid, bitstreamId, bitstreamName);
    }

    public static URI getAbsoluteURI(int storeNumber, String iid, int bitstreamId, String bitstreamName) {
        if (storeNumber == -1) {
            storeNumber = 0;
        }
        String subspace = "asset";
        if (ExtendedBitstreamStorageManager.isRegisteredBitstream(iid)) {
            iid = iid.substring(REGISTERED_FLAG.length());
            subspace = "registered";
        }
        try {
            if (bitstreamName != null) {
                bitstreamName = URLEncoder.encode(bitstreamName);
            } else {
                bitstreamName = "Unknown";
                log.error((Object)("bitstream file name unknow:bitstream id=" + bitstreamId));
            }
            return URI.create("/bitstream/id/" + bitstreamId + "/" + bitstreamName + "#" + storeNumber + ":" + URLEncoder.encode(iid, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Failed creating URI for bitstream: " + e.toString()));
            return null;
        }
    }

    public static TableRow dereferenceAbsoluteURI(Context context, URI uri) throws IllegalArgumentException, SQLException {
        String path = uri.getPath();
        if (!path.startsWith("/bitstream/id/")) {
            throw new IllegalArgumentException("Path does not start with /bitstream/: " + uri.toString());
        }
        String rest = path.replaceFirst("/bitstream/id/", "");
        String id = rest.substring(0, rest.indexOf("/"));
        return DatabaseManager.find((Context)context, (String)"bitstream", (int)Integer.valueOf(id));
    }

    static {
        ArrayList<String> stores = new ArrayList<String>();
        String sAssetstoreDir = ConfigurationManager.getProperty((String)"assetstore.dir");
        if (sAssetstoreDir != null) {
            stores.add(sAssetstoreDir);
        } else if (ConfigurationManager.getProperty((String)"srb.host") != null) {
            stores.add((String)new SRBAccount(ConfigurationManager.getProperty((String)"srb.host"), ConfigurationManager.getIntProperty((String)"srb.port"), ConfigurationManager.getProperty((String)"srb.username"), ConfigurationManager.getProperty((String)"srb.password"), ConfigurationManager.getProperty((String)"srb.homedirectory"), ConfigurationManager.getProperty((String)"srb.mdasdomainname"), ConfigurationManager.getProperty((String)"srb.defaultstorageresource"), ConfigurationManager.getProperty((String)"srb.mcatzone")));
        } else {
            log.error((Object)"No default assetstore");
        }
        int i = 1;
        while (true) {
            if ((sAssetstoreDir = ConfigurationManager.getProperty((String)("assetstore.dir." + i))) != null) {
                stores.add(sAssetstoreDir);
            } else {
                if (ConfigurationManager.getProperty((String)("srb.host." + i)) == null) break;
                stores.add((String)new SRBAccount(ConfigurationManager.getProperty((String)("srb.host." + i)), ConfigurationManager.getIntProperty((String)("srb.port." + i)), ConfigurationManager.getProperty((String)("srb.username." + i)), ConfigurationManager.getProperty((String)("srb.password." + i)), ConfigurationManager.getProperty((String)("srb.homedirectory." + i)), ConfigurationManager.getProperty((String)("srb.mdasdomainname." + i)), ConfigurationManager.getProperty((String)("srb.defaultstorageresource." + i)), ConfigurationManager.getProperty((String)("srb.mcatzone." + i))));
            }
            ++i;
        }
        assetStores = new GeneralFile[stores.size()];
        for (i = 0; i < stores.size(); ++i) {
            Object o = stores.get(i);
            if (o == null) {
                log.error((Object)("Problem with assetstore " + i));
            }
            if (o instanceof String) {
                ExtendedBitstreamStorageManager.assetStores[i] = new LocalFile((String)o);
                continue;
            }
            if (o instanceof SRBAccount) {
                SRBFileSystem srbFileSystem = null;
                try {
                    srbFileSystem = new SRBFileSystem((SRBAccount)o);
                }
                catch (NullPointerException e) {
                    log.error((Object)("No SRBAccount for assetstore " + i));
                }
                catch (IOException e) {
                    log.error((Object)("Problem getting SRBFileSystem for assetstore" + i));
                }
                if (srbFileSystem == null) {
                    log.error((Object)("SRB FileSystem is null for assetstore " + i));
                }
                String sSRBAssetstore = null;
                sSRBAssetstore = i == 0 ? ConfigurationManager.getProperty((String)"srb.parentdir") : ConfigurationManager.getProperty((String)("srb.parentdir." + i));
                if (sSRBAssetstore == null) {
                    log.error((Object)("srb.parentdir is undefined for assetstore " + i));
                }
                ExtendedBitstreamStorageManager.assetStores[i] = new SRBFile(srbFileSystem, sSRBAssetstore);
                continue;
            }
            log.error((Object)("Unexpected " + o.getClass().toString() + " with assetstore " + i));
        }
        incoming = ConfigurationManager.getIntProperty((String)"assetstore.incoming");
    }
}

