/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.bitstore.ExtendedBitstreamStorageManager;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;

public class BitstreamUtil {
    private static Logger log = Logger.getLogger(BitstreamUtil.class);
    public static String tableName = "versionitem";
    public static String mapTableName = "Version2Bitstream";
    public static String TYPE_ORE = "ore";
    public static String TYPE_AIP = "aip";
    public static String TYPE_CON = "content";

    public static void delete(Context context, Bitstream bitstream, boolean cleanup) throws SQLException, IOException {
        bitstream.delete();
        if (cleanup) {
            ExtendedBitstreamStorageManager.cleanup(context, bitstream.getID(), true, true);
        }
    }

    public static void delete(Bitstream bitstream) throws SQLException {
        bitstream.delete();
    }

    public static boolean isDeleted(Bitstream bitstream) throws SQLException {
        return bitstream.isDeleted();
    }

    public static Date getLastModifiedDate(Context context, Bitstream bitstream) throws SQLException {
        TableRowIterator row = DatabaseManager.query((Context)context, (String)("select * from bitstream where bitstream_id = " + bitstream.getID()), (Object[])new Object[0]);
        if (row.hasNext()) {
            return row.next().getDateColumn("last_modified_date");
        }
        return null;
    }

    public static Date getDateCreated(Context context, Bitstream bitstream) throws SQLException {
        TableRowIterator row = DatabaseManager.query((Context)context, (String)("select * from bitstream where bitstream_id = " + bitstream.getID()), (Object[])new Object[0]);
        if (row.hasNext()) {
            return row.next().getDateColumn("create_date");
        }
        return null;
    }

    public static Version getVersion(Context c, Bitstream b) {
        String query;
        TableRow row = null;
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (BitstreamUtil.getBitstreamType(c, b).equals(TYPE_AIP)) {
            query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (BitstreamUtil.getBitstreamType(c, b).equals(TYPE_ORE)) {
            query = "select * from " + tableName + " where ore_bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            query = "select versionitem.versionitem_id as versionitem_id from versionitem, Version2Bitstream where versionitem.versionitem_id=Version2Bitstream.version_id and Version2Bitstream.bitstream_id = ? order by versionitem.version_number DESC";
            try {
                row = DatabaseManager.querySingle((Context)c, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (row != null) {
            int versionId = row.getIntColumn("versionitem_id");
            Version version = versioningService.getVersion(c, versionId);
            return version;
        }
        return null;
    }

    public static String getBitstreamType(Context c, Bitstream b) {
        TableRow row = null;
        String query = "select * from " + tableName + " where ore_bitstream_id = ?";
        try {
            row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
        }
        catch (Exception e) {
            // empty catch block
        }
        if (row == null) {
            query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row == null) {
                return TYPE_CON;
            }
            return TYPE_AIP;
        }
        return TYPE_ORE;
    }

    public static Bitstream getObsoletedBy(Context c, Bitstream b) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (BitstreamUtil.getBitstreamType(c, b).equals(TYPE_AIP)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                int versionId = row.getIntColumn("versionitem_id");
                Version version = versioningService.getVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                VersionHistory vh = BitstreamUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && vh.hasNext(version)) {
                    Version nextVerison = vh.getNext(version);
                    return nextVerison.getAIPBitstream();
                }
            }
        } else if (BitstreamUtil.getBitstreamType(c, b).equals(TYPE_ORE)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where ore_bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                int versionId = row.getIntColumn("versionitem_id");
                Version version = versioningService.getVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                VersionHistory vh = BitstreamUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && vh.hasNext(version)) {
                    Version nextVerison = vh.getNext(version);
                    return nextVerison.getAIPBitstream();
                }
            }
        } else {
            int versionId;
            Version version;
            VersionHistory vh;
            TableRow row = null;
            String query = "select * from " + mapTableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)mapTableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null && (vh = BitstreamUtil.retrieveVersionHistory(c, (version = versioningService.getVersion(c, versionId = row.getIntColumn("version_id"))).getVersionHistoryID())) != null && vh.hasNext(version)) {
                Version nextVerison = vh.getNext(version);
                return nextVerison.getAIPBitstream();
            }
        }
        return null;
    }

    public static Bitstream getObsoletes(Context c, Bitstream b) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (BitstreamUtil.getBitstreamType(c, b).equals(TYPE_AIP)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                Version preVersion;
                int versionId = row.getIntColumn("versionitem_id");
                Version version = versioningService.getVersion(c, versionId);
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                VersionHistory vh = BitstreamUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && (preVersion = vh.getPrevious(version)) != null) {
                    return preVersion.getAIPBitstream();
                }
            }
        } else if (BitstreamUtil.getBitstreamType(c, b).equals(TYPE_ORE)) {
            TableRow row = null;
            String query = "select * from " + tableName + " where ore_bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)tableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null) {
                Version preVersion;
                int versionHistoryId = row.getIntColumn("versionhistory_id");
                int versionId = row.getIntColumn("versionitem_id");
                Version version = versioningService.getVersion(c, versionId);
                VersionHistory vh = BitstreamUtil.retrieveVersionHistory(c, versionHistoryId);
                if (vh != null && (preVersion = vh.getPrevious(version)) != null) {
                    return preVersion.getOREBitstream();
                }
            }
        } else {
            Version preVersion;
            int versionId;
            Version version;
            VersionHistory vh;
            TableRow row = null;
            String query = "select * from " + mapTableName + " where bitstream_id = ?";
            try {
                row = DatabaseManager.querySingleTable((Context)c, (String)mapTableName, (String)query, (Object[])new Object[]{b.getID()});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row != null && (vh = BitstreamUtil.retrieveVersionHistory(c, (version = versioningService.getVersion(c, versionId = row.getIntColumn("version_id"))).getVersionHistoryID())) != null && (preVersion = vh.getPrevious(version)) != null) {
                return preVersion.getOREBitstream();
            }
        }
        return null;
    }

    private static VersionHistory retrieveVersionHistory(Context c, Integer versionHistoryId) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (versionHistoryId == null) {
            return null;
        }
        return versioningService.findVersionByHistoryId(c, versionHistoryId);
    }
}

