/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.Agent;
import edu.harvard.hul.ois.mets.BinData;
import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.MdRef;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Mptr;
import edu.harvard.hul.ois.mets.Name;
import edu.harvard.hul.ois.mets.Role;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.Type;
import edu.harvard.hul.ois.mets.XmlData;
import edu.harvard.hul.ois.mets.helper.Base64;
import edu.harvard.hul.ois.mets.helper.MdSec;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.PCData;
import edu.harvard.hul.ois.mets.helper.PreformedXML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.bitstore.ExtendedBitstreamStorageManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.crosswalk.AbstractPackagerWrappingCrosswalk;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.packager.AbstractMETSDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;
import org.dspace.license.CreativeCommons;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class InternalDSpaceAIPDisseminator
extends AbstractMETSDisseminator {
    private static final Logger log = Logger.getLogger(InternalDSpaceAIPDisseminator.class);
    public static final String PROFILE_1_0 = "http://www.dspace.org/schema/aip/mets_aip_1_0.xsd";
    public static final String PARENT_DIV_TYPE = "AIP Parent Link";
    private static final String DSPACE_DEPOSIT_LICENSE_MDTYPE = "DSpaceDepositLicense:DSPACE_DEPLICENSE";
    private static final String CREATIVE_COMMONS_RDF_MDTYPE = "CreativeCommonsRDF:DSPACE_CCRDF";
    private static final String CREATIVE_COMMONS_TEXT_MDTYPE = "CreativeCommonsText:DSPACE_CCTXT";
    private PackageParameters disseminateParams = null;
    private List<String> filterBundles = new ArrayList<String>();
    private boolean excludeBundles = true;
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());

    public String makeBitstreamURL(Bitstream bitstream, PackageParameters params) {
        if (params != null && (params.getBooleanProperty("manifestOnly", false) || params.getBooleanProperty("internal", false))) {
            Context context = (Context)params.get((Object)"context");
            if (context == null) {
                return null;
            }
            return ExtendedBitstreamStorageManager.getAbsoluteURI(context, bitstream).toString();
        }
        String base = "bitstream_" + String.valueOf(bitstream.getID());
        String[] ext = bitstream.getFormat().getExtensions();
        return ext.length > 0 ? base + "." + ext[0] : base;
    }

    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, OutputStream outStream) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        this.disseminateParams = params;
        this.resetCounter();
        try {
            Mets manifest = this.makeManifest(context, dso, params, null);
            if (params.getBooleanProperty("validate", true)) {
                manifest.validate(new MetsValidator());
            }
            manifest.write(new MetsWriter(outStream));
        }
        catch (MetsException e) {
            String errorMsg = "Error exporting METS for DSpace Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID());
            log.error((Object)errorMsg, (Throwable)e);
            throw new PackageValidationException(errorMsg, (Exception)((Object)e));
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        this.disseminateParams = params;
        boolean disseminate = true;
        if (this.disseminateParams.containsKey((Object)"updatedAfter") && dso.getType() == 2) {
            Date afterDate = Utils.parseISO8601Date((String)this.disseminateParams.getProperty("updatedAfter"));
            if (afterDate == null) {
                throw new IOException("Invalid date passed in via 'updatedAfter' option. Date must be in ISO-8601 format, and include both a day and time (e.g. 2010-01-01T00:00:00).");
            }
            Item i = (Item)dso;
            disseminate = i.getLastModified().after(afterDate);
        }
        if (disseminate) {
            super.disseminate(context, dso, params, pkgFile);
        }
    }

    public String getProfile() {
        return PROFILE_1_0;
    }

    public String bundleToFileGrp(String bname) {
        return bname;
    }

    public MetsHdr makeMetsHdr(Context context, DSpaceObject dso, PackageParameters params) {
        MetsHdr metsHdr = new MetsHdr();
        if (dso.getType() == 2) {
            metsHdr.setLASTMODDATE(((Item)dso).getLastModified());
        }
        Agent agent = new Agent();
        agent.setROLE(Role.CUSTODIAN);
        agent.setTYPE(Type.OTHER);
        agent.setOTHERTYPE("DSpace Archive");
        Name name = new Name();
        name.getContent().add(new PCData(Site.getSiteHandle()));
        agent.getContent().add(name);
        metsHdr.getContent().add(agent);
        Agent agentCreator = new Agent();
        agentCreator.setROLE(Role.CREATOR);
        agentCreator.setTYPE(Type.OTHER);
        agentCreator.setOTHERTYPE("DSpace Software");
        Name creatorName = new Name();
        creatorName.getContent().add(new PCData("DSpace " + Util.getSourceVersion()));
        agentCreator.getContent().add(creatorName);
        metsHdr.getContent().add(agentCreator);
        return metsHdr;
    }

    public String[] getDmdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String dmdTypes = ConfigurationManager.getProperty((String)"aip.disseminate.dmd");
        if (dmdTypes == null) {
            String[] result = new String[]{"MODS", "DIM"};
            result[2] = "QDC";
            return result;
        }
        return dmdTypes.split("\\s*,\\s*");
    }

    public String[] getTechMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String techTypes = ConfigurationManager.getProperty((String)"aip.disseminate.techMD");
        if (techTypes == null) {
            if (dso.getType() == 0) {
                String[] result = new String[]{"PREMIS"};
                return result;
            }
            return new String[0];
        }
        return techTypes.split("\\s*,\\s*");
    }

    public String[] getSourceMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String sourceTypes = ConfigurationManager.getProperty((String)"aip.disseminate.sourceMD");
        if (sourceTypes == null) {
            String[] result = new String[]{"AIP-TECHMD"};
            return result;
        }
        return sourceTypes.split("\\s*,\\s*");
    }

    public String[] getDigiprovMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String dpTypes = ConfigurationManager.getProperty((String)"aip.disseminate.digiprovMD");
        if (dpTypes == null) {
            return new String[0];
        }
        return dpTypes.split("\\s*,\\s*");
    }

    public String[] getRightsMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        ArrayList<String> result = new ArrayList<String>();
        String rTypes = ConfigurationManager.getProperty((String)"aip.disseminate.rightsMD");
        if (rTypes == null) {
            if (dso.getType() == 2) {
                if (PackageUtils.findDepositLicense((Context)context, (Item)((Item)dso)) != null) {
                    result.add(DSPACE_DEPOSIT_LICENSE_MDTYPE);
                }
                if (CreativeCommons.getLicenseRdfBitstream((Item)((Item)dso)) != null) {
                    result.add(CREATIVE_COMMONS_RDF_MDTYPE);
                } else if (CreativeCommons.getLicenseTextBitstream((Item)((Item)dso)) != null) {
                    result.add(CREATIVE_COMMONS_TEXT_MDTYPE);
                }
            }
        } else {
            return rTypes.split("\\s*,\\s*");
        }
        result.add("METSRights");
        return result.toArray(new String[result.size()]);
    }

    public void addStructMap(Context context, DSpaceObject dso, PackageParameters params, Mets mets) throws SQLException, IOException, AuthorizeException, MetsException {
        String parentHandle = null;
        switch (dso.getType()) {
            case 2: {
                parentHandle = ((Item)dso).getOwningCollection().getHandle();
                break;
            }
            case 3: {
                parentHandle = ((Collection)dso).getCommunities()[0].getHandle();
                break;
            }
            case 4: {
                Community parent = ((Community)dso).getParentCommunity();
                parentHandle = parent == null ? Site.getSiteHandle() : parent.getHandle();
            }
        }
        if (parentHandle != null) {
            StructMap structMap = new StructMap();
            structMap.setID(this.gensym("struct"));
            structMap.setTYPE("LOGICAL");
            structMap.setLABEL("Parent");
            Div div0 = new Div();
            div0.setID(this.gensym("div"));
            div0.setTYPE(PARENT_DIV_TYPE);
            div0.setLABEL("Parent of this DSpace Object");
            Mptr mptr = new Mptr();
            mptr.setID(this.gensym("mptr"));
            mptr.setLOCTYPE(Loctype.HANDLE);
            mptr.setXlinkHref(parentHandle);
            div0.getContent().add(mptr);
            structMap.getContent().add(div0);
            mets.getContent().add(structMap);
        }
    }

    public boolean includeBundle(Bundle bundle) {
        List<String> bundleList = this.getBundleList();
        if (bundleList.size() == 1 && bundleList.get(0).equalsIgnoreCase("all") && !this.excludeBundles) {
            return true;
        }
        boolean inList = this.filterBundles.contains(bundle.getName());
        return this.excludeBundles ? !inList : inList;
    }

    protected List<String> getBundleList() {
        if (this.filterBundles != null && !this.filterBundles.isEmpty()) {
            return this.filterBundles;
        }
        String bundleList = this.disseminateParams.getProperty("filterBundles");
        if (bundleList == null || bundleList.isEmpty()) {
            bundleList = this.disseminateParams.getProperty("includeBundles", "+all");
            String string = bundleList = bundleList.startsWith("+") ? bundleList : "+".concat(bundleList);
        }
        if (bundleList.startsWith("+")) {
            this.excludeBundles = false;
            bundleList = bundleList.substring(1);
        }
        this.filterBundles = Arrays.asList(bundleList.split(","));
        return this.filterBundles;
    }

    public String getParameterHelp() {
        String parentHelp = super.getParameterHelp();
        return parentHelp + "\n\n" + "* filterBundles=[bundleList]      " + "List of bundles specifying which Bundles should be included in an AIP. If this list starts with a '+' symbol," + " then it represents a list of bundles to *include* in the AIP.  By default, the list represents a list of bundles" + " to *exclude* from the AIP.";
    }

    protected MdSec makeMdSec(Context context, DSpaceObject dso, Class mdSecClass, String typeSpec, PackageParameters params, AbstractMETSDisseminator.MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException {
        try {
            String xwalkName;
            String metsName;
            MdSec mdSec = (MdSec)mdSecClass.newInstance();
            mdSec.setID(this.gensym(mdSec.getLocalName()));
            String[] parts = typeSpec.split(":", 2);
            if (parts.length > 1) {
                metsName = parts[0];
                xwalkName = parts[1];
            } else {
                metsName = typeSpec;
                xwalkName = typeSpec;
            }
            boolean xwalkFound = PluginManager.hasNamedPlugin(DisseminationCrosswalk.class, (String)xwalkName);
            if (xwalkFound) {
                DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)xwalkName);
                if (xwalk.canDisseminate(dso)) {
                    if (xwalk instanceof AbstractPackagerWrappingCrosswalk) {
                        AbstractPackagerWrappingCrosswalk wrapper = (AbstractPackagerWrappingCrosswalk)xwalk;
                        wrapper.setPackagingParameters(params);
                    }
                    MdWrap mdWrap = new MdWrap();
                    this.setMdType(mdWrap, metsName);
                    XmlData xmlData = new XmlData();
                    if (this.crosswalkToMetsElement(xwalk, dso, (MetsElement)xmlData) != null) {
                        mdWrap.getContent().add(xmlData);
                        mdSec.getContent().add(mdWrap);
                        return mdSec;
                    }
                    return null;
                }
                return null;
            }
            StreamDisseminationCrosswalk sxwalk = (StreamDisseminationCrosswalk)PluginManager.getNamedPlugin(StreamDisseminationCrosswalk.class, (String)xwalkName);
            if (sxwalk != null) {
                if (sxwalk.canDisseminate(context, dso)) {
                    if (sxwalk instanceof AbstractPackagerWrappingCrosswalk) {
                        AbstractPackagerWrappingCrosswalk wrapper = (AbstractPackagerWrappingCrosswalk)sxwalk;
                        wrapper.setPackagingParameters(params);
                    }
                    ByteArrayOutputStream disseminateOutput = new ByteArrayOutputStream();
                    sxwalk.disseminate(context, dso, (OutputStream)disseminateOutput);
                    ByteArrayInputStream crosswalkedStream = new ByteArrayInputStream(disseminateOutput.toByteArray());
                    if (extraStreams != null) {
                        MdRef mdRef = new MdRef();
                        extraStreams.addStream(mdRef, (InputStream)crosswalkedStream);
                        mdRef.setMIMETYPE(sxwalk.getMIMEType());
                        this.setMdType(mdRef, metsName);
                        mdRef.setLOCTYPE(Loctype.URL);
                        mdSec.getContent().add(mdRef);
                    } else {
                        MdWrap mdWrap = new MdWrap();
                        mdWrap.setMIMETYPE(sxwalk.getMIMEType());
                        this.setMdType(mdWrap, metsName);
                        BinData binData = new BinData();
                        Base64 base64 = new Base64((InputStream)crosswalkedStream);
                        binData.getContent().add(base64);
                        mdWrap.getContent().add(binData);
                        mdSec.getContent().add(mdWrap);
                    }
                    return mdSec;
                }
                return null;
            }
            throw new PackageValidationException("Cannot find " + xwalkName + " crosswalk plugin, either DisseminationCrosswalk or StreamDisseminationCrosswalk");
        }
        catch (InstantiationException e) {
            throw new PackageValidationException("Error instantiating Mdsec object: " + e.toString(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new PackageValidationException("Error instantiating Mdsec object: " + e.toString(), (Exception)e);
        }
        catch (FileNotFoundException fe) {
            log.error((Object)fe.getMessage(), (Throwable)fe);
            return null;
        }
    }

    private MetsElement crosswalkToMetsElement(DisseminationCrosswalk xwalk, DSpaceObject dso, MetsElement me) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        try {
            List res;
            String raw = xwalk.getSchemaLocation();
            String[] sloc = raw == null ? null : raw.split("\\s+");
            Namespace[] ns = xwalk.getNamespaces();
            for (int i = 0; i < ns.length; ++i) {
                String uri = ns[i].getURI();
                if (sloc != null && sloc.length > 1 && uri.equals(sloc[0])) {
                    me.setSchema(ns[i].getPrefix(), uri, sloc[1]);
                    continue;
                }
                me.setSchema(ns[i].getPrefix(), uri);
            }
            PreformedXML pXML = null;
            if (xwalk.preferList()) {
                res = xwalk.disseminateList(dso);
                if (res != null && !res.isEmpty()) {
                    pXML = new PreformedXML(outputter.outputString(res));
                }
            } else {
                res = xwalk.disseminateElement(dso);
                if (res != null) {
                    pXML = new PreformedXML(outputter.outputString((Element)res));
                }
            }
            if (pXML != null) {
                me.getContent().add(pXML);
                return me;
            }
            return null;
        }
        catch (CrosswalkObjectNotSupported e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping MDsec because of CrosswalkObjectNotSupported: dso=" + dso.toString() + ", xwalk=" + xwalk.getClass().getName()));
            }
            return null;
        }
    }
}

