/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.bitstore.ExtendedBitstreamStorageManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.AbstractInternalMETSIngester;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.TableRow;
import org.jdom.Element;

public class InternalDSpaceAIPIngester
extends AbstractInternalMETSIngester {
    private static Logger log = Logger.getLogger(InternalDSpaceAIPIngester.class);

    @Override
    void checkManifest(METSManifest manifest) throws MetadataValidationException {
        String profile = manifest.getProfile();
        if (profile == null) {
            throw new MetadataValidationException("Cannot accept METS with no PROFILE attribute!");
        }
        if (!profile.equals("http://www.dspace.org/schema/aip/mets_aip_1_0.xsd")) {
            throw new MetadataValidationException("METS has unacceptable PROFILE attribute, profile=" + profile);
        }
    }

    @Override
    public void crosswalkObjectDmd(Context context, DSpaceObject dso, METSManifest manifest, AbstractInternalMETSIngester.MdrefManager callback, Element[] dmds, PackageParameters params) throws CrosswalkException, PackageValidationException, AuthorizeException, SQLException, IOException {
        int i;
        int found = -1;
        String userDmd = null;
        if (params != null) {
            userDmd = params.getProperty("dmd");
        }
        if (userDmd != null && userDmd.length() > 0) {
            for (i = 0; i < dmds.length; ++i) {
                if (!userDmd.equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"DIM".equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"MODS".equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        String groupID = null;
        if (found >= 0) {
            manifest.crosswalkItemDmd(context, params, dso, dmds[found], (METSManifest.Mdref)callback);
            groupID = dmds[found].getAttributeValue("GROUPID");
            if (groupID != null) {
                for (int i2 = 0; i2 < dmds.length; ++i2) {
                    String g = dmds[i2].getAttributeValue("GROUPID");
                    if (g == null || g.equals(groupID)) continue;
                    manifest.crosswalkItemDmd(context, params, dso, dmds[i2], (METSManifest.Mdref)callback);
                }
            }
        } else if (dmds.length > 0) {
            manifest.crosswalkItemDmd(context, params, dso, dmds[0], (METSManifest.Mdref)callback);
        } else {
            throw new MetadataValidationException("DSpaceAIPIngester: Could not find an acceptable object-wide DMD section in manifest.");
        }
    }

    @Override
    public void addLicense(Context context, Item item, String license, Collection collection, PackageParameters params) throws PackageValidationException, AuthorizeException, SQLException, IOException {
        boolean newLicense = false;
        if (!params.restoreModeEnabled()) {
            newLicense = true;
        }
        if (!params.getBooleanProperty("manifestOnly", false) && PackageUtils.findDepositLicense((Context)context, (Item)item) == null) {
            newLicense = true;
        }
        if (newLicense) {
            PackageUtils.addDepositLicense((Context)context, (String)license, (Item)item, (Collection)collection);
        }
    }

    @Override
    public void finishObject(Context context, DSpaceObject dso, PackageParameters params) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (dso.getType() == 2 && params.getBooleanProperty("createMetadataFields", true)) {
            InternalDSpaceAIPIngester.createMissingMetadataFields(context, (Item)dso);
        }
    }

    @Override
    public void finishBitstream(Context context, Bitstream bs, Element mfile, METSManifest manifest, PackageParameters params) throws MetadataValidationException, SQLException, AuthorizeException, IOException {
    }

    @Override
    public int getObjectType(METSManifest manifest) throws PackageValidationException {
        int type;
        Element mets = manifest.getMets();
        String typeStr = mets.getAttributeValue("TYPE");
        if (typeStr == null || typeStr.length() == 0) {
            throw new PackageValidationException("Manifest is missing the required mets@TYPE attribute.");
        }
        if (typeStr.startsWith("DSpace ")) {
            typeStr = typeStr.substring(7);
        }
        if ((type = Constants.getTypeID((String)typeStr)) < 0) {
            throw new PackageValidationException("Manifest has unrecognized value in mets@TYPE attribute: " + typeStr);
        }
        return type;
    }

    @Override
    public String getConfigurationName() {
        return "dspaceAIP";
    }

    protected static void createMissingMetadataFields(Context context, Item item) throws PackageValidationException, AuthorizeException, IOException, SQLException {
        DCValue[] allMD;
        for (DCValue md : allMD = item.getMetadata("*", "*", "*", "*")) {
            MetadataSchema mdSchema = null;
            MetadataField mdField = null;
            try {
                mdSchema = MetadataSchema.find((Context)context, (String)md.schema);
                if (mdSchema != null) {
                    mdField = MetadataField.findByElement((Context)context, (int)mdSchema.getSchemaID(), (String)md.element, (String)md.qualifier);
                }
            }
            catch (SQLException se) {
                mdField = null;
            }
            if (mdSchema == null) {
                throw new PackageValidationException("Unknown Metadata Schema encountered (" + md.schema + ") when attempting to ingest an Item.  You will need to create this Metadata Schema in DSpace Schema Registry before the Item can be ingested.");
            }
            if (mdField != null) continue;
            try {
                mdField = new MetadataField(mdSchema, md.element, md.qualifier, null);
                mdField.create(context);
                log.info((Object)("Located a missing metadata field (schema:'" + mdSchema.getName() + "', element:'" + md.element + "', qualifier:'" + md.qualifier + "') while ingesting Item.  This missing field has been created in the DSpace Metadata Field Registry."));
            }
            catch (NonUniqueMetadataException ne) {
                throw new SQLException("Unable to create Metadata Field (element='" + md.element + "', qualifier='" + md.qualifier + "') in Schema " + mdSchema.getName() + ".", ne);
            }
        }
    }

    @Override
    public String getParameterHelp() {
        String parentHelp = super.getParameterHelp();
        return parentHelp + "\n\n" + "* createMetadataFields=[boolean]      " + "If true, ingest attempts to create any missing metadata fields." + "If false, ingest will fail if a metadata field is encountered which doesn't already exist. (default = true)" + "\n\n" + "* dmd=[dmdSecType]      " + "Type of the METS <dmdSec> which should be used to restore item metadata (defaults to DIM, then MODS)";
    }

    @Override
    protected void addBitstreams(Context context, Item item, METSManifest manifest, File pkgFile, PackageParameters params, AbstractInternalMETSIngester.MdrefManager mdRefCallback) throws SQLException, IOException, AuthorizeException, MetadataValidationException, CrosswalkException, PackageValidationException {
        String primaryID = null;
        Element primaryFile = manifest.getPrimaryOrLogoBitstream();
        if (primaryFile != null) {
            primaryID = primaryFile.getAttributeValue("ID");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got primary bitstream file ID=\"" + primaryID + "\""));
            }
        }
        List manifestContentFiles = manifest.getContentFiles();
        boolean setPrimaryBitstream = false;
        BitstreamFormat unknownFormat = BitstreamFormat.findUnknown((Context)context);
        for (Element mfile : manifestContentFiles) {
            String mfileID = mfile.getAttributeValue("ID");
            if (mfileID == null) {
                throw new PackageValidationException("Invalid METS Manifest: file element without ID attribute.");
            }
            String path = METSManifest.getFileName((Element)mfile);
            Bitstream bitstream = this.resolveBitstream(context, mfile, params, path);
            String bundleName = METSManifest.getBundleName((Element)mfile);
            Bundle[] bns = item.getBundles(bundleName);
            Bundle bundle = bns != null && bns.length > 0 ? bns[0] : item.createBundle(bundleName);
            bundle.addBitstream(bitstream);
            String seqID = mfile.getAttributeValue("SEQ");
            if (seqID != null && !seqID.isEmpty()) {
                bitstream.setSequenceID(Integer.parseInt(seqID));
            }
            manifest.crosswalkBitstream(context, params, bitstream, mfileID, (METSManifest.Mdref)mdRefCallback);
            if (primaryID != null && mfileID.equals(primaryID)) {
                bundle.setPrimaryBitstreamID(bitstream.getID());
                bundle.update();
                setPrimaryBitstream = true;
            }
            this.finishBitstream(context, bitstream, mfile, manifest, params);
            if (bitstream.getFormat().equals(unknownFormat)) {
                String mimeType;
                BitstreamFormat bf;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Guessing format of Bitstream left un-set: " + bitstream.toString()));
                }
                BitstreamFormat bitstreamFormat = bf = (mimeType = mfile.getAttributeValue("MIMETYPE")) == null ? null : BitstreamFormat.findByMIMEType((Context)context, (String)mimeType);
                if (bf == null) {
                    bf = FormatIdentifier.guessFormat((Context)context, (Bitstream)bitstream);
                }
                bitstream.setFormat(bf);
            }
            bitstream.update();
        }
        if (primaryID != null && !setPrimaryBitstream) {
            log.warn((Object)("Could not find primary bitstream file ID=\"" + primaryID + "\" in manifest file \"" + pkgFile.getAbsolutePath() + "\""));
        }
    }

    public Bitstream resolveBitstream(Context context, Element mfile, PackageParameters params, String path) throws SQLException, PackageValidationException {
        if (params.getBooleanProperty("internal", false)) {
            try {
                TableRow row = ExtendedBitstreamStorageManager.dereferenceAbsoluteURI(context, new URI(path));
                Bitstream result = Bitstream.find((Context)context, (int)row.getIntColumn("bitstream_id"));
                if (result == null) {
                    throw new PackageValidationException("Package refers to a Bitstream that cannot be found (check assetstore), URI=" + path);
                }
                return result;
            }
            catch (URISyntaxException e) {
                log.error((Object)"bad bitstream path URI: ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public DSpaceObject replace(Context context, DSpaceObject dsoToReplace, File pkgFile, PackageParameters params) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        METSManifest manifest = null;
        DSpaceObject dso = null;
        try {
            log.info((Object)LogManager.getHeader((Context)context, (String)"package_parse", (String)("Parsing package for replace, file=" + pkgFile.getName())));
            manifest = this.parsePackage(context, pkgFile, params);
            if (manifest == null) {
                throw new PackageValidationException("No METS Manifest found (filename=mets.xml).  Package is unacceptable!");
            }
            if (dsoToReplace == null) {
                String handleURI = manifest.getObjID();
                String handle = this.decodeHandleURN(handleURI);
                try {
                    dsoToReplace = HandleManager.resolveToObject((Context)context, (String)handle);
                }
                catch (IllegalStateException ie) {
                    // empty catch block
                }
            }
            if (dsoToReplace == null) {
                dso = this.ingestObject(context, null, manifest, pkgFile, params, null);
                if (dso != null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"package_replace", (String)("Created new Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID()))));
                }
            } else {
                dso = this.replaceObject(context, dsoToReplace, manifest, pkgFile, params, null);
                log.info((Object)LogManager.getHeader((Context)context, (String)"package_replace", (String)("Replaced Object, type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", dbID=" + String.valueOf(dso.getID()))));
            }
            if (dso != null && params.recursiveModeEnabled()) {
                String[] childFilePaths = manifest.getChildMetsFilePaths();
                for (int i = 0; i < childFilePaths.length; ++i) {
                    this.addPackageReference(dso, childFilePaths[i]);
                }
            }
            return dso;
        }
        catch (SQLException se) {
            dso = null;
            throw se;
        }
    }
}

