/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.discovery.IndexingService;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.identifier.IdentifierService;
import org.dspace.utils.DSpace;
import org.dspace.workflow.WorkflowItem;

public class IndexEventConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(IndexEventConsumer.class);
    private Set<DSpaceObject> objectsToUpdate = null;
    private Set<String> handlesToDelete = null;
    DSpace dspace = new DSpace();
    IndexingService indexer = (IndexingService)this.dspace.getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    IdentifierService identifierService = (IdentifierService)this.dspace.getSingletonService(IdentifierService.class);

    public void initialize() throws Exception {
    }

    public void consume(Context ctx, Event event) throws Exception {
        int st;
        if (this.objectsToUpdate == null) {
            this.objectsToUpdate = new HashSet<DSpaceObject>();
            this.handlesToDelete = new HashSet<String>();
        }
        if ((st = event.getSubjectType()) != 2 && st != 1 && st != 3 && st != 4 && st != 0) {
            log.warn((Object)("IndexConsumer should not have been given this kind of Subject in an event, skipping: " + event.toString()));
            return;
        }
        DSpaceObject subject = event.getSubject(ctx);
        DSpaceObject object = event.getObject(ctx);
        int et = event.getEventType();
        if (st == 1) {
            if ((et == 8 || et == 16) && subject != null && ((Bundle)subject).getName().equals("TEXT")) {
                st = 2;
                et = 2;
                subject = ((Bundle)subject).getItems()[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Transforming Bundle event into MODIFY of Item " + subject.getHandle()));
                }
            } else {
                return;
            }
        }
        switch (et) {
            case 1: {
                if (0 == st) {
                    this.objectsToUpdate.add(subject);
                    log.debug((Object)("consume() adding event to add queue: " + event.toString()));
                    break;
                }
            }
            case 2: 
            case 4: {
                if (subject == null) {
                    log.warn((Object)(event.getEventTypeAsString() + " event, could not get object for " + event.getSubjectTypeAsString() + " id=" + String.valueOf(event.getSubjectID()) + ", perhaps it has been deleted."));
                    break;
                }
                log.debug((Object)("consume() adding event to update queue: " + event.toString()));
                this.objectsToUpdate.add(subject);
                break;
            }
            case 8: 
            case 16: {
                if (object == null) {
                    log.warn((Object)(event.getEventTypeAsString() + " event, could not get object for " + event.getObjectTypeAsString() + " id=" + String.valueOf(event.getObjectID()) + ", perhaps it has been deleted."));
                    break;
                }
                log.debug((Object)("consume() adding event to update queue: " + event.toString()));
                this.objectsToUpdate.add(object);
                break;
            }
            case 32: {
                String detail = event.getDetail();
                if (detail == null) {
                    log.warn((Object)"got null detail on DELETE event, skipping it.");
                    break;
                }
                if (0 == st) {
                    detail = "ds:bitstream/" + event.getSubjectID();
                }
                log.debug((Object)("consume() adding event to delete queue: " + event.toString()));
                this.handlesToDelete.add(detail);
                break;
            }
            default: {
                log.warn((Object)("IndexConsumer should not have been given a event of type=" + event.getEventTypeAsString() + " on subject=" + event.getSubjectTypeAsString()));
            }
        }
    }

    public void end(Context ctx) throws Exception {
        if (this.objectsToUpdate != null && this.handlesToDelete != null) {
            for (DSpaceObject iu : this.objectsToUpdate) {
                String hdl = iu.getHandle();
                if (iu.getType() == 0) {
                    Item item;
                    Boolean addBitstream = true;
                    DSpaceObject parentObject = iu.getParentObject();
                    if (parentObject != null && parentObject.getType() == 2 && !(item = (Item)parentObject).isArchived()) {
                        WorkspaceItem workspaceItem = WorkspaceItem.findByItem((Context)ctx, (Item)item);
                        if (workspaceItem == null) {
                            WorkflowItem workflowItem = WorkflowItem.findByItem((Context)ctx, (Item)item);
                            if (workflowItem != null) {
                                addBitstream = false;
                            }
                        } else {
                            addBitstream = false;
                        }
                    }
                    if (addBitstream.booleanValue()) {
                        hdl = "ds:bitstream/" + iu.getID();
                    }
                }
                if (hdl == null || this.handlesToDelete.contains(hdl)) continue;
                try {
                    this.indexer.indexContent(ctx, iu, true);
                    log.debug((Object)("Indexed " + Constants.typeText[iu.getType()] + ", id=" + String.valueOf(iu.getID()) + ", handle=" + hdl));
                }
                catch (Exception e) {
                    log.error((Object)"Failed while indexing object: ", (Throwable)e);
                }
            }
            for (String hdl : this.handlesToDelete) {
                try {
                    DSpaceObject dso = this.identifierService.resolve(ctx, hdl);
                    if (dso != null && dso instanceof Bitstream && BitstreamUtil.isDeleted((Bitstream)dso)) {
                        this.indexer.indexContent(ctx, dso, true);
                        log.debug((Object)("found deleted dso, updating, handle=" + hdl));
                        continue;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Unexpected error retrieving bitstream to delete: " + hdl), (Throwable)e);
                }
                this.indexer.unIndexContent(ctx, hdl, true);
                log.debug((Object)("un-indexed handle=" + hdl));
            }
        }
        this.objectsToUpdate = null;
        this.handlesToDelete = null;
    }

    public void finish(Context ctx) throws Exception {
    }
}

