/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.InternalIdentifier;
import org.dspace.identifier.UniversallyUniqueIdentifierProvider;
import org.springframework.stereotype.Component;

@Component
public class InternalIdentifierProvider
extends IdentifierProvider {
    private static Logger log = Logger.getLogger(UniversallyUniqueIdentifierProvider.class);
    protected String[] supportedPrefixes = new String[]{"info:ds", "ds"};

    public boolean supports(Class<? extends Identifier> identifier) {
        return InternalIdentifier.class.isAssignableFrom(identifier);
    }

    public boolean supports(String identifier) {
        for (String prefix : this.supportedPrefixes) {
            if (!identifier.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public DSpaceObject resolve(Context context, String identifier, String ... attributes) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        if (identifier.startsWith("ds:bitstream/")) {
            try {
                return Bitstream.find((Context)context, (int)Integer.parseInt(identifier.replace("ds:bitstream/", "")));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (identifier.startsWith("ds:item/")) {
            try {
                return Item.find((Context)context, (int)Integer.parseInt(identifier.replace("ds:item/", "")));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String lookup(Context context, DSpaceObject object) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        if (object instanceof Bitstream) {
            return "ds:bitstream/" + object.getID();
        }
        return null;
    }

    public String register(Context context, DSpaceObject item) throws IdentifierException {
        return null;
    }

    public String mint(Context context, DSpaceObject dso) throws IdentifierException {
        return null;
    }

    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
    }

    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
    }

    public void reserve(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
    }

    public void register(Context context, DSpaceObject object, String identifier) throws IdentifierException {
    }
}

