/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.springframework.stereotype.Component;

@Component
public class UniversallyUniqueIdentifierProvider
extends IdentifierProvider {
    private static Logger log = Logger.getLogger(UniversallyUniqueIdentifierProvider.class);
    protected static final String EXAMPLE_PREFIX = "123456789";
    protected String[] supportedPrefixes = new String[]{"info:uuid", "uuid:"};

    public boolean supports(Class<? extends Identifier> identifier) {
        return UUID.class.isAssignableFrom(identifier);
    }

    public boolean supports(String identifier) {
        for (String prefix : this.supportedPrefixes) {
            if (!identifier.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public String register(Context context, DSpaceObject dso) {
        try {
            return this.mint(context, dso);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"Error while attempting to create uuid", (String)("Item id: " + dso.getID())), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    public void register(Context context, DSpaceObject dso, String identifier) {
        try {
            this.createNewIdentifier(context, dso, identifier);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"Error while attempting to create uuid", (String)("Item id: " + dso.getID())), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            TableRow uuid = DatabaseManager.create((Context)context, (String)"Uuid");
            this.modifyUuidRecord(context, dso, uuid, identifier);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"Error while attempting to create uuid", (String)("Item id: " + dso.getID())), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    public String mint(Context context, DSpaceObject dso) {
        try {
            String uuid = this.lookup(context, dso);
            if (uuid != null) {
                return uuid;
            }
            return this.createNewIdentifier(context, dso, null);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"Error while attempting to create uuid", (String)("Item id: " + dso.getID())), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            TableRow dbuuid = UniversallyUniqueIdentifierProvider.findUuidInternal(context, identifier);
            if (dbuuid == null) {
                if ((identifier = UniversallyUniqueIdentifierProvider.retrieveUuidOutOfUrl(identifier)) != null) {
                    dbuuid = UniversallyUniqueIdentifierProvider.findUuidInternal(context, identifier);
                }
                if (dbuuid == null) {
                    return null;
                }
            }
            if (dbuuid.isColumnNull("resource_type_id") || dbuuid.isColumnNull("resource_id")) {
                throw new IllegalStateException("No associated resource type");
            }
            int uuidtypeid = dbuuid.getIntColumn("resource_type_id");
            int resourceID = dbuuid.getIntColumn("resource_id");
            if (uuidtypeid == 2) {
                Item item = Item.find((Context)context, (int)resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved uuid " + identifier + " to item " + (item == null ? -1 : item.getID())));
                }
                return item;
            }
            if (uuidtypeid == 3) {
                Collection collection = Collection.find((Context)context, (int)resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved uuid " + identifier + " to collection " + (collection == null ? -1 : collection.getID())));
                }
                return collection;
            }
            if (uuidtypeid == 4) {
                Community community = Community.find((Context)context, (int)resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved uuid " + identifier + " to community " + (community == null ? -1 : community.getID())));
                }
                return community;
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"Error while resolving uuid to item", (String)("uuid: " + identifier)), (Throwable)e);
        }
        return null;
    }

    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            TableRow row = UniversallyUniqueIdentifierProvider.getUuidInternal(context, dso.getType(), dso.getID());
            if (row == null) {
                return null;
            }
            return row.getStringColumn("uuid");
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), (Throwable)sqe);
        }
    }

    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        try {
            TableRow row = UniversallyUniqueIdentifierProvider.getUuidInternal(context, dso.getType(), dso.getID());
            if (row != null) {
                row.setColumnNull("resource_id");
                DatabaseManager.update((Context)context, (TableRow)row);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unbound Uuid " + row.getStringColumn("uuid") + " from object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
                }
            } else {
                log.warn((Object)("Cannot find Uuid entry to unbind for object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
            }
        }
        catch (SQLException sqe) {
            throw new IdentifierException(sqe.getMessage(), (Throwable)sqe);
        }
    }

    public static String retrieveUuidOutOfUrl(String url) throws SQLException {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    protected String createNewIdentifier(Context context, DSpaceObject dso, String uuidId) throws SQLException {
        int previousType;
        TableRow uuid = null;
        if (uuidId != null) {
            uuid = UniversallyUniqueIdentifierProvider.findUuidInternal(context, uuidId);
            if (uuid != null && !uuid.isColumnNull("resource_id")) {
                if (uuid.getIntColumn("resource_id") == dso.getID() && uuid.getIntColumn("resource_type_id") == dso.getType()) {
                    return uuidId;
                }
                throw new IllegalStateException("Attempted to create a uuid which is already in use: " + uuidId);
            }
        } else if (uuid != null && !uuid.isColumnNull("resource_type_id") && (previousType = uuid.getIntColumn("resource_type_id")) != dso.getType()) {
            throw new IllegalStateException("Attempted to reuse a uuid previously used by a " + Constants.typeText[previousType] + " for a new " + Constants.typeText[dso.getType()]);
        }
        if (uuid == null) {
            uuid = DatabaseManager.create((Context)context, (String)"Uuid");
        }
        this.modifyUuidRecord(context, dso, uuid, uuidId);
        return uuidId;
    }

    protected String modifyUuidRecord(Context context, DSpaceObject dso, TableRow uuid, String uuidId) throws SQLException {
        uuid.setColumn("uuid", uuidId);
        uuid.setColumn("resource_type_id", dso.getType());
        uuid.setColumn("resource_id", dso.getID());
        DatabaseManager.update((Context)context, (TableRow)uuid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new uuid for " + Constants.typeText[dso.getType()] + " " + uuidId));
        }
        return uuidId;
    }

    protected static TableRow getUuidInternal(Context context, int type, int id) throws SQLException {
        String sql = "SELECT * FROM Uuid WHERE resource_type_id = ? AND resource_id = ?";
        return DatabaseManager.querySingleTable((Context)context, (String)"Uuid", (String)sql, (Object[])new Object[]{type, id});
    }

    protected static TableRow findUuidInternal(Context context, String uuid) throws SQLException {
        if (uuid == null) {
            throw new IllegalArgumentException("Uuid is null");
        }
        return DatabaseManager.findByUnique((Context)context, (String)"Uuid", (String)"uuid", (Object)uuid);
    }
}

