/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierService;
import org.dspace.utils.DSpace;
import org.dspace.versioning.AbstractVersionProvider;
import org.dspace.versioning.ItemVersionProvider;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;

public class DefaultItemVersionProvider
extends AbstractVersionProvider
implements ItemVersionProvider {
    public Item createNewItemAndAddItInWorkspace(Context context, Item nativeItem) {
        try {
            WorkspaceItem workspaceItem = WorkspaceItem.create((Context)context, (Collection)nativeItem.getOwningCollection(), (boolean)false);
            Item itemNew = workspaceItem.getItem();
            itemNew.update();
            return itemNew;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void deleteVersionedItem(Context c, Version versionToDelete, VersionHistory history) {
        try {
            if (history.isLastVersion(versionToDelete) && history.size() > 1) {
                Item item = history.getPrevious(versionToDelete).getItem();
                item.setArchived(true);
                item.update();
            }
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            Item itemToDelete = versionToDelete.getItem();
            identifierService.delete(c, (DSpaceObject)itemToDelete);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IdentifierException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Item updateItemState(Context c, Item itemNew, Item previousItem) {
        try {
            this.copyMetadata(itemNew, previousItem);
            this.createBundlesAndAddBitstreams(c, itemNew, previousItem);
            itemNew.update();
            return itemNew;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

