/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.AIPManifestWriter;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.OREManifestWriter;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionDAO;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersionHistoryDAO;
import org.dspace.versioning.VersionImpl;
import org.dspace.versioning.VersioningService;

public class ImportVersion2Bitstream {
    private static VersionDAO versionDAO = new VersionDAO();
    private static VersionHistoryDAO versionHistoryDAO = new VersionHistoryDAO();
    private static final Logger log = Logger.getLogger(ImportVersion2Bitstream.class);

    public static void main(String[] args) {
        String usage = "org.dspace.versioning.ImportVersion2Bitstream [-f] or nothing.";
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine line = null;
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"if updating existing index, force each handle to be reindexed even if uptodate");
        options.addOption(OptionBuilder.create((String)"f"));
        try {
            line = new PosixParser().parse(options, args);
        }
        catch (Exception e) {
            formatter.printHelp(usage, e.getMessage(), options, "");
            System.exit(1);
        }
        boolean force = line.hasOption("f");
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            if (force) {
                for (Bitstream b : Bitstream.findAll((Context)context)) {
                    Version version = BitstreamUtil.getVersion(context, b);
                    if (version == null && b.getParentObject() == null) {
                        System.out.println("deleting: " + b.getID() + " version is null, " + b.getFormat().getShortDescription());
                        BitstreamUtil.delete(context, b, true);
                        continue;
                    }
                    if (version == null) {
                        System.out.println("keeping: " + b.getID() + " version is null, " + b.getFormat().getShortDescription() + ", but parent:" + b.getParentObject().getID());
                        continue;
                    }
                    if (b.getParentObject() == null) {
                        System.out.println("keeping: " + b.getID() + " version is " + version.getVersionId() + ", " + b.getFormat().getShortDescription() + ", but parent: null");
                        continue;
                    }
                    System.out.println("keeping: " + b.getID() + " version is " + version.getVersionId() + ", " + b.getFormat().getShortDescription() + ", but parent:" + b.getParentObject().getID());
                }
                context.commit();
            }
            ItemIterator items = Item.findAll((Context)context);
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            Date date = new Date();
            while (items.hasNext()) {
                Item item = items.next();
                if (item.isArchived() && !item.isWithdrawn()) {
                    ImportVersion2Bitstream.debug("processing item:" + item.getID());
                    VersionHistory vh = versioningService.findVersionHistory(context, item.getID());
                    if (vh == null) {
                        vh = versionHistoryDAO.create(context);
                        VersionImpl versionImpl = versionDAO.create(context, item.getID(), !item.isArchived() && !item.isWithdrawn());
                        log.debug((Object)("create version:" + versionImpl.getVersionId()));
                        versionImpl.setVersionDate(date);
                        versionImpl.setEperson(item.getSubmitter());
                        versionImpl.setItemID(item.getID());
                        if (item.getHandle() != null) {
                            versionImpl.setHandle(item.getHandle());
                        }
                        versionImpl.setSummary("initial version");
                        versionImpl.setVersionLog("initial import");
                        versionImpl.setVersionNumber(0);
                        vh.add((Version)versionImpl);
                        versionImpl.setVersionHistory(vh.getVersionHistoryId());
                        AIPManifestWriter aipManifestWriter = new AIPManifestWriter();
                        Bitstream bitstream = aipManifestWriter.updateAIP(context, (DSpaceObject)item, true);
                        versionImpl.setAIPBitstream(bitstream.getID());
                        AuthorizeManager.inheritPolicies((Context)context, (DSpaceObject)item, (DSpaceObject)bitstream);
                        OREManifestWriter oreManifestWriter = new OREManifestWriter();
                        Bitstream b = oreManifestWriter.updateORE(context, item, versionImpl, true);
                        versionImpl.setOREBitstream(b.getID());
                        AuthorizeManager.inheritPolicies((Context)context, (DSpaceObject)item, (DSpaceObject)b);
                        VersionDAO.addBitstreams(context, versionImpl.getVersionId(), item.getBundles());
                        versionDAO.update(versionImpl);
                        context.commit();
                    } else {
                        ImportVersion2Bitstream.debug("found version history:" + vh.getVersionHistoryId());
                        for (Version version : vh.getVersions()) {
                            Item vItem = version.getItem();
                            ImportVersion2Bitstream.debug("found version:" + version.getVersionId());
                            if (version.getVersionNumber() > -1 && vItem != null) {
                                boolean updated = false;
                                if (version.getAIPBitstream() == null || force) {
                                    AIPManifestWriter aipManifestWriter = new AIPManifestWriter();
                                    Bitstream bitstream = aipManifestWriter.updateAIP(context, (DSpaceObject)vItem, true);
                                    version.setAIPBitstream(bitstream.getID());
                                    AuthorizeManager.inheritPolicies((Context)context, (DSpaceObject)item, (DSpaceObject)bitstream);
                                    updated = true;
                                } else {
                                    AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)version.getAIPBitstream(), (int)0);
                                    AuthorizeManager.inheritPolicies((Context)context, (DSpaceObject)item, (DSpaceObject)version.getAIPBitstream());
                                    version.getAIPBitstream().setFormat(BitstreamFormat.findByShortDescription((Context)context, (String)"http://www.loc.gov/METS/"));
                                    ImportVersion2Bitstream.debug("has AIP Bitstream:" + version.getAIPBitstream().getID());
                                    ImportVersion2Bitstream.debug("has AIP Bitstream Format:" + version.getAIPBitstream().getFormat().getShortDescription());
                                    for (ResourcePolicy policy : AuthorizeManager.getPoliciesActionFilter((Context)context, (DSpaceObject)version.getAIPBitstream(), (int)0)) {
                                        ImportVersion2Bitstream.debug("has AIP Bitstream READ Policy:" + policy.getID() + " " + policy.getGroupID() + " " + policy.getEPersonID());
                                    }
                                }
                                if (version.getOREBitstream() == null || force) {
                                    OREManifestWriter oreManifestWriter = new OREManifestWriter();
                                    Bitstream b = oreManifestWriter.updateORE(context, vItem, version, true);
                                    version.setOREBitstream(b.getID());
                                    AuthorizeManager.inheritPolicies((Context)context, (DSpaceObject)item, (DSpaceObject)b);
                                    updated = true;
                                } else {
                                    AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)version.getOREBitstream(), (int)0);
                                    AuthorizeManager.inheritPolicies((Context)context, (DSpaceObject)item, (DSpaceObject)version.getOREBitstream());
                                    version.getOREBitstream().setFormat(BitstreamFormat.findByShortDescription((Context)context, (String)"http://www.openarchives.org/ore/terms/"));
                                    ImportVersion2Bitstream.debug("has ORE Bitstream:" + version.getOREBitstream().getID());
                                    ImportVersion2Bitstream.debug("has ORE Bitstream Format:" + version.getOREBitstream().getFormat().getShortDescription());
                                    for (ResourcePolicy policy : AuthorizeManager.getPoliciesActionFilter((Context)context, (DSpaceObject)version.getAIPBitstream(), (int)0)) {
                                        ImportVersion2Bitstream.debug("has ORE Bitstream READ Policy:" + policy.getID() + " " + policy.getGroupID() + " " + policy.getEPersonID());
                                    }
                                }
                                if (version.getBitstreams(context) == null || version.getBitstreams(context).length < 1) {
                                    VersionDAO.addBitstreams(context, version.getVersionId(), vItem.getBundles());
                                    updated = true;
                                } else {
                                    String result = "has Attached Content Bitstreams:";
                                    for (Bitstream b : version.getBitstreams(context)) {
                                        result = result + " " + b.getID();
                                    }
                                    ImportVersion2Bitstream.debug(result);
                                }
                                if (updated) {
                                    versionDAO.update((VersionImpl)version);
                                }
                            }
                            context.commit();
                        }
                    }
                }
                context.clearCache();
            }
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (Exception e) {
            if (context != null) {
                context.restoreAuthSystemState();
                context.abort();
            }
            System.out.println(e.getMessage());
            System.out.println(e.fillInStackTrace());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void debug(String message) {
        System.out.println(message);
        log.debug((Object)message);
    }
}

