/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionImpl;

public class VersionDAO {
    protected static final String TABLE_NAME = "versionitem";
    protected static final String VERSION_ID = "versionitem_id";
    protected static final String ITEM_ID = "item_id";
    protected static final String VERSION_NUMBER = "version_number";
    protected static final String EPERSON_ID = "eperson_id";
    protected static final String VERSION_DATE = "version_date";
    protected static final String VERSION_SUMMARY = "version_summary";
    protected static final String VERSION_VERSIONlOG = "version_log";
    protected static final String HISTORY_ID = "versionhistory_id";
    protected static final String BITSTREAM_ID = "bitstream_id";
    protected static final String ORE_BITSTREAM_ID = "ore_bitstream_id";
    protected static final String VERSION_HANDLE = "handle";

    public VersionImpl find(Context context, int id) {
        try {
            TableRow row = DatabaseManager.findByUnique((Context)context, (String)TABLE_NAME, (String)VERSION_ID, (Object)id);
            if (row == null) {
                return null;
            }
            return new VersionImpl(context, row);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public VersionImpl findByItem(Context c, Item item) {
        return this.findByItemId(c, item.getID());
    }

    public VersionImpl findByItemId(Context context, int itemId) {
        try {
            if (itemId == 0 || itemId == -1) {
                return null;
            }
            TableRowIterator tri = DatabaseManager.queryTable((Context)context, (String)TABLE_NAME, (String)("SELECT * FROM versionitem where item_id=" + itemId + " order by " + VERSION_NUMBER + " desc"), (Object[])new Object[0]);
            if (tri.hasNext()) {
                TableRow tr = tri.next();
                VersionImpl fromCache = (VersionImpl)context.fromCache(VersionImpl.class, tr.getIntColumn(VERSION_ID));
                if (fromCache != null) {
                    return fromCache;
                }
                return new VersionImpl(context, tr);
            }
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public VersionImpl findByItemIdInprogress(Context context, int itemId) {
        try {
            TableRowIterator tri = DatabaseManager.queryTable((Context)context, (String)TABLE_NAME, (String)("SELECT * FROM versionitem where item_id=" + itemId + " and version_number = -1 order by " + VERSION_ID + " desc"), (Object[])new Object[0]);
            if (tri.hasNext()) {
                TableRow tr = tri.next();
                VersionImpl fromCache = (VersionImpl)context.fromCache(VersionImpl.class, tr.getIntColumn(VERSION_ID));
                if (fromCache != null) {
                    return fromCache;
                }
                return new VersionImpl(context, tr);
            }
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<Version> findByVersionHistory(Context context, int versionHistoryId) {
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.queryTable((Context)context, (String)TABLE_NAME, (String)("SELECT * FROM versionitem where versionhistory_id=" + versionHistoryId + " order by " + VERSION_NUMBER + " desc"), (Object[])new Object[0]);
            ArrayList<Version> versions = new ArrayList<Version>();
            while (tri.hasNext()) {
                TableRow tr = tri.next();
                VersionImpl fromCache = (VersionImpl)context.fromCache(VersionImpl.class, tr.getIntColumn(VERSION_ID));
                if (fromCache != null) {
                    versions.add(fromCache);
                    continue;
                }
                versions.add(new VersionImpl(context, tr));
                context.cache(versions, versionHistoryId);
            }
            ArrayList<Version> arrayList = versions;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public VersionImpl create(Context context, int itemId, boolean isWorkspace) {
        try {
            TableRow row = DatabaseManager.create((Context)context, (String)TABLE_NAME);
            VersionImpl v = new VersionImpl(context, row);
            if (isWorkspace) {
                v.setVersionNumber(-1);
            } else {
                VersionImpl preVersion = this.findByItemId(context, itemId);
                if (preVersion != null) {
                    v.setVersionNumber(preVersion.getVersionNumber() + 1);
                } else {
                    v.setVersionNumber(0);
                }
            }
            return v;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void delete(Context c, int versionID) {
        try {
            VersionImpl version = this.find(c, versionID);
            if (version != null) {
                c.removeCached((Object)version, version.getVersionId());
                DatabaseManager.delete((Context)c, (TableRow)version.getMyRow());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void update(VersionImpl version) {
        try {
            Item item = version.getItem();
            if (item == null) {
                DatabaseManager.update((Context)version.getMyContext(), (TableRow)version.getMyRow());
            } else {
                if (!item.isArchived() && version.getVersionNumber() != -1) {
                    throw new RuntimeException("None Archived item should have a version number euqals -1");
                }
                DatabaseManager.update((Context)version.getMyContext(), (TableRow)version.getMyRow());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version[] search(Context context, String query, int offset, int limit) throws SQLException {
        Integer int_param;
        if (query == null) {
            query = "";
        }
        String params = "%" + query.toLowerCase() + "%";
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT * FROM versionitem WHERE versionitem_id = ? OR ");
        queryBuf.append("LOWER(handle) LIKE LOWER(?) OR item_id = ? OR to_char(version_date, 'YYYY-MM-DD') like ? ORDER BY item_id,version_number ASC ");
        if (limit > 0) {
            queryBuf.append(" LIMIT ? ");
        }
        if (offset > 0) {
            queryBuf.append(" OFFSET ? ");
        }
        String dbquery = queryBuf.toString();
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = -1;
        }
        Object[] paramArr = new Object[]{int_param, params, int_param, params};
        if (limit > 0 && offset > 0) {
            paramArr = new Object[]{int_param, params, int_param, params, limit, offset};
        } else if (limit > 0) {
            paramArr = new Object[]{int_param, params, int_param, params, limit};
        } else if (offset > 0) {
            paramArr = new Object[]{int_param, params, int_param, params, offset};
        }
        TableRowIterator rows = DatabaseManager.query((Context)context, (String)dbquery, (Object[])paramArr);
        try {
            List versionRows = rows.toList();
            Version[] versions = new Version[versionRows.size()];
            for (int i = 0; i < versionRows.size(); ++i) {
                TableRow row = (TableRow)versionRows.get(i);
                Version fromCache = (Version)context.fromCache(Version.class, row.getIntColumn(EPERSON_ID));
                versions[i] = fromCache != null ? fromCache : new VersionImpl(context, row){};
            }
            Version[] versionArray = versions;
            return versionArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static int searchResultCount(Context context, String query) throws SQLException {
        Integer int_param;
        if (query == null) {
            query = "";
        }
        String dbquery = "%" + query.toLowerCase() + "%";
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = -1;
        }
        TableRow row = DatabaseManager.querySingle((Context)context, (String)"SELECT count(*) as epcount FROM versionitem WHERE versionitem_id = ? OR LOWER(handle) LIKE LOWER(?) OR item_id = ? OR to_char(version_date, 'YYYY-MM-DD') like ?", (Object[])new Object[]{int_param, dbquery, int_param, dbquery});
        Long count = "oracle".equals(ConfigurationManager.getProperty((String)"db.name")) ? Long.valueOf(row.getIntColumn("epcount")) : Long.valueOf(row.getLongColumn("epcount"));
        return count.intValue();
    }

    public static Bitstream[] findAllBitstreams(Context context, int verisonId) {
        ArrayList<Bitstream> bitstreamsList = new ArrayList<Bitstream>();
        try {
            TableRowIterator tri = DatabaseManager.queryTable((Context)context, (String)"version2bitstream", (String)("SELECT * FROM version2bitstream where version_id=" + verisonId), (Object[])new Object[0]);
            if (tri.hasNext()) {
                TableRow tr = tri.next();
                Bitstream fromCache = (Bitstream)context.fromCache(Bitstream.class, tr.getIntColumn(BITSTREAM_ID));
                if (fromCache != null) {
                    bitstreamsList.add(fromCache);
                } else {
                    bitstreamsList.add(Bitstream.find((Context)context, (int)tr.getIntColumn(BITSTREAM_ID)));
                }
            } else {
                return null;
            }
            Bitstream[] bitstreams = new Bitstream[bitstreamsList.size()];
            bitstreams = bitstreamsList.toArray(bitstreams);
            return bitstreams;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void addBitstreams(Context context, int versionId, Bundle[] bundles) throws SQLException {
        for (Bundle bundle : bundles) {
            for (Bitstream bitstream : bundle.getBitstreams()) {
                TableRow mappingRow = DatabaseManager.row((String)"version2bitstream");
                mappingRow.setColumn("version_id", versionId);
                mappingRow.setColumn(BITSTREAM_ID, bitstream.getID());
                DatabaseManager.insert((Context)context, (TableRow)mappingRow);
            }
        }
    }
}

