/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamUtil;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionDAO;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;
import org.dspace.workflow.WorkflowItem;

public class VersionImpl
implements Version {
    private EPerson eperson;
    private int itemID = -1;
    private Bitstream bitstream;
    private Bitstream oreBitstream;
    private Context myContext;
    private TableRow myRow;

    protected VersionImpl(Context c, TableRow row) {
        this.myContext = c;
        this.myRow = row;
        c.cache((Object)this, row.getIntColumn("versionitem_id"));
    }

    @Override
    public int getVersionId() {
        return this.myRow.getIntColumn("versionitem_id");
    }

    @Override
    public EPerson getEperson() {
        try {
            if (this.eperson == null) {
                return EPerson.find((Context)this.myContext, (int)this.myRow.getIntColumn("eperson_id"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.eperson;
    }

    public void setEperson(EPerson ePerson) {
        this.eperson = ePerson;
        this.myRow.setColumn("eperson_id", ePerson.getID());
    }

    @Override
    public int getItemID() {
        return this.myRow.getIntColumn("item_id");
    }

    @Override
    public Item getItem() {
        try {
            if (this.getItemID() == -1) {
                return null;
            }
            return Item.find((Context)this.myContext, (int)this.getItemID());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Bitstream getAIPBitstream() {
        try {
            if (this.bitstream == null) {
                this.bitstream = Bitstream.find((Context)this.myContext, (int)this.myRow.getIntColumn("bitstream_id"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.bitstream;
    }

    @Override
    public void setAIPBitstream(int bitstream_id) {
        try {
            Bitstream old = this.getAIPBitstream();
            this.bitstream = Bitstream.find((Context)this.myContext, (int)bitstream_id);
            this.myRow.setColumn("bitstream_id", bitstream_id);
            DatabaseManager.update((Context)this.myContext, (TableRow)this.myRow);
            this.myContext.addEvent(new Event(1, 0, bitstream_id, null));
            if (old != null) {
                BitstreamUtil.delete(this.myContext, old, true);
                this.myContext.addEvent(new Event(32, 0, old.getID(), null));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Bitstream getOREBitstream() {
        try {
            if (this.oreBitstream == null) {
                this.oreBitstream = Bitstream.find((Context)this.myContext, (int)this.myRow.getIntColumn("ore_bitstream_id"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.oreBitstream;
    }

    @Override
    public void setOREBitstream(int bitstream_id) {
        try {
            Bitstream old = this.getOREBitstream();
            this.oreBitstream = Bitstream.find((Context)this.myContext, (int)bitstream_id);
            this.myRow.setColumn("ore_bitstream_id", bitstream_id);
            DatabaseManager.update((Context)this.myContext, (TableRow)this.myRow);
            this.myContext.addEvent(new Event(1, 0, bitstream_id, null));
            if (old != null) {
                BitstreamUtil.delete(this.myContext, old, true);
                this.myContext.addEvent(new Event(32, 0, old.getID(), null));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void setItemID(int itemID) {
        this.itemID = itemID;
        if (itemID == -1) {
            this.myRow.setColumnNull("item_id");
        } else {
            this.myRow.setColumn("item_id", itemID);
        }
    }

    @Override
    public Date getVersionDate() {
        return this.myRow.getDateColumn("version_date");
    }

    public void setVersionDate(Date versionDate) {
        this.myRow.setColumn("version_date", versionDate);
    }

    @Override
    public int getVersionNumber() {
        return this.myRow.getIntColumn("version_number");
    }

    @Override
    public void setVersionNumber(int versionNumber) {
        this.myRow.setColumn("version_number", versionNumber);
    }

    @Override
    public String getSummary() {
        return this.myRow.getStringColumn("version_summary");
    }

    public void setSummary(String summary) {
        this.myRow.setColumn("version_summary", summary);
    }

    @Override
    public String getVerisonLog() {
        return this.myRow.getStringColumn("version_log");
    }

    @Override
    public void setVersionLog(String summary) {
        this.myRow.setColumn("version_log", summary);
    }

    @Override
    public int getVersionHistoryID() {
        return this.myRow.getIntColumn("versionhistory_id");
    }

    public void setVersionHistory(int versionHistoryID) {
        this.myRow.setColumn("versionhistory_id", versionHistoryID);
    }

    public Context getMyContext() {
        return this.myContext;
    }

    protected TableRow getMyRow() {
        return this.myRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        return this.getVersionId() == version.getVersionId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.getVersionId() ^ this.getVersionId() >>> 32);
        return hash;
    }

    @Override
    public String getHandle() {
        return this.myRow.getStringColumn("handle");
    }

    public void setHandle(String handle) {
        this.myRow.setColumn("handle", handle);
    }

    @Override
    public String[] getRestoreVersionLink(Context context, String knotId, String contextPath, boolean isLatestVersion) {
        String[] link = new String[2];
        Bitstream aipBitstream = this.getAIPBitstream();
        Item item = this.getItem();
        if (aipBitstream != null) {
            if (!isLatestVersion) {
                if (item != null) {
                    link[0] = contextPath + "/item/versionhistory?versioning-continue=" + knotId + "&versionID=" + this.getVersionId() + "&itemID=" + item.getID() + "&submit_restore";
                    link[1] = "Restore";
                } else {
                    link[0] = contextPath + "/item/versionhistory?versioning-continue=" + knotId + "&versionID=" + this.getVersionId() + "&itemID=-1&submit_restore";
                    link[1] = "Restore";
                }
            } else if (item != null) {
                // empty if block
            }
        } else {
            link[0] = "";
            link[1] = "";
        }
        return link;
    }

    @Override
    public String[] getViewVersionLink(Context context, String knotId, String contextPath, boolean isLatestVersion) {
        String[] link = new String[2];
        Bitstream aipBitstream = this.getAIPBitstream();
        Item item = this.getItem();
        if (aipBitstream != null) {
            if (!isLatestVersion) {
                if (item != null) {
                    link[0] = contextPath + "/item/versionhistory?versioning-continue=" + knotId + "&versionID=" + this.getVersionId() + "&itemID=" + item.getID() + "&submit_show";
                    link[1] = "View";
                } else {
                    link[0] = contextPath + "/item/versionhistory?versioning-continue=" + knotId + "&versionID=" + this.getVersionId() + "&itemID=" + this.getItemID() + "&submit_show";
                    link[1] = "View";
                }
            } else if (item == null) {
                link[0] = "";
                link[1] = "Item Deleted";
            }
        } else if (this.getItem() != null) {
            try {
                WorkspaceItem workspaceItem = WorkspaceItem.find((Context)context, (int)this.getItem().getID());
                if (workspaceItem != null) {
                    link[0] = contextPath + "/submit?workspaceID=" + this.getVersionId();
                    link[1] = "In Submission";
                } else {
                    WorkflowItem workflowItem = WorkflowItem.find((Context)context, (int)this.getItem().getID());
                    if (workflowItem != null) {
                        link[0] = contextPath + "/admin/display-workflowItem?wfiId=" + this.getVersionId();
                        link[1] = "In Workflow";
                    }
                }
            }
            catch (Exception e) {}
        } else {
            link[0] = "";
            link[1] = "Deleted";
        }
        return link;
    }

    @Override
    public boolean canEditSummary(Context context, String knotId, String contextPath, boolean isLatestVersion) {
        String[] link = new String[2];
        Bitstream aipBitstream = this.getAIPBitstream();
        Item item = this.getItem();
        if (aipBitstream != null) {
            if (!isLatestVersion) {
                return true;
            }
            return item != null;
        }
        return this.getItem() != null;
    }

    @Override
    public boolean isLastestVersion(Context context, VersionHistory history) {
        boolean isLatestVersion = false;
        if (history == null) {
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            history = versioningService.findVersionByHistoryId(context, this.getVersionHistoryID());
        }
        if (this.getVersionNumber() == history.getLatestVersion().getVersionNumber()) {
            isLatestVersion = true;
        }
        return isLatestVersion;
    }

    @Override
    public Bitstream[] getBitstreams(Context context) {
        return VersionDAO.findAllBitstreams(context, this.getVersionId());
    }
}

